/* c200m001 -- algorithm 001 -- listen for several keys */

/*
    Copyright pending, Intelligistics, Inc.

    Please see the notice in the main module associated with 
    this submodule: c200.c

*/
/*
    Revisions:

    200 -- gwl I*I 19-Jun-90 -- modified from c200key
		   24-Oct-91 -- fix keydown problem
*/

/* definitions */
#include 	"cmtprog.h"
#include	"linterp.h"				/* macros for interpolation */
#include	"cscdef.h"				/* definitions and externals */
#include	"keydef.h"
#include	"stdio.h"
#include	"ascdef.h"				/* definitions for m001s in */
#include	"ctype.h"				/* for text routines */
#include	"string.h"

void m001reset(struct m001data *mp);

/* temporary areas for invoking cascade */

int		dur_in[NUSEMAX];			/* durations */
int		art_in[NUSEMAX];			/* articulations */


/* other constants */

struct m001data *curmp=NULL;


/******************************************************************************
    m001down -- save keys pressed and when
******************************************************************************/

void m001down(mp,ch,p,v)
struct m001data	*mp;	/* data area */
int				ch;		/* channel */
int				p;		/* pitch */
int				v;		/* velocity */
{
    curmp=mp;							/* for various printouts etc. */

/*
gprintf(TRANS, "m001down: mp %u time %ld, ch %d, p %d, v %d\n",mp,virttime,ch,p,v);
gprintf(TRANS, "          #kd %d, #ku %d, listen? %d\n",
			mp->nkeysdown,mp->nkeysup,mp->listening);
gprintf(TRANS, "          net %d\n",mp->nkeysnow);
*/
    if (mp->nkeysdown>=NKEYSIN-1)		/* check for overflow */
    {
	gputchar(BEL);
	gprintf(TRANS, "m001down: too many\n");
    }
    else if (mp->nkeysdown>NOKEYSDOWN	/* check for decrease in time */
	  && virttime<mp->time_down[mp->nkeysdown-1])
    {
	gputchar(BEL);
	gprintf(TRANS, "m001down: time error, reset\n");
	m001reset(mp);
	mp->timelast=virttime;
    }
    else
    {
	if (mp->nkeysnow<=0)			/* if waiting for reset */
	{
	    if ( virttime-mp->timelast > mp->resetdelay )
	    {
		m001reset(mp);			/* waited too long */
	    }
	}
	mp->nkeysnow++;					/* count one on */
	mp->timelast=virttime;			/* begin measure for a reset delay */

	if (!mp->listening) return;		/* skipping until reset */

	/* ok, save data */

	mp->time_down[++mp->nkeysdown]=virttime;
	mp->time_up[mp->nkeysdown]=-1;			/* signal not up */
	mp->key_in[mp->nkeysdown]=p;
	mp->vel_in[mp->nkeysdown]=v;
/*
gprintf(TRANS, "m001down: #kd %d, net %d\n",mp->nkeysdown,mp->nkeysnow);
*/
    }
}


/******************************************************************************
    m001elem -- compute note component element
******************************************************************************/

void m001elem(mp,ep,inp,dur)
struct m001data *mp;		/* points to data area */
struct	elemval	*ep;		/* points to element parameters */
int				inp[];		/* key press data */
int				dur;		/* first interval */
{
    double			temp;

    if (!dur)					/* want a non-zero duration */
    {
	dur=1;
    }

    ep->valmin=inp[0];
    if (mp->nkeysuse<=3)
    {
	if (mp->nkeysuse==2)
	    ep->valmax=inp[1];
	else
	    ep->valmax=ep->valmin;
    }
    else
    {
	ep->valmax=inp[1];
	if (mp->nkeysuse>4)
	{
	    ep->incmin=inp[2]-inp[0];
	    if (mp->nkeysuse<=5)
	    {
		ep->incmax=ep->incmin;
	    }
	    else
	    {
		ep->incmax=inp[3]-inp[1];
		if (mp->nkeysuse>6)
		{
		    temp=ep->incmin;
		    temp=inp[4]-inp[2]-temp;
		    temp=temp/dur;
		    ep->chipbmin=temp*mp->cp->beat;
		    if (mp->nkeysuse<=7)
		    {
			ep->chipbmax=ep->chipbmin;
		    }
		    else
		    {
			temp=ep->incmax;
			temp=inp[5]-inp[3]-temp;
			temp=temp/dur;
			ep->chipbmax=temp*mp->cp->beat;
		    }
		}
	    }
	}
    }
}


/******************************************************************************
    m001init -- initialize key scan
******************************************************************************/

void m001init(mp)
struct m001data *mp;		/* points to data area */
{
/*
gprintf(TRANS, "m001init mp %u\n",mp);
*/
    mp->timelast=virttime-mp->resetdelay;
    m001reset(mp);

}


/******************************************************************************
    m001parmdata -- print computed note elements
******************************************************************************/

void m001parmdata()
{
    int				i;
    char			*t="pdal";
    struct elemval	*ep;
    struct cascabs	*cp=(struct cascabs *)curmp->cp;

    if (!curmp) return;

    gprintf(TRANS, "\n     min    max   imin   imax   cpbmin   cpbmax\n");
    for (i=0; i<4; i++)
    {
	ep=&cp->p[i];
	gprintf(TRANS, "%c %6d %6d %6d %6d %8.4f %8.4f\n",
	    t[i], ep->valmin, ep->valmax, ep->incmin, ep->incmax,
	    ep->chipbmin, ep->chipbmax);
    }
}


/******************************************************************************
     m001prtdata -- print input key data
******************************************************************************/

void m001prtdata()
{
    int		i;

    if (!curmp) return;

    gprintf(TRANS, "\n    chan  key  vel  time_down    time_up    dur    art\n");
    for (i=0; i<curmp->nkeysuse; i++)
    {	gprintf(TRANS, "%d: %4d %4d %10ld %10ld %6d %6d\n",
	    i,curmp->key_in[i],curmp->vel_in[i],
	    curmp->time_down[i],curmp->time_up[i],
	    dur_in[i],art_in[i]);
    }
}


/******************************************************************************
    m001reset -- initialize/reset key inputs
******************************************************************************/

void m001reset(mp)
struct m001data *mp;		/* points to data area */
{
/*
gprintf(TRANS, "m001reset mp %u\n",mp);
*/
    mp->nkeysdown=NOKEYSDOWN;			/* no down's yet accepted */
    mp->nkeysup=0;						/* got no down+up's */
    mp->listening=1;					/* accept down's that come in */
    mp->nkeysnow=0;						/* nothing down */
}


/******************************************************************************
    m001startcasc -- start a cascade based on input keys
******************************************************************************/

void m001startcasc(mp)
struct m001data *mp;		/* points to data area */
{

    struct	cascabs	*cp;
    struct	elemval	*pit;
    struct	elemval	*dur;
    struct	elemval	*art;
    struct	elemval	*lou;
    int		i;

    /* links to cascades variables */

    cp=(struct	cascabs	*)mp->cp;
    pit=&cp->p[0];
    dur=&cp->p[1];
    art=&cp->p[2];
    lou=&cp->p[3];

/*
gprintf(TRANS, "cp %u, pit %u, dur %u, art %u, lou %u\n",cp,pit,dur,art,lou);
gprintf(TRANS, "m001startcasc: nkeysdown %d, nkeysup %d\n",mp->nkeysdown,mp->nkeysup);
*/

    /* calculate durations and articulations */

    for (i=0; i<mp->nkeysuse; i++)
    {
	dur_in[i]=mp->time_down[i+2]-mp->time_down[i];
	art_in[i]=mp->time_up[i]-mp->time_down[i];
    }

    /* generate component elements */

    m001elem(mp,pit,mp->key_in,dur_in[0]);
    if (mp->nkeysuse>2)
	m001elem(mp,dur,dur_in,dur_in[0]);
    m001elem(mp,art,art_in,dur_in[0]);
    m001elem(mp,lou,mp->vel_in,dur_in[0]);

    /* start cascade */

    cascinit(mp->cp);
    cascade(mp->cp);

}


/******************************************************************************
    m001up -- save when keys released and check for enough
******************************************************************************/

void m001up(mp,ch,p)
struct m001data *mp;	/* points to data area */
int				ch;		/* channel */
int				p;		/* pitch */
{
    int		i;
    int		j;

    curmp=mp;								/* for various printouts etc. */

/*
gprintf(TRANS, "m001up:  time %ld, ch %d, p %d\n",virttime,ch,p);
gprintf(TRANS, "         #kd %d, #ku %d, listen? %d\n",
			mp->nkeysdown,mp->nkeysup,mp->listening);
gprintf(TRANS, "         net %d\n",mp->nkeysnow);
*/
    mp->timelast=virttime;					/* begin wait for a reset delay */
    mp->nkeysnow--;							/* one less down */

    if (!mp->listening) return;				/* nothing to process, skip up's */

    for (i=0; i<=mp->nkeysdown; i++)		/* search for key down */
    {
	if ( mp->key_in[i] == p				/* find the key */
	  && mp->time_up[i] == -1 )			/* and not up yet */
	{
	    mp->time_up[i]=virttime;			/* save the time */
	    break;
	}
    }

    if (i>mp->nkeysdown)					/* signal if not found */
    {
	gputchar(BEL);
	gprintf(TRANS, "m001up: %d has no key down\n",p);
	gprintf(TRANS, "#keys down %d\n",mp->nkeysdown);
	for (i=0; i<=mp->nkeysdown; i++)
	{
	    gprintf(TRANS, "%3d %4d %10ld\n",i,mp->key_in[i],mp->time_down[i]);
	}
	m001reset(mp);
    }
    else if (mp->time_up[i]<mp->time_down[i])
					    /* check for decrease in time */
    {
	gputchar(BEL);
	gprintf(TRANS, "m001up: time error, reset\n");
	m001reset(mp);
    }
    else									/* check for single press */
    {
	if ( i < mp->nkeysuse )				/* if one of first needed to end */
	{
	    ++mp->nkeysup;					/* tally it */
	}

	if ( i == mp->nkeysdown				/* if it's the last key down */
	     && !(i&1) )						/* and it's alone (not a pair) */
	{									/* double it */
	    mp->key_in[++mp->nkeysdown]=mp->key_in[i];
	    mp->vel_in[mp->nkeysdown]=mp->vel_in[i];
	    mp->time_down[mp->nkeysdown]=mp->time_down[i];
	    mp->time_up[mp->nkeysdown]=mp->time_up[i++];
	    if ( i < mp->nkeysuse )			/* if one of first needed to end */
	    {
		++mp->nkeysup;				/* tally it */
	    }

	}									/* now i==mp->nkeysdown */
/*
gprintf(TRANS, "m001up:   #ku %d, net %d\n",mp->nkeysup,mp->nkeysnow);
*/
	while ( mp->nkeysup >= mp->nkeysuse )	/* if all needed are up */
	{
	    if (mp->listening)				/* if accepting keys */
		m001startcasc(mp);			/* interpret the needed keys */
	    mp->nkeysup=0;					/* reset the number completed */
	    if (mp->usemore)				/* if cont w/ further downs */
	    {
		/* move them down */

		for (i=mp->nkeysuse,j=0; i<=mp->nkeysdown; i++,j++)
		{
		    mp->key_in[j]=mp->key_in[i];
		    mp->vel_in[j]=mp->vel_in[i];
		    mp->time_down[j]=mp->time_down[i];
		    mp->time_up[j]=mp->time_up[i];
		    if ( j < mp->nkeysuse	/* if it's one needed */
		      && mp->time_up[j] != -1 )	/* and it's up */
		    {
			mp->nkeysup++;		/* count it */
		    }
		}
		mp->nkeysdown-=mp->nkeysuse;/* now there are less down */
/*
gprintf(TRANS, "m001up: usemore: #kd %d #ku %d\n",mp->nkeysdown,mp->nkeysup);
*/
	    }
	    else							/* otherwise, stop mp->listening */
	    {
		mp->listening=0;
/*
gprintf(TRANS, "m001up: nomore: net %d listening %d\n",mp->nkeysnow,mp->listening);
*/
	    }
	}
    }
}

