/* c200fio -- file I/O for c200 */

/*
    Copyright pending, Intelligistics, Inc.

    Please see the notice in the main module associated with 
    this submodule: c200.c

*/

/*
    Revisions:

    102 -- gwl I*I 20-Apr-89 -- created
    103 -- gwl I*I 10-Nov-89 -- prepare for export
    200 -- gwl I*I 16-Jun-90 -- reformat
		   19-Jun-90 -- mode supervisor
*/

/* definitions */

#include	"cmtprog.h"
#include	"cscdef.h"	/* definitions and externals */
#include	"stdio.h"
#include	"string.h"
#include	"ascdef.h"	/* definitions for keys in */
#include	"ctype.h"	/* for text routines */

/* external data  */

static	char	save[LTEXT];	/* file name save area */
extern	void	(*yes_do)();	/* invoked when response is in */
extern	int	yes_mode;	/* 1 <=> requesting yes/no response */

void read_elem(FILE *fp, struct elemabs *ep);
void write_elem(FILE *fp, struct elemabs *ep);
void write_list(FILE *fp, int n, char *fmt, char *ip, size_t li);
void read_list(FILE *fp, int nmax, char	*fmt, char *ip, size_t li);			/* length of item */
void read_close(FILE *fp, char *name);
void write_cont(void);

/******************************************************************************
    read file
******************************************************************************/

void read_file(name)
char	*name;		/* file name */
{
    FILE			*fp;	/* input file pointer */
    FILE			*read_open();

    /* points to current casc parameters: */
    struct	cascabs	*cp=(struct cascabs *)curcp;
    int				i,n;	
    char			*tp;

    /* open and check whether file exists */

    if (!(fp=read_open(name)))
	return;

    /* read title */

    tp=cp->t;
    while((*tp=fgetc(fp))!='\n'){
	if ((*tp==EOF)||(tp-cp->t>=LTEXT)) {
	    gprintf(TRANS, "read_file: %s is too short.\n",name);
	    return;
	} else
	    tp++;
    }
    *tp='\0';

    /* read items */

    read_list(fp,CASC_NLONG,"%ld",(char *)cp->l,sizeof(long));
    read_list(fp,CASC_NINT ,"%d",(char *)cp->i,sizeof(int));

    /* read values for each element */

    fscanf(fp,"%d",&n);		/* number of elements n input */
    if (n>CASC_NELEM) {
	gprintf(TRANS, "read_list: %d elements skipped\n",n-CASC_NELEM);
	n=CASC_NELEM;
    }
    else if (n<CASC_NELEM)
	gprintf(TRANS, "read_list: %d elements not changed\n",CASC_NELEM-n);
    for (i=0; i<n; i++)
	read_elem(fp,(struct elemabs *)&cp->p[i]);

    /* close file */

    read_close(fp,name);

    /* recalculate floats */

    cascinit(curcp);
}


/******************************************************************************
    read note element parameters
******************************************************************************/

void read_elem(fp,ep)
FILE				*fp;	/* output file pointer */
struct	elemabs		*ep;	/* points to element parameter */
{
    read_list(fp,ELEM_NDOUBLE,"%lf",(char *)ep->d,sizeof(double));
    read_list(fp,ELEM_NLONG,  "%ld",(char *)ep->l,sizeof(long));
    read_list(fp,ELEM_NINT,   "%d", (char *)ep->i,sizeof(int));
}

/******************************************************************************
    read an array of items
******************************************************************************/

void read_list(fp,nmax,fmt,ip,li)
FILE		*fp;		/* output file */
int			nmax;		/* max number of items */
char		*fmt;		/* format for scanf */
char		*ip;		/* points to first data item */
size_t		li;			/* length of item */
{
    int		n;

    fscanf(fp,"%d",&n);			/* number of items */

    if (n>nmax)
	gprintf(TRANS, "read_list: %d input skipped\n",n-nmax);
    else if (n<nmax)
	gprintf(TRANS, "read_list: %d values not changed\n",nmax-n);

    while(n-->0){					/* for each item */
	if(nmax-->0) {			/* if there's room */
	    fscanf(fp,fmt,ip);	/* read it */
	    ip+=li;
	}
    }
}




/******************************************************************************
    open and check whether file exists
******************************************************************************/

FILE *
read_open(name)
char	*name;		/* the file */
{
    FILE	*fp;

    if (!(fp=fopen(name,"ra"))) {
	gprintf(TRANS, "read_open: %s doesn't exist\n",name);
	perror("read_open");
    }
    return(fp);
}



/******************************************************************************
    close file
******************************************************************************/

void read_close(fp,name)
FILE	*fp;		/* this one */
char	*name;		/* by name */
{
    if (fclose(fp)<0) {
	gprintf(TRANS, "read_close: unable to close %s\n",name);
	perror("read_close");
    }
}

#ifdef MACINTOSH
int access(name, zero)
  char *name;
  int zero;
{
    FILE *f = fopen(name, "w");
    if (f) {
	fclose(f);
	return true;
    }
    return false;
}
#endif


/******************************************************************************
    write file
******************************************************************************/

void write_file(name)
char	*name;		/* file name */
{
    /* save name */

    strcpy(save,name);

    /* check whether file exists */

    if (!access(name,0)) {
	gprintf(TRANS, "write_file: %s exists.  OK to overwrite?\n",name);
	yes_mode=1;
	yes_do=write_cont;
	return;
    }
    write_cont();
}

/******************************************************************************
    continuation of write routine following "yes" response
******************************************************************************/

void write_cont(void)
{

    FILE			*fp;	/* output file pointer */
			    /* points to current casc parameters: */
    struct	cascabs	*cp=(struct cascabs *)curcp;
    int				i;	

    /* open the output file */

    if (!(fp=fopen(save, "wa"))) {
	gprintf(TRANS, "write_cont: unable to open for write: %s\n",save);
	perror("write_cont: ");
	return;
    }

    /* write items */

    fprintf(fp,"%s\n",cp->t);
    write_list(fp,CASC_NLONG," %ld",(char *)cp->l,sizeof(long));
    write_list(fp,CASC_NINT ," %d", (char *)cp->i,sizeof(int));
    fprintf(fp,"%d\n",CASC_NELEM);
    for (i=0; i<CASC_NELEM; i++)
	write_elem(fp,(struct elemabs *)&cp->p[i]);

    /* close file */

    if (fclose(fp)<0) {
	gprintf(TRANS, "write_cont: unable to close for write: %s\n",save);
	perror("write_cont: ");
	return;
    }
}


/******************************************************************************
    write note element parameters
******************************************************************************/

void write_elem(fp,ep)
FILE				*fp;	/* output file pointer */
struct	elemabs		*ep;	/* points to element parameter */
{
    write_list(fp,ELEM_NDOUBLE," %lg",(char *)ep->d,sizeof(double));
    write_list(fp,ELEM_NLONG,  " %ld",(char *)ep->l,sizeof(long));
    write_list(fp,ELEM_NINT,   " %d", (char *)ep->i,sizeof(int));
}


/******************************************************************************
    write an array of items
******************************************************************************/

void write_list(fp,n,fmt,ip,li)
FILE		*fp;		/* output file */
int			n;			/* number of items */
char		*fmt;		/* format for printf */
char		*ip;		/* points to first data item */
size_t		li;			/* length of item */
{
    union	{
	char	*cp;
	double	*dp;
    } p;

    p.cp=ip;
    fprintf(fp,"%d",n);	/* number of items */
    while(n--){			/* for each item */
	fprintf(fp,fmt,*p.dp);
	p.cp+=li;
    }
    fputc('\n',fp);
}
