/* sched.h -- controller that takes updates from a matcher and controls
   a seq
 */

typedef struct sched_struct {
    seq_type seq;
} *sched_type, sched_node;

extern char sched_syntax[];

sched_type sched_create(seq_type seq, time_type patience);
void sched_destroy(sched_type sched);
void sched_flush(sched_type sched);
void sched_jump_to(sched_type sched, time_type dest);
void sched_match(sched_type sched, int id, time_type rtime,
		 time_type vtime, boolean last_flag, time_type next_match);
void sched_reset(sched_type sched);

void creeper();
