/*************************************************************************
 *
 *      match.h -- matcher generic abstract data type
 *
 *************************************************************************/

/* Generic matcher header:
 * (The representation of every matcher starts with with this header.) */
typedef struct match_struct {
    iter_type iter;
    int id;
    sched_type sched;
} match_node, *match_type;

extern char match_syntax[];

#define match_alloc() (match_type) memget(sizeof(match_node))
match_type match_create(iter_type iter, int id, sched_type sched);
/* match_type match_clone(); */
void match_destroy(match_type self);
void match_event(match_type self, int k);
#define match_free(m) memfree((char *) (m), sizeof(match_node))
time_type match_jump_to(match_type self, time_type dest, boolean *last_flag);
void match_reset(match_type self);
