/*************************************************************************
 *
 *      iter.h -- score iterator abstract data type
 *
 *      Copyright (C) 1987 John H. Maloney
 *      All rights reserved
 *
 *************************************************************************/

/****************************************************************************
*
*  Concrete Representation
*
****************************************************************************/

typedef struct iter_struct {
    cevt_type first_cevt;
    cevt_type curr_cevt;
    ulong curr_time;
    ushort max_dur;     /* used by iter_Sounding to know how far back to go */
} iter_node, *iter_type;

#define iter_alloc() (iter_type) memget(sizeof(iter_node))
#define iter_cevt_index(self, c) ((c) - ((self)->first_cevt))
iter_type iter_create(score_type score);
void    iter_destroy(iter_type iterator);

iter_type iter_clone(iter_type self);
#define iter_copy(target, source) target = source
#define iter_curr_cevt(iter) ((iter)->curr_cevt)
#define iter_curr_time(iter) ((iter)->curr_time)
#define iter_free(i) memfree((char *) (i), sizeof(iter_node))
void    iter_jump_to(iter_type self, ulong scoreTime);
void    iter_next_cevt_and_time(iter_type self, cevt_type *next_cevt,
				ulong *next_time);
void    iter_prev_cevt_and_time(iter_type self, cevt_type *prevCevt,
				ulong *prevTime);
void    iter_reset(iter_type self);
#define iter_set_next_cevt(next, iter, move) \
	{ ulong next_time; \
	  iter_next_cevt_and_time(iter, &next, &next_time); \
	  if (move) { iter->curr_cevt = next; \
			iter->curr_time = next_time; } }

#define iter_set_next_time(time, iter) \
	{ cevt_type nextCevt; \
	  iter_next_cevt_and_time(iter, &nextCevt, &time); }

#define iter_set_prev_cevt(prev, iter, move) \
	{ ulong prevTime; \
	  iter_prev_cevt_and_time(iter, &prev, &prevTime); \
	  if (move) { iter->curr_cevt = prev; \
			iter->curr_time = prevTime; } }


/* void iter_Sounding(); */
