#include "switches.h"
#include "cext.h"
#include "midifns.h"
#include "timebase.h"
#include "seq.h"
#include "evt.h"
#include "cevt.h"
#include "stdio.h"
#include "userio.h"


cevt_type cevt_make_cevts(nCevt, nextEvt, length)
  int nCevt;
  evt_type nextEvt;
  ulong *length;
  /*
   *    Make the Cevt array consistent with the Evt array.
   *    Returns the Cevt array
   *    *length is set to the total score duration.
   *
   *    CAUTION: Tricky code here!
   */
{
    cevt_type CevtArray = (cevt_type) MALLOC(nCevt * sizeof(cevt_type));
    cevt_type nextCevt = CevtArray;
    ulong lastDelta = 1; /* non-zero to create Cevt for the first evt */
    ulong lengthSoFar;

    lengthSoFar = evt_dtime(nextEvt);
    *nextCevt = nextEvt++;    /* Cevt for first evt sentinal */
    while (!evt_is_last(nextEvt)) {
	if (lastDelta > 0) {
	    *(++nextCevt) = nextEvt;
	}
	cevt_pitchset(nextCevt) |= cevt_hash(evt_pitch(nextEvt));
	lastDelta = evt_dtime(nextEvt);
	lengthSoFar += lastDelta;
	nextEvt++;
    }

    *(++nextCevt) = nextEvt;    /* Cevt for last evt sentinal */
    *length = lengthSoFar - 1;    /* compensate for initial value of lastDelta */

    return CevtArray;
}

/* cevt_search -- tells whether note is a member of ith cevt */
/*
 * returns a set with the note if found
 */
set_type cevt_search(note, cevt, evt_loc)
  int note;    /* the note (eg 60 = middle c) */
  cevt_type cevt;
  evt_type *evt_loc;    /* if found, the evt address is returned here */
{
    evt_type j;
    evt_type last = *(cevt + 1);
    
    for (j = *cevt; j < last; j++) {
	if (note == evt_pitch(j)) {
	    *evt_loc = j;
	    return int_to_set((int)(j - *cevt));
	}
    }
    return empty_set;
}


/* index to bitmap conversion table */
ulong i_to_s[] = {1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048,
    4096, 1<<13, 1<<14, 1<<15, 1L<<16, 1L<<17, 1L<<18, 1L<<19, 1L<<20, 
    1L<<21,1L<<22, 1L<<23, 1L<<24, 1L<<25, 1L<<26, 1L<<27, 1L<<28,
    1L<<29, 1L<<30, 1L<<31 };


/* num_in_set -- how many bits are on in s? */
/**/
int num_in_set(s)
  register int s;
{
    register int j;
    j = 0;
    while (s) {
	s &= s - 1;
	j++;
    }
    return j;
}

