function [chrom_energy,features,beats] = gen_chroma(fname,highcutoff,lowcutoff,calcfeat)

% If there is no beat tracker file (.btm), we'll default to uniform frames
% every 0.25 seconds
default_frame_size = 0.25;
power_min = 10 ^ -300;

subslice = 8;
numfeat = 18;

if exist('fname','var') & exist(fname,'file')
   [pathname,f,e] = fileparts(fname);
   filename = [f e];
else
   [filename pathname] = uigetfile('*.wav');   
end
if ~exist('highcutoff','var') | isempty(highcutoff)
   highcutoff = 2000;
end
if ~exist('lowcutoff','var') | isempty(lowcutoff)
   lowcutoff = 40;
end
if ~exist('calcfeat','var') | isempty(calcfeat)
   calcfeat = 0;
end

[siz,fs] = wavread([pathname '\' filename],'size');

if exist([pathname '\' strtok(filename,'.') '.btm'],'file')
    beats = load([pathname '\' strtok(filename,'.') '.btm'],'-ascii');
    mean_ibi = mean(diff(beats(:,3)));
    beats = round(beats(:,3)*fs);
else
    mean_ibi = default_frame_size;
    % beats = round((0:default_frame_size:(siz(1)/fs - 1))*fs) + 1;         % original buggy code
    beats = round((0:default_frame_size:(siz(1)/fs))*fs) + 1;               % new code
end    

maxdif = max(diff(beats));
trans_len = 2^ceil(log2(maxdif));
sub_len = trans_len/8;

% Calculate some stuff for chroma
samp2hz = fs/trans_len;
hz2samp = 1/samp2hz;
semi = 2.^(1/12);

bins = mod(log2(440*semi.^(1:12)),1);
[m,minbin] = min(bins);
[m,maxbin] = max(bins);
bins = [bins bins(minbin)+1 bins(maxbin)-1];

highcutoff = highcutoff*hz2samp;
lowcutoff = floor(lowcutoff*hz2samp);

logfrq = mod(log2(samp2hz*((lowcutoff:highcutoff)-1)),1);
diffs = abs(repmat(logfrq,[14,1]) - repmat(bins',[1,length(logfrq)]));
[m,mindiffs] = min(diffs);

chrom_inds = {};
for i=1:12
   chrom_inds{i} = find(mindiffs == i) + lowcutoff - 1;
end
chrom_inds{minbin} = [chrom_inds{minbin} find(mindiffs == 13)];
chrom_inds{maxbin} = [chrom_inds{maxbin} find(mindiffs == 14)];

last_spec = zeros(1,sub_len);
features = zeros(numfeat*2,length(beats-1));

chrom_energy = zeros(12,length(beats)-1);
h = waitbar(0,'Calculating chroma...');
for i=1:length(beats)-1
   
    % Ignore this part... we're not using these "features" in this version
   if calcfeat
      
      % Features: RMS_value, Spec_Mean, Spec_BW, Spec_Flux, Zero_CrossingsMFCC
      subfeat = zeros(subslice,numfeat); 
      slice = zeros(trans_len,1);
      
      dif = beats(i+1)-beats(i);
      slice(1:dif) = mean(wavread([pathname '\' filename],[beats(i) (beats(i+1)-1)]),2);
      
      subdif = floor(dif/subslice);
      for j = 1:subslice
         rng = (1:subdif) + subdif*(j-1);
         subfeat(j,1) = sum(abs(slice(rng)));
         subpad = zeros(1,sub_len);
         subpad(1:subdif) = slice(rng);
         subspec = abs(fft(subpad.*hamming(sub_len)'));
         subspec = subspec/sum(subspec);
         
         subfeat(j,2) = sum((0:(sub_len/2 - 1)).*subspec(1:sub_len/2))./sum(subspec(1:sub_len/2));
         subfeat(j,3) = sum((0:(sub_len/2 - 1)).^2.*subspec(1:sub_len/2))./sum(subspec(1:sub_len/2)) - subfeat(j,2).^2;
         subfeat(j,4) = sqrt(sum((subspec-last_spec).^2));
         
         last_spec = subspec;
         
         neg = subpad < 0;
         pos = subpad > 0;
         subfeat(j,5) = (length(find(neg(1:(end-1)) & pos(2:(end)))) + length(find(pos(1:(end-1)) & neg(2:(end)))))*subslice;
         
         subfeat(find(isnan(subfeat))) = 0;
         subfeat(j,6:18) = mfcc2(subpad(1:subdif),fs)';
         
      end
      
      mn = mean(subfeat);
      vr = var(subfeat);
      features(:,i) = [mn'; vr'];
   end
   
   
   waitbar(i/length(beats));   
   slice = zeros(trans_len,1);
   
   dif = beats(i+1)-beats(i);
   slice(1:dif) = mean(wavread([pathname '\' filename],[beats(i) (beats(i+1)-1)]),2);
   slice = slice.*hamming(length(slice));
   
   %spec = 10*log10(max(abs(fft(slice)), power_min));       % fixed code
   %spec = 10*log10(abs(fft(slice)));                       % original code
 spec = abs(fft(slice));
%    fft_result = fft(slice);
%    spec = (fft_result .* conj(fft_result)) / trans_len;

   for j=1:12
      chrom_energy(j,i) = mean(spec(chrom_inds{j}));
   end
end

close(h)
