window_size = 0.25;   % In seconds
calc_features = 0;
ratioHrld = 0;

% first song
[filename1 pathname1] = uigetfile('*.wav');   

[p1,f1,e1] = fileparts([pathname1 '\' filename1]);

[chrom_energy1,features1,beats1] = gen_chroma([pathname1 filename1],2000,20,calc_features);
[siz1,fs1] = wavread([p1 f1 e1],'size');

% Normalize the chroma energy
norm_energy1 = chrom_energy1 - repmat(mean(chrom_energy1),[12 1]);
norm_energy1 = norm_energy1./repmat(std(norm_energy1),[12 1]);


% second song
[filename2 pathname2] = uigetfile('*.wav');   

[p2,f2,e2] = fileparts([pathname2 '\' filename2]);

[chrom_energy2,features2,beats2] = gen_chroma([pathname2 filename2],2000,20,calc_features);
[siz2,fs2] = wavread([p2 f2 e2],'size');

% Normalize the chroma energy
norm_energy2 = chrom_energy2 - repmat(mean(chrom_energy2),[12 1]);
norm_energy2 = norm_energy2./repmat(std(norm_energy2),[12 1]);


% Use euclidean distance for as a correlation metric
cor_mat = zeros(size(norm_energy1, 2), size(norm_energy2, 2));
for i=1:length(norm_energy1)
   v = norm_energy1(:,i);
   vm = repmat(v,[1 size(norm_energy2,2)]);
   cor_mat(i,:) = sqrt(sum((norm_energy2-vm).^2));
end

figure('color', 'w');
imagesc(beats2(1:size(cor_mat,2))/fs2,beats1(1:size(cor_mat,1))/fs1,cor_mat);   
title(['Chroma Similarity Matrix : MIDI Rendered Audio vs. Audio Recording']); xlabel(['<',f2,'> Time(s)']); ylabel(['<',f1,'> Time(s)']); axis xy; colorbar
colormap(gray);
save([p1, f1, '-CompareSim.mat'], 'cor_mat', 'beats1', 'beats2', 'fs1', 'fs2', 'f1', 'f2', 'norm_energy1', 'norm_energy2', 'window_size');