#!/usr/local/bin/perl5 -w
#
# Simple test driver for UniRand's "best_match" fitter.

use strict;
use lib '/usr/lw2j/private/Stat/Perl';
use FileHandle;

require UniRand;
require GKQuantile;

autoflush STDOUT 1;


my $GKQ = GKQuantile::new GKQuantile();

read_data:  {
  # Snarf data from STDIN.  Since it may be big, we'll use
  # the GKQuantile code to sample the data.

  # Assume it to be univariate already.
  my $line = <STDIN>;

  (defined($line)) || last read_data;
  chomp($line);
  (defined($line)) || last read_data;

  # This regex should enable tossing any practically anything that
  # looks like a comment, while tolerating whitespace.
  if ($line =~ /^\s*([\d\.]+)/) {
    my $x = $1;
    $GKQ->insert($x);
  }

  redo read_data;
}






my $n = $GKQ->get_n();
my $s = $GKQ->get_s();
print "Read $n items, stored $s observations.\n";


my @dists_used = ();

{
  my %keytable = ();
  my @sample   = ();
  my $count    = 1001;
  my $step     = 1/($count-1);

  # Generate a sample based on $count points that should be equal
  # percentiles apart.
  for (my $pct=0.000; $pct <= 1; $pct += $step) {
    my $x = $GKQ->quantile($pct);

    if (!defined($x)) {
      my $err = undef;
      ($x, $err) = $GKQ->quantile_lax($pct);

      print "Warning:  LAX quantile <p=$pct, v=$x, e=$err>\n";
    }

    push @sample, $x;
  }


  my @initial_fits = UniRand::best_match(\@sample, 0.2);

  print "\n\n", "=" x 70, "\n", "Sample fits:\n", "=" x 70, "\n";
  UniRand::fit_report(@initial_fits);
}

exit 0;
