#ifndef QUEUE_H
#define QUEUE_H


#include "list.h"


/* Type Declaration:
*/


/* Queue -------------------------------------------------------------------
A queue is just a list with a redefined interface.
---------------------------------------------------------------------------*/

typedef struct tagQueue {

  tList* list;

} Queue;


/* Function Prototypes:
*/


/* queNew -------------------------------------------------------------------
Allocate, initialize, and return a pointer to a new Queue object.
Return NULL on allocation error.
---------------------------------------------------------------------------*/

Queue* queNew(void);


/* queDelete ----------------------------------------------------------------
Delete all elements in the queue including the Queue object.
---------------------------------------------------------------------------*/

void queDelete(Queue* queue, tDestructor destructor);


/* queFlush -----------------------------------------------------------------
Delete all elements in the queue but not the Queue object.
---------------------------------------------------------------------------*/

void queFlush(Queue* queue, tDestructor destructor);


/* quePush ---------------------------------------------------------------
Put new_ele in the rear of the queue. Return NULL on error, else new_ele.
---------------------------------------------------------------------------*/

void* quePush(Queue* queue, void* new_ele);


/* queHeadPush (added by alwong@andrew.cmu.edu) --------------------------
Put new_ele in the front of the queue. Return NULL on error, else new_ele.
---------------------------------------------------------------------------*/

void* queHeadPush(Queue* queue, void* new_ele);


/* quePop ----------------------------------------------------------------
Remove(don't delete) the element from the front of the queue and return it.
---------------------------------------------------------------------------*/

void* quePop(Queue* queue);


/* queTailPop (added by alwong@andrew.cmu.edu) ---------------------------
Remove(don't delete) the element from the front of the queue and return it.
---------------------------------------------------------------------------*/

void* queTailPop(Queue* queue);


/* quePeek ---------------------------------------------------------------
Return the element at the front of the queue without popping it.
---------------------------------------------------------------------------*/

void* quePeek(Queue* queue);


/* queLength -------------------------------------------------------------
Return the number of elements in the queue.
---------------------------------------------------------------------------*/

unsigned queLength(Queue* queue);

/* queTraverse --------------------------------------------------------------
Traverse the queue forward, passing each element to the visit function.
When visit is called, the entry whose element is passed is current.
The visit function must return TR_HALT or TR_CONTINUE.
---------------------------------------------------------------------------*/
void queTraverse(Queue* queue, tVisitFunc visit);

/* queDelete_exited_status (added) ------------------------------------------
---------------------------------------------------------------------------*/
void* queDelete_exited_status(Queue *queue, void *status);

#endif

/* end Queue interface */

