#include <string.h>
#include <stdio.h>
#include "queue.h"
#include "kernel_queues.h"

/*
 * Public Function Definitions:
 */

/* queNew ----------------------------------------------------------------
  Allocate, initialize, and return a pointer to a new Queue object.
  Return NULL on allocation error.
---------------------------------------------------------------------------*/

Queue* queNew()
{
  Queue* new_queue;

  if((new_queue = (Queue*) malloc(sizeof(struct tagQueue))) == NULL)
    return NULL;
  if((new_queue->list = lstNew()) == NULL) {
    free(new_queue);
    return NULL;
  }
  return new_queue;
}


/* queDelete -------------------------------------------------------------
  Delete all elements in the queue including the Queue object.
---------------------------------------------------------------------------*/

void queDelete(Queue* queue, tDestructor destructor)
{
  if(queue) {
    lstDelete(queue->list, destructor);
    free(queue);
  }
}


/* queFlush --------------------------------------------------------------
  Delete all elements in the queue but not the Queue object.
---------------------------------------------------------------------------*/

void queFlush(Queue* queue, tDestructor destructor)
{
  if(queue) lstFlush(queue->list, destructor);
}


/* quePush ---------------------------------------------------------------
  Put new_ele in the rear of the queue. Return NULL on error, else new_ele.
---------------------------------------------------------------------------*/

void* quePush(Queue* queue, void* new_ele)
{
  if(!queue) return NULL;
  return lstAppend(queue->list, new_ele);
}


/* queHeadPush (added by alwong@andrew.cmu.edu) --------------------------
  Put new_ele in the front of the queue. Return NULL on error, else new_ele.
---------------------------------------------------------------------------*/

void* queHeadPush(Queue* queue, void* new_ele)
{
  if(!queue) return NULL;
  return lstPrepend(queue->list, new_ele);
}


/* quePop ----------------------------------------------------------------
  Remove(don't delete) the element from the front of the queue and return it.
---------------------------------------------------------------------------*/

void* quePop(Queue* queue)
{
  void* ele;

  if(!queue) return NULL;
  if((ele = lstHead(queue->list)) != NULL)
    lstRemove(queue->list, DESTRUCTOR_NONE);
  return ele;
}

/* queTailPop (added by alwong@andrew.cmu.edu) ---------------------------
  Remove(don't delete) the element from the end of the queue and return it.
---------------------------------------------------------------------------*/

void* queTailPop(Queue* queue)
{
  void* ele;

  if(!queue) return NULL;
  if((ele = lstTail(queue->list)) != NULL)
    lstRemove(queue->list, DESTRUCTOR_NONE);
  return ele;
}

/* quePeek ---------------------------------------------------------------
  Return the element at the front of the queue without popping it.
---------------------------------------------------------------------------*/

void* quePeek(Queue* queue)
{
  if(!queue) return NULL;
  return lstHead(queue->list);
}


/* queLength -------------------------------------------------------------
  Return the number of elements in the queue.
---------------------------------------------------------------------------*/

unsigned queLength(Queue* queue)
{
  if(!queue) return 0;
  return lstLength(queue->list);
}

/* queTraverse --------------------------------------------------------------
  Traverse the queue forward, passing each element to the visit function.
  When visit is called, the entry whose element is passed is current.
  The visit function must return TR_HALT or TR_CONTINUE.
---------------------------------------------------------------------------*/
void queTraverse(Queue* queue, tVisitFunc visit)
{
  if(!queue || !visit) return;
  if(queLength(queue) == 0) return;

  /* go through the list now */
  lstTraverse(queue->list, visit);
 
}

/* queDelete_exited_status (added) ------------------------------------------
---------------------------------------------------------------------------*/
void* queDelete_exited_status(Queue *queue, void *status){
  
  tList *list;
  
  if (status == NULL || queue == NULL)
    return NULL;

  list = queue->list;

  if(!list) return NULL;
  if(list->length == 0) return NULL;
  list->current = list->head;
  do {
    if(((exited_status_t *)list->current->element)->pid == 
       ((exited_status_t *)status)->pid){
      lstRemove(list, DESTRUCTOR_FREE);
      return (void *)queue;
    }
  } while(lstNext(list));

  return NULL;

}

/* --------end Queue implementation ----*/
