: # Use perl
eval 'exec perl5 -w -S $0 "$@"'
if 0;

# it is faster to use something like
#!/usr/local/bin/perl5
# but this is more portable.

# generates the Koch curve of the i-th iteration (0= unit segment)

#
# $Log:	koch.pl,v $
# Revision 1.1  2003/09/01  14:57:15  lw2j
# Initial revision
#
# Revision 1.2  2002/03/10  15:33:18  christos
# *** empty log message ***
#
#


use strict;

my $verbose = 0;
my $debug = 0;
my $helpmsg = "USAGE: $0 [-h] [-v] [-n<iteration>] \n";
my $n = 4; # by default, 4 iterations
# my $printout = 0; # flag to printout the lookup table
# my $pfile; # name of printout file


my $nargs=0;

while( $_ = $ARGV[0], /^-/){
  shift;
  last if /^--$/;
  if( /^-D(.*)/){ $debug = $1 }
  if( /^-n(.*)/){ $n = $1 }
  if( /^-h/){ print $helpmsg ; exit; }
  if (/^-v/)    { $verbose++ }
  # if (/^-p(.*)/)    { $printout = 1; $pfile = $1;}
}

if( $verbose >= 1){
  warn "*** verbose=", $verbose, "\n";
  warn "*** num iterations=", $n, "\n";
}

my $rotAngle = 60/180 * 3.14159265;
# print "cos(60)= ", cos($rotAngle), "\n";
# print "sin(60)= ", sin($rotAngle), "\n";

kochprint( $n, 0.0, 0.0, 1.0, 0.0 );
# print the last point
print 1.0, " ", 0.0, "\n";

# prints the corner points of the n-th order Koch curve (line, actually)
# with starting point (xstart, ystart) and ending point (xend, yend)
sub kochprint{
  my @args = @_;
  my $nn; # order of the koch curve
  my $xstart;
  my $ystart;
  my $xend;
  my $yend;
  ($nn, $xstart, $ystart, $xend, $yend) = @_;
  if( $nn == 0 ){
    print $xstart, " ", $ystart , "\n";
    # DON'T print the last point
    # print $xend, " ", $yend, "\n";
    return;
  }
  # otherwise, recurse
  my @start_point = ($xstart, $ystart);
  my @end_point = ($xend, $yend);
  my @vec = ($xend - $xstart, $yend-$ystart);
  my ($dx, $dy) = @vec;

  my @pt1 = @start_point;
  my @pt2 = ($xstart + $dx / 3.0 , $ystart + $dy / 3.0);
  my @pt3 = ($xstart + $dx / 3.0 +
  $dx/3.0 * cos($rotAngle) - $dy/3.0 * sin($rotAngle),
  $ystart + $dy / 3.0 +
  $dx/3.0 * sin($rotAngle) + $dy/3.0 * cos($rotAngle) );
  my @pt4 = ($xstart + $dx *2.0/3.0, $ystart + $dy * 2.0/3.0);
  my @pt5 = @end_point;

  kochprint( $nn-1, @pt1, @pt2);
  kochprint( $nn-1, @pt2, @pt3);
  kochprint( $nn-1, @pt3, @pt4);
  kochprint( $nn-1, @pt4, @pt5);

}



