// doubling template array

#ifndef ARRAY_H
#define ARRAY_H

// uses shallow copy

template <class T>
class Array {
  public:
  Array(void);
  Array(unsigned int size, bool fixed=false);
  Array(const Array& other);
  virtual ~Array(void);

  unsigned int getCount(void) const { return (highest+1); };
  unsigned int getRange(void) const { return highest; };
  unsigned int getSize(void) const  { return capacity; };

  // disallow resizing?
  void fixSize(void)   { fixedSize = true;};
  void unfixSize(void) { fixedSize = false;};
  bool isFixedSize(void) const { return fixedSize;};
  void addItem(T& data);

  virtual T ref(unsigned int idx) const;
  virtual T& operator[](unsigned int idx);

  void clear(void) { fixedSize = false; resize(0); };

  // useful for trimming cruft; returns false if disallowed
  virtual bool resize(unsigned int newSize);

  // merge with another array, which gets concatenated to the
  // end of this one
  void merge(const Array<T>& other);

  void swap(unsigned int idx1, unsigned int idx2);

  // expensive!  preserves order
  void remove(unsigned int idx);

  // not expensive. does NOT preserve order.
  void remove2(unsigned int idx);

  // possibly helpful
  void compact(void) { resize(highest+1); };


  virtual void operator=(const Array<T>& other);

  // This cares *only* about contents, and not capacity
  virtual bool operator==(const Array<T>& other) const;
  virtual bool operator!=(const Array<T>& other) const;


  // After a *right shift*, results in 0..n-1 are undefined
  virtual Array<T> operator<<(unsigned int amount);
  virtual Array<T> operator>>(unsigned int amount);

  Array<T>& operator<<=(unsigned int amount);
  Array<T>& operator>>=(unsigned int amount);

  // Use only when required...
  const T* data(void) const { return arr; };

  protected:
  bool         fixedSize;
  int          highest;
  unsigned int capacity;
  T*           arr;
};

#endif
