: # Use perl...
eval 'exec perl5 -w -S $0 "$@"'
if 0;

#!/usr/bin/perl5 -w
#
############################################################
# $Id: fd.pl,v 1.7 2002/01/03 10:51:57 lw2j Exp $
#
# $Log:	fd.pl,v $
# Revision 1.7  2002/01/03  10:51:57  lw2j
# Uses Wrapper.  Misc changes.
#
# Revision 1.6  2001/12/16  15:52:26  lw2j
# Switched to Wrapper.pm.
#
# Revision 1.5  2001/08/22  17:21:29  lw2j
# Untabified (tab=8).
#
# Revision 1.4  2001/08/03  11:25:13  lw2j
# Added support for s_max, o_max.
#
# Revision 1.3  2001/06/01  14:02:27  lw2j
# Allows using SimpleWrapper for memory loads (needed for STDIN support).
#
# Revision 1.2  2001/05/29  18:04:21  lw2j
# Changed to reflect the new DiskFracDim.pm foo -- for
# instance, it reports *both* FD and slope because they're
# not the same when q is neither 1 nor 2.
#
# Revision 1.1  2000/11/12  14:41:06  lw2j
# Initial revision
#
# Revision 1.3  2000/10/24  18:00:46  lw2j
# Standardized path.
#
# Revision 1.2  2000/10/03  14:08:01  lw2j
# Added magic perl invoker.
#
# Revision 1.1  2000/07/18  13:27:11  lw2j
# Initial revision
#
############################################################
#
# A simple demo to invoke the FracDim package on a single file.
# It's not terribly nice coding.
#
use strict;

##### <change_me>
#
# Change this to where you placed the modules.
#
use lib '/afs/cs.cmu.edu/user/lw2j/shared/FracDim/FracDim';
##### </change_me>

use Symbol;

# Wrapper module now used instead of SimpleWrapper/DiskWrapper combo.
require Wrapper;
require DiskFracDim;


{
    my $in_fh   = gensym;
    my $dw_obj  = undef;
    my $fd_obj  = undef;

    my ($params_ref, $fname) = parse_arguments();


    if (defined($fname)) {
        open($in_fh, $fname) || die "Failed to open '$fname' (r):  ";

        if (exists($params_ref->{'memory'})) {
            $dw_obj = new Wrapper($in_fh);
        } else {
            $dw_obj = new Wrapper($in_fh);
            $dw_obj->set_buffer($dw_obj->{"NO_BUFFER"});
        }
    } else {
        $in_fh = \*STDIN;
        $dw_obj = new Wrapper($in_fh);
    }


    if (exists($params_ref->{'memory'})) {
        delete $params_ref->{'memory'};
    }

    $params_ref->{'data_o'} = $dw_obj;

    $fd_obj = new DiskFracDim(%{$params_ref});

    # $slope will be equal to $fd whenever $q==1 or $q==2.
    my ($fd, $y_int, $corr, $slope) = $fd_obj->fracdim();

    print "Fractal Dimension = $fd\n";
    print "Slope             = $slope\n";
    print "Y Intercept       = $y_int\n";
    print "Correlation       = $corr\n";

    if (defined($fname)) {
        close($in_fh);
    }

    exit 0;
}


#####################
sub print_usage_and_exit() {
    use File::Basename;

    my $progname = basename($0);

    print "$progname -- Interact with the DiskFracDim.pm module\n";
    print "Usage:\n";
    print "\n";
    print "$progname [-v] [-s] [-q nn] [-r_min nn] [-r_max nn]\n";
    print "          [-r_count nn] [-s_max nn] [-o_max nn]\n";
    print "          [-intervals nn] [filename]\n";
    print "\n";
    print "Exact parameter semantics are defined by the module.\n";
    print "\n";
    print " -v          Specifies 'verbose'.\n";
    print " -s          Use the slow all-pairs method for C2 -- more\n";
    print "             precise, but perhaps unbearably slow and vile\n";
    print "             in terms of memory consumption.\n";
    print " -m          Force loading all data into memory for speed.\n";
    print " -q          Box-counting exponent.\n";
    print " -r_min      Minimum radius the module will consider using.\n";
    print " -r_max      Maximum radius it'll try.\n";
    print " -r_count    Maximum number of radii it'll try.\n";
    print " -s_max      Maximum fraction of singletons allowed when\n";
    print "             reducing radius.\n";
    print " -o_max      Maximum occupancy (ratio, again) of objects to be\n";
    print "             in ONE cell when increasing radius.\n";
    print " -intervals  The number of intervals for the all-pairs method.\n";
    print "\n";
    print "The options after -s, except for -intervals, are all\n";
    print "specific to box-counting.\n";
    print "The actual input data is read from <STDIN> if no filename\n";
    print "is provided.";
    print "\n";

    exit 0;
}



# Returns a reference to a hash table of parameters.
#
# Always uses @ARGV0.
#
sub parse_arguments() {
    my $arg;
    my %params = ();
    my $fname  = undef;

    while (defined($arg = $ARGV[0]) && ($arg =~ /^-/)) {
        $arg = shift @ARGV;

        if ($arg eq '-v') {
            $params{'verbose'} = 1;
        } elsif ($arg eq '-m') {
            $params{'memory'} = 1;
        } elsif    ($arg eq '-s') {
            $params{'method'}  = 'slow';
        } elsif (($arg eq '-q')       ||
                 ($arg eq '-r_min')   ||
                 ($arg eq '-r_max')   ||
                 ($arg eq '-r_count') ||
                 ($arg eq '-s_max')   ||
                 ($arg eq '-o_max')   ||
                 ($arg eq '-intervals')) {

            $arg =~ s/^-//;
            my $val = shift @ARGV;

            defined($val) || die "Failed to supply value for -$arg";

            if ($val ne 'undef') {
                $params{$arg} = $val;
            } else {
                $params{$arg} = undef;
            }
        } elsif ($arg eq '--') {
            last;
        } else {
            print_usage_and_exit();
        }
    }

    $fname = shift @ARGV;

    return (\%params, $fname);
}
