/* File:     datawrapper.cc
 * Purpose:  To implement a generic interface for a flat-file 
 *           handler.
 * 
 * RCS:
 ************************************************************
 * $Id: DataWrapper.cc,v 1.2 2001/08/22 17:20:18 lw2j Exp $
 * $Log:	DataWrapper.cc,v $
// Revision 1.2  2001/08/22  17:20:18  lw2j
// Untabified.
// 
// Revision 1.1  2001/08/21  03:40:34  lw2j
// Initial revision
// 
 *
 ************************************************************
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <ctype.h>
#include "DataWrapper.h"


void DataWrapper::process_string(char *instr) {
  char *pc     = instr;
  char *not_ws = NULL;

  /* Make sure that it's not NULL. */
  if (!instr) {
    return;
  }

  /* Convert characters, and look for semicolon. */
  while (*pc) {
    if (*pc == ';') {
      *pc = '\0';
      break;
    }
    if ((*pc == ',') || (isspace(*pc))) {
      *pc = ' ';
    } else {
      /* Not whitespace, so make note of it. */
      not_ws = pc;
    }
    pc++;
  }
    
  if (not_ws) {
    /* At least one non-'\0', non-whitespace character.
     * Truncate immediately after it.
     */
    pc = not_ws+1;
    *pc = '\0';
  } else {
    /* Entirely blank string. */
    *instr = '\0';
  }
}



unsigned int DataWrapper::find_doubles(double *&dbl_array,
  const char *instr, unsigned int expected) {
  
  const char   *pc = instr;
  double       *dbl_ptr = NULL;
  double        dbl = 0;
  unsigned int  found = 0;

  if (!instr) {
    return 0;
  }

  if (!expected) {
    /* Ignore dbl_array, for safety.  Two passes. */

    pc = instr;

    while(*pc) {
      /* Skip whitespace. */
      while (isspace(*pc)) { pc++; };
      
      if (sscanf(pc, "%lf", &dbl) == 1) {
        /* Double found.  Count it, and skip until we hit
         * the next separator (whitespace).
         */
        found++;
        
        while ((*pc) && (!isspace(*pc))) {
          pc++;
        }
      } else {
        /* No double found. */
        break;
      }
    }

    expected  = found;
  }


  if (!expected) {
    /* None found.  Don't bother allocating space. */
    return 0;
  }

  if (!dbl_array) {
    /* Space allocated? */
    dbl_array = new double[expected];
    assert(dbl_array);
  }


  /* Read in the doubles. */
  pc     = instr;  
  dbl_ptr = dbl_array;

  for (found=0; found < expected; found++) {
    /* Skip whitespace. */
    while (isspace(*pc)) { pc++; };
    
    if (sscanf(pc, "%lf", dbl_ptr++) == 1) {
      /* Got it.  Skip until we hit the next bit of whitespace. */
        while ((*pc) && (!isspace(*pc))) {
          pc++;
        }
    } else {
      /* No double found. */
      break;
    }
  }

  return found;
}
