/* File:     DBLayer.h
 * Purpose:  This is now an virtual interface, so that 
 *           more DBLayer implementations can be added.
 *           The old Berkeley-specific code is now moved 
 *           to DBBerkeley.[cc|h]
 *
 * RCS:
 ************************************************************
 * $Id: DBLayer.h,v 1.3 2001/09/03 19:36:11 lw2j Exp $
 * $Log:	DBLayer.h,v $
 * Revision 1.3  2001/09/03  19:36:11  lw2j
 * Now an abstract interface, so that different database layers
 * can be implemented and switched-between.
 * 
 * Revision 1.2  2001/08/22  17:20:18  lw2j
 * Untabified.
 * 
 * Revision 1.1  2001/08/22  01:47:55  lw2j
 * Initial revision
 * 
 *
 ************************************************************
 */


#ifndef DBLAYER_H
#define DBLAYER_H



/* Do not instantiate this class directly -- always use a
 * subclass.
 */
class DBLayer {
 public:
  /* Type should be either DB_BTREE or DB_HASH.  I really, 
   * really don't recommend using RECNO here.
   *
   * Dimensionality is used so we know how large the keys
   * are.
   */

  DBLayer(unsigned int dims=0, int in_memory=0) {};
  virtual ~DBLayer() {};


  /* Returns 0 if not there. */
  virtual unsigned int fetch(const double *key_dbls) { return 0; };


  /* If it's not there, store and return a 1.
   * If it exists already, increment and return the NEW
   * value.
   * On failure, return a 0.
   */
  virtual unsigned int fetch_plusplus(const double *key_dbls) { return 0;};


  /* Returns 0 on failure, otherwise returns the count --
   * in this application, there's really no reason to 
   * store a 0 (they're all counts, and 0 is the default
   * if not there), so that makes a decent error 
   * indicator, especially combined with errno. 
   */
  virtual unsigned int store(const double *key_dbls, unsigned
                             int value) { return 0; };


  /* The following are for sequential access.  These
   * routines will return -1 on error, 0 on success,
   * and 1 if it's reached a boundary.
   */

  /* Reset cursor to the first element, and retrieve
   * the pointed-to key and its corresponding data.
   *
   * The user is responsible for allocating the space
   * used by the key -- DBLayer will copy it into 
   * there. The value will get the count, 'natch.
   */
   
  virtual int cursor_first(double *key_dbls, unsigned int &value) {
    return -1; }


  /* The same memory caveats apply.  This behaves
   * like cursor_first, except that it does not
   * reposition the cursor.
   */
  virtual int cursor_retrieve(double *key_dbls, unsigned int &value) {
    return -1;
  }



  /* This advances the cursor and then retrieves
   * the pointed-to object.. */
  virtual int cursor_next(double *key_dbls, unsigned int &value) {
    return -1;
  }
 
 protected:
};

#endif  /* DBLAYER_H */
