/* File:     memorywrapper.h
 * Purpose:  To redefine the DataWrapper interface with an
 *           in-memory version.  It should be faster than
 *           DiskWrapper, I'd think... but it's obviously
 *           going to be a memory hog.  
 *
 * RCS:
 ************************************************************
 * $Id: MemoryWrapper.h,v 1.4 2001/08/23 16:19:14 lw2j Exp $
 * $Log:	MemoryWrapper.h,v $
 * Revision 1.4  2001/08/23  16:19:14  lw2j
 * Added the zero_translate option.
 * 
 * Revision 1.3  2001/08/22  17:20:18  lw2j
 * Untabified.
 * 
 * Revision 1.2  2001/08/22  04:27:01  lw2j
 * Added needed 'const' to get_dims / get_count, for consistency
 * with DataWrapper.
 * 
 * Revision 1.1  2001/08/21 03:40:34  lw2j
 * Initial revision
 *
 ************************************************************
 */


#ifndef MEMORYWRAPPER_H
#define MEMORYWRAPPER_H

#include <stdio.h>
#include <stdlib.h>
#include "DataWrapper.h"


class MemoryWrapper:public DataWrapper {
 public:
  MemoryWrapper(FILE* fh_in=NULL):
    zero_translation(false),
    buf(NULL),
    big_buf(NULL),
    minima(NULL),
    cardinality(0),
    dimensionality(0)
    {
      if (fh_in) {
        load_file(fh_in);
      }
    }

  virtual ~MemoryWrapper() { 
    if (buf) {
      delete [] buf;
      buf = NULL;
    }

    if (big_buf) {
      delete [] big_buf;
      big_buf = NULL;
    }

    if (minima) {
      delete [] minima;
      minima = NULL;
    }
  };
  

  virtual int load_file(FILE *fh_in);


  /* Go through the list and change things, if it's the opposite
   * setting than what we used to have.
   */
  virtual void set_zero_translation(bool new_zero_translation);

  virtual bool get_zero_translation() const { 
    return zero_translation; 
  };

  virtual unsigned int get_dims()  const { return dimensionality; };
  virtual unsigned int get_count() const { return cardinality; };

  /* 'buf' is distinct from big_buf, so users need not be
   * afraid of overwriting it (except by a later get_vector()
   * call).
   */
  virtual double* get_vector(unsigned int index) {
    return get_vector_common(index, buf);
  }

  virtual double* get_vector_dynamic(unsigned int index) {
    return get_vector_common(index, NULL);
  }

 protected:
  /* If it's called by get_vector, we'll use 'buf'; otherwise, 
   * we'll use NULL, and that'll be passed to the parent class's
   * find_doubles() method, which will allocate space.
   */

  virtual double* get_vector_common(unsigned int index, double *dst);

  bool         zero_translation;
  double*      buf;             /* Shared buffer for get_vector(). */
  double*      big_buf;         /* For the entire file!            */
  double*      minima;
  unsigned int cardinality;
  unsigned int dimensionality;
};

#endif  /* MEMORYWRAPPER_H */
