# Freedman-He-Wang Unknot
#### (contact: kmcrane@cs.cmu.edu)

This archive contains meshes of the unknot (i.e., circle embedding) depicted in the paper

> Freedman, He, and Wang  
> _"Möbius Energy of Knots and Unknots"_  
> **Annals of Mathematics (1994)**

(See Figure 6.1).  The unknot is also shown in the file `FreedmanHeWangUnknot.png`.  The meshes were used as a performance benchmark in the paper

> Yu, Schumacher, Crane  
> _"Repulsive Curves"_  
> **ACM Transactions on Graphics (2021)**

The Freedman-He-Wang unknot is _ambient isotopic_ to the round circle, i.e., it should be possible to flow or smooth it out until it becomes a circle—without the curve ever passing through itself.

The archive contains meshes at three different resolutions (600, 1200, and 2400 edges), stored in Wavefront OBJ format.  These files are plain text files which include a list of vertex coordinates

```
v x1 y1 z1
v x2 y2 z2
...
```

as well as a list of edges

```
l i1 j1
l i2 j2
...
```

The indices (i,j) determine the endpoints of a line segment, and are 1-based indices into the list of vertices.