clear; close all; caffe.reset_all();
video_dir='./video/';
flow_dir=setdir(fullfile(video_dir, 'flow/'));
result_dir=setdir(fullfile(video_dir, 'RegionProposals/'));
imnames=get_file_list(video_dir,'jpg');
ts=cell2struct(num2cell([1:length(imnames)]),'t',1);
imnames = cell2struct([struct2cell(imnames); struct2cell(ts')], ...
    [fieldnames(imnames); fieldnames(ts)], 1);

[para]=get_para(video_dir, 'jpg',length(imnames),4);
rcnn_model=get_rcnn_model();


use_gpu=1;
gpu_id=0;



disp('compute dense trajectories');
computeFlowLDOF(imnames,flow_dir,para)
para.flow_dir=flow_dir;
tr=linkFlowLDOF(imnames,para);
lens=get_tr_lengths(tr);
tr=tr(lens>=para.min_tr_len);
if 0
    plot_trajectory_labels(tr, ones(length(tr),1), imnames(1:5:end),1,[],0,...
        4);
end


%
disp('compute trajectory affinities');
[Atr]=computeTrAffinities(tr,para,0);



disp('compute trajectory spectral embedding');
para.nv=3;
[Vtr,Str] = ncut(Atr,para.nv);
binsoltr = getbinsol(Vtr);
tr_labels = full(sum(binsoltr.*repmat(1:para.nv, size(binsoltr,1),1),2)')';

h=plot_trajectory_labels(tr,tr_labels,imnames(1:10:end),1,[],1,5);
title('single trajectory clustering')
% clear Atr










%% setup the objectness regressor
if exist('use_gpu', 'var') && use_gpu
    caffe.set_mode_gpu();
    caffe.set_device(gpu_id);
else
    caffe.set_mode_cpu();
end

% Initialize a network

net = caffe.Net(rcnn_model.net_model, rcnn_model.net_weights, 'test');





frames_subsampled=[1:10:length(imnames)];

%%


tr_cluster_indicators=[];
for framenum=1%frames_subsampled
    cntnp=0;
    clear tr_cluster_indicator_add_c
    progress('frame ',framenum,length(imnames));
    
    imfile= imnames(framenum).name;
    flowfile=[flow_dir 'Forward'  get_image_name(imfile) '.flo'];
    im=imread(imfile);
    flowim=PrepareFlowImage(imnames,framenum,flow_dir,para);
    
    
    % get box proposals per frame -MOP
    disp('MOPs...')
    [boxes_mop,props_mop]=get_current_frame_mop(imfile,flowfile);
    os_mop=get_oversegmentation_mop(flowfile,imfile);
    boxes_mop=[max(1,boxes_mop(:,1)) max(1,boxes_mop(:,2)) min(para.q,boxes_mop(:,3)) min(para.p,boxes_mop(:,4)) ones(size(boxes_mop,1),1)];
    nmop=size(boxes_mop,1);
    
    
    % get box proposals per frame -GOP
    disp('GOPs...')
    [boxes_gop,props_gop]=get_current_frame_gop(imfile);
    os_gop = OverSegmentation( im );
    boxes_gop=[max(1,boxes_gop(:,1)) max(1,boxes_gop(:,2)) min(para.q,boxes_gop(:,3)) min(para.p,boxes_gop(:,4)) 2*ones(size(boxes_gop,1),1)];
    

  
    
    
    
    
    box_props=[boxes_mop;boxes_gop];
    disp('box ranking..')
    scores=extract_pi_rcnn_features_singleim(net,im, flowim, box_props(:,1:4), rcnn_model);
    
    
    %% sorting of proposals according to score
    [boxes_mop,props_mop,scores_mop]=sort_proposals(scores(1:nmop),boxes_mop,props_mop,para.objectness_thresh);
    
    [boxes_gop,props_gop,scores_gop]=sort_proposals(scores(nmop+1:end),boxes_gop,props_gop,para.objectness_thresh);
    nmop=size(boxes_mop,1);
    ngop=size(boxes_gop,1);
    Masks=plot_props(props_mop(1:min(size(props_mop,1),100),:),os_mop,im);h=showImages(Masks);set(h,'Name','top objectness MOPs')
    Masks=plot_props(props_gop(1:min(size(props_gop,1),100),:),os_gop,im); h=showImages(Masks); set(h,'Name','top objectness GOPs')
    
    
    
    assert(size(box_props,1)==size(scores,1));
    
    
    
    if para.do_nms
        box_props=[[boxes_mop(:,1:4) scores_mop];[boxes_gop(:,1:4) scores_gop]];
        scores=[scores_mop; scores_gop];
        pick = nms(box_props , para.nms_overlap_thresh);
        box_props=box_props(pick,:);
        scores=scores(pick,:);
        props_mop=props_mop(pick(1:nmop),:);
        props_gop=props_gop(pick(nmop+1:end,:),:);
        
        
    end
    
    Masks=plot_props(props_mop,os_mop,im);h=showImages(Masks);set(h,'Name','MOPs after nms')
    
    Masks=plot_props(props_gop,os_gop,im); h=showImages(Masks); set(h,'Name','GOPs after nms')
    
    
    if 1
        cols=map2jet(scores);
        h=figure(10); clf;
        subplot(1,2,1)
        plotboxes(im,box_props,cols,[]);
        subplot(1,2,2)
        plotboxes(flowim,box_props,cols,[]);
        title('box proposals after nms (color shows objectness score) ');
        
        
        
        
        
        
    end
    
    
    
    para.random_walkers=1;
    
    %%
    if ~isempty(props_mop)
        tr_cluster_indicators_new=MOP2STMOP(para,props_mop,os_mop,framenum,tr,Vtr,Str);
        [res]=iou(tr_cluster_indicators,tr_cluster_indicators_new);
        if ~isempty(res)
            tr_cluster_indicators_new=tr_cluster_indicators_new(:,max(res,[],2)<0.95);
            
        end
        plot_binary_cluster_indicators(tr_cluster_indicators_new,tr,imnames,100);
        tr_cluster_indicators=[tr_cluster_indicators tr_cluster_indicators_new];
    end
    
    %%
    if ~isempty(props_gop)
        tr_cluster_indicators_new=MOP2STMOP(para,props_gop,os_gop,framenum,tr,Vtr,Str);
        [res]=iou(tr_cluster_indicators,tr_cluster_indicators_new);
        if ~isempty(res)
            tr_cluster_indicators_new=tr_cluster_indicators_new(:,max(res,[],2)<0.95);
            
        end
        plot_binary_cluster_indicators(tr_cluster_indicators_new,tr,imnames,1000);
        tr_cluster_indicators=[tr_cluster_indicators tr_cluster_indicators_new];
    end
    
    
    disp('press any key to continue to the next frame...')
    pause;
    
    
end



%% map them to pixels


disp('compute supervoxels');
supervoxel_dir=setdir([video_dir 'supervoxels/']);
seq2supervoxels_streamLDOF(imnames, flow_dir, supervoxel_dir);
supervoxel_pixel_indicators=get_supervoxel_indicators(supervoxel_dir,imnames(frames_subsampled),para.p,para.q);

disp('map trajectory clusters to supervoxels');
disp('projection 1')
cluster_pixel_indicator=map_tr_supervoxels1(tr,tr_cluster_indicators,...
    supervoxel_pixel_indicators,imnames(frames_subsampled),para.p,para.q);
save([result_dir 'proposals1.mat'],'cluster_pixel_indicator','tr_cluster_indicators','-v7.3');
showImages_nm(reshape(full(cluster_pixel_indicator),[para.p para.q length(frames_subsampled)*size(cluster_pixel_indicator,2)]),...
   length(frames_subsampled), size(cluster_pixel_indicator,2));
title(['projection on supervoxels 1: ' num2str(size(cluster_pixel_indicator,2)) 'proposals in ' num2str(length(frames_subsampled)) 'frames']);

disp('projection 2')
cluster_pixel_indicator=map_tr_supervoxels2(tr,tr_cluster_indicators,...
    supervoxel_pixel_indicators,imnames(frames_subsampled),para.p,para.q);
save([result_dir 'proposals2.mat'],'cluster_pixel_indicator','tr_cluster_indicators','-v7.3');
showImages_nm(reshape(full(cluster_pixel_indicator),[para.p para.q length(frames_subsampled)*size(cluster_pixel_indicator,2)]),...
   length(frames_subsampled), size(cluster_pixel_indicator,2));
title(['projection on supervoxels 2: ' num2str(size(cluster_pixel_indicator,2)) 'proposals in ' num2str(length(frames_subsampled)) 'frames']);





