: # Use perl
   eval 'exec perl5 -w -S $0 "$@"'
   if 0;

# it is faster to use something like
#!/usr/local/bin/perl5 
# but this is more portable.

#
# $Log:	mkpcplot.pl,v $
# Revision 7.1  99/08/11  01:27:06  christos
# ready to go
# 
# Revision 6.10  99/08/11  00:55:38  christos
# added setdefaults
# 
# Revision 6.1  99/08/10  19:22:50  christos
# fitting without chopping
# 
# Revision 5.1  99/08/10  02:33:55  christos
# ready to go
# 
# Revision 4.5  99/08/10  02:31:04  christos
# added sampleNpcp.pl;
# also, titles on the graphs
# 
# Revision 4.4  99/08/10  00:19:39  christos
# added cdeNpcp - ready to go
# 
# Revision 4.3  99/08/10  00:10:38  christos
# *** empty log message ***
# 
# Revision 4.1  99/08/09  23:13:00  christos
# integrated schuster and pair-count plots
# 
# Revision 1.2  99/08/09  23:07:24  christos
# *** empty log message ***
# 
# Revision 1.1  99/08/09  22:40:46  christos
# Initial revision
# 

# expects two files
# and makes the pair-count-plot
# along with the postscript file and the fitting lines


use strict;

my $verbose = 0;
my $debug = 0;
my $dmin = 0.01;
my $factor = 1.1;


require "setdefaults.pl";
my $rmax; # not really needed
($dmin, $rmax, $factor) = setdefaults();


my $nargs;
my @fname=();
my $inp1;
my $inp2;
my $myfloor = 0; #use POSIX's floor(), unless $myfloor is set
my $ptname;

while( $_ = $ARGV[0], /^-/){
   shift;
   last if /^--$/;
   if( /^-D(.*)/){ $debug = $1 }
   if( /^-d(.*)/){ $dmin = $1 }
   if( /^-f(.*)/){ $factor = $1 }
   if (/^-v/)    { $verbose++ }
}

$nargs = $#ARGV + 1;   # the number of remaining arguments

if( $nargs != 2 ) { 
   die "USAGE: $0 [-v] [-d<dmin>]" .
       " [-f<factor>] " .
       " <datafile1> <df2>";  }

$fname[0] = $ARGV[0];
$fname[1] = $ARGV[1];
$inp1 = $fname[0];
$inp2 = $fname[1];

if( $verbose > 1){
    print "*** verbose=", $verbose, "\n";
    print "*** factor=", $factor, "\n";
    print "*** dmin=", $dmin, "\n";
    print "*** datafname1=|", $fname[0], "| ", "datafname2=|", $fname[1], "|\n";
}

my $pcpfname = "${inp1}-${inp2}.pcp"; # shorthand for pair-count plot

# make the log-log pair-count plot
`perl5 npairs.pl $inp1 $inp2 |\
    perl5 lbucketize.pl -d${dmin} -f${factor} |\
    perl5 dezero.pl |\
    perl5 loglog.pl > ${pcpfname} `;

print "***  killing the flat parts ...\n" if ($verbose);
`perl5 killFlats.pl ${pcpfname} > ${pcpfname}-nf `;

if ($verbose){
    print "***  making the postscript plot ...\n" ;
}

# put everything into a eps plot
`newmygnuplot -l "PCPlot" -slope -o ${pcpfname}.eps -xlabel "log(dist)" -ylabel "log(count-of-pairs)" -s points ${pcpfname} `;

if( $verbose > 0 ) {
    `ghostview ${pcpfname}.eps`
}

print "plain fit:";
print `cat ${pcpfname}-nf | perl5 calcslope.pl `;

print "robust fit:";
print `cat ${pcpfname}-nf | perl5 fit.pl `;
