# expects two arrays $x and $y
# and returns the coefficients of Least Squares regression
# Specifically:
#	x,y	are the arrays of the x and y values
# it returns
#	a,b,r	slope, intercept and corr. coeff

#
# $Log:	lsfit.pl,v $
# Revision 7.1  99/08/11  01:27:06  christos
# ready to go
# 
# Revision 6.10  99/08/11  00:55:38  christos
# added setdefaults
# 
# Revision 6.1  99/08/10  19:22:50  christos
# fitting without chopping
# 
# Revision 5.1  99/08/10  02:33:55  christos
# ready to go
# 
# Revision 4.5  99/08/10  02:31:04  christos
# added sampleNpcp.pl;
# also, titles on the graphs
# 
# Revision 4.4  99/08/10  00:19:39  christos
# added cdeNpcp - ready to go
# 
# Revision 4.3  99/08/10  00:10:38  christos
# *** empty log message ***
# 
# Revision 4.1  99/08/09  23:13:00  christos
# integrated schuster and pair-count plots
# 
# Revision 1.1  99/08/09  22:40:46  christos
# Initial revision
# 
# Revision 3.1  99/08/09  19:32:37  christos
# ready to go
# 
# Revision 1.2  99/08/09  19:25:48  christos
# ready to go, with robust regression
# 
# Revision 1.1  99/08/09  16:57:13  christos
# Initial revision
# 
# Revision 1.1  1999/08/09 08:18:16  christos
# Initial revision
#
# Revision 1.4  1999/08/09 04:59:41  christos
# added the sumsqdiff() function
#
# Revision 1.3  1999/08/09 04:35:32  christos
# passing of array refs as parms works OK -
#
# Revision 1.2  1999/08/08 18:01:44  christos
# function to do least squares fit
#
#

require "assert.pl";


use strict;

sub lsfit(\@\@){
    my ($xaref,  $yaref);
    my ($x1, $x2, $y1, $y2, $xy);
    my ($n, $i);
    my $arglen;
    my $xlen;
    my $ylen;
    my ($xval, $yval);

    my ($a, $b, $r);   # intercept, slope and corr. coeff.

    # parse the parms
    $arglen = scalar(@_);
    assert( $arglen ==2, "lsfit: wrong count of args (" . $arglen . ")" );

    ($xaref, $yaref) = ( @_ );
    assert( (ref($xaref) eq 'ARRAY' ) && ( ref($yaref) eq 'ARRAY' ) ,
       "lts: usage lts( array, array )" );


    $xlen = scalar( @$xaref);
    $ylen = scalar( @$yaref);

    assert( $xlen == $ylen, "lsfit: arrays of diff sizes $xlen $ylen" );
    $n = $xlen;


    $x1 = $x2 = $y1 = $y2 = $xy = 0;

    for($i=0; $i<$n; $i++){
        $xval = $$xaref[$i];
	$yval = $$yaref[$i];
        $x1 += $xval;
        $y1 += $yval;
        $x2 += $xval * $xval;
        $y2 += $yval * $yval;
        $xy += $xval * $yval;
    }

    if ($n > 1) {
        $a = ($xy - $x1 * $y1 / $n) / ($x2 - $x1 * $x1 / $n);
        $b = ($y1 - $a * $x1) / $n;

        # correlation coefficient r
	my $xvar = sprintf "%.5f", $x2 - $x1 * $x1 / $n;
	my $yvar = sprintf "%.5f", $y2 - $y1 * $y1 / $n;
	if( $xvar == 0 ){ $r = 1;}
	elsif( $yvar == 0 ){ $r = 1;}
        else {
	   $r = ($xy - $x1 * $y1 / $n) / sqrt($xvar) / sqrt($yvar);
        }

	# old version:
        # $r = ($xy - $x1 * $y1 / $n) / sqrt($x2 - $x1 * $x1 / $n) 
             # / sqrt($y2 - $y1 * $y1 / $n);
        # print 'slope= ', $a, '	y_intcpt= ', $b, '	corr= ', $r;
    }
    else {
        # print 'slope= ', 9999, '	y_intcpt= ', 0, '	corr= ', 0;
        $a = 9999; $b=0; $r=0;
    }

   return( $a, $b, $r);


}# end lsfit


# given the matrix @x and @y
# and the fitting line y=ax+b
# it computes the sum of squared differences
#    sum ( y_i - a*x_i - b ) ^ 2

sub sumsqdiff(\@\@$$){
    
    my ($xaref,  $yaref);
    my $arglen;
    my $xlen;
    my $ylen;

    my ($a, $b, $res);   # intercept, slope 

    # parse the parms
    $arglen = scalar(@_);
    assert( $arglen ==4, "sumsqdiff: wrong count of args (" . $arglen . ")" );

    ($xaref, $yaref, $a, $b) = ( @_ );
    assert( (ref($xaref) eq 'ARRAY' ) && ( ref($yaref) eq 'ARRAY' ) ,
       "sumsqdiff: usage sumsqdiff( array, array, slope, intercept )" );


    $xlen = scalar( @$xaref);
    $ylen = scalar( @$yaref);

    assert( $xlen == $ylen, "sumsqdiff: arrays of diff sizes $xlen $ylen" );
    my $n = $xlen;
    my $i;
    $res =0;
    for($i=0; $i<$n; $i++){
	my $xval = $$xaref[$i];
	my $yval = $$yaref[$i];
        $res += ($yval - $a* $xval - $b) ** 2;
    }
    return($res);

}


return(1); # for 'require'
