#!/usr/local/bin/python
#!/cygdrive/c/Python22/python
#!/usr/bin/python22
#
# $Log: rls.py,v $
# Revision 1.4  2002-05-12 21:52:59-04  christos
# added -g(uess) and -e(rror) flags, and tested them
#
# Revision 1.3  2002-05-12 21:11:27-04  christos
# <>
#
# Revision 1.2  2002-05-12 05:16:48-04  christos
# rls works fine -
# we only need to include the 'forgetting factor'
#
# Revision 1.1  2002-05-12 04:39:38-04  christos
# does incremental inversion of the matrix At * A
#
# Revision 1.0  2002-05-12 04:37:13-04  christos
# Initial revision
#
#

##### test for 'de-tabify'


##################
# implements the Recursive Least Squares
# Given many rows with $n+1$ variables (all independent, except the last one)
# it gives the model for least-squares fit
# 
# 1) It handles noise fine
# 2) it seems to converge fast (!)
# 3) if two columns are identical, it gives them equal weight,
#    without complaining (!)
#
##############

verbose = 0
ndigits = 3 # digits of accuracy, for printing and round-off
wantGuess = 0
wantError = 0


# try to parse the command line arguments
import getopt
import sys 
import fileinput
import string
# from array import *
from Numeric import *
from LinearAlgebra import *

def usage():
    print "USAGE: ", sys.argv[0], " [-v] [-h] [-g] [-e] filename "
    print "     [-v] : verbose output"
    print "     [-h] : help: this very message"
    print "     [-g] : guesses - give them, too"
    print "     [-e] : report total RMS error"

def shiftargs():
    sys.argv[1:] = sys.argv[2:]


# try:
    # opts, args = getopt.getopt(sys.argv[1:], "vhm:p:g:", ["verbose",\
    # "help", "mirror=", "positive-node=", "ground-node="])
# except getopt.GetoptError:
    # # print help information and exit:
    # usage()
    # sys.exit(2)

try:
    opts, args = getopt.getopt(sys.argv[1:], "vhge", ["verbose",\
    "help", "guess", "error" ])
except getopt.GetoptError:
    # print help information and exit:
    usage()
    sys.exit(2)

for o, a in opts:
    if o in ("-h", "--help"):
       usage()
       sys.exit()
    if o in ("-v", "--verbose"):
       verbose = verbose + 1
       shiftargs()
    if o in ("-g", "--guess"):
       wantGuess = 1
       shiftargs()
    if o in ("-e", "--error"):
       wantError = 1
       shiftargs()
# ...

if (verbose>1):
    print "verbose=" , verbose

if (verbose > 1):
    print opts

# read in all the edges (blank separated node-pairs) from the stdin
childrenOf = {} # empty list of children

lineno = 0
ncols = 0

if(wantError):
    error2 = 0 # squared error
    sumy = 0   # sufficient statistics, to compute the variance of the dep. var
    sumy2 = 0

for line in fileinput.input():
    if(verbose > 2):
        print line
    
    # parse, and turn to floats
    inpList = string.split(line)
    inpList = map( float, inpList)
    
    # check for wrong number of columns

    if(lineno == 0):
        ncols = len(inpList) - 1
        if (verbose>2):
            print ncols
        # initialize the Gain matrix
        epsilon = 0.0001
        gainM = identity(ncols)  / epsilon
        identM = identity(ncols) 
	ataM = zeros((ncols,ncols)) # the At * A matrix ~ covariance
	atbM = zeros(ncols)   # the At * b matrix

    else:
        if( ncols != len(inpList) -1):
            print "*** wrong number of columns - exiting"
            sys.exit()

    lineno = lineno + 1

    indVars = array( inpList[0:ncols] )
    tV = indVars
    depVar = inpList[ncols]

    # recursive least squares
    factor = 1.0 + matrixmultiply( matrixmultiply( transpose(tV), gainM), tV)
    auxM = outerproduct(tV, matrixmultiply(tV, gainM)) / factor
    gainM = matrixmultiply(gainM, (identM - auxM))
    ataM = ataM + outerproduct(tV, tV)

    # update the At * b vector
    atbM = atbM + tV * depVar

    if( wantGuess ):
        result = matrixmultiply(gainM, atbM)
        guess = dot(result, tV)
        print "guess[", lineno , "]=", guess 
        # print "guess=", guess, " val=", depVar, "error= ", depVar - guess

    if( wantError):
        result = matrixmultiply(gainM, atbM)
        guess = dot(result, tV)
	localError = guess - depVar
	error2 = error2 +  localError * localError
	sumy = sumy + depVar
	sumy2 = sumy2 + depVar*depVar

    if(verbose>1):
        print "lineno=", lineno, " indVars= ", indVars
        print "        depVar= ", depVar
        print "        innerp= ", dot( indVars, indVars)
        print "        epsilon= ", epsilon
        print "        gainmatrix= "
	print gainM
	print "        factor= ", factor
	print "        auxMatrix= "
	print auxM
	print "        ataM= "
	print "        atbm= ", atbM 
	print ataM
	print "        atam*gain= "
	print matrixmultiply(ataM, gainM)
	if( determinant(ataM) > 0.001):
	    print "        inverse-ataM= "
	    print inverse(ataM)

if(verbose):
    print "--- final  gainmatrix--- "
    print gainM
    print "    just checking:      atam*gain= "
    print matrixmultiply(ataM, gainM)

if(verbose):
    print " solution to LS problem"

if(wantError):
	# print "	RMS error per step:" , sqrt(error2)/lineno
	yavg = sumy/lineno
	yvariance = sumy2/lineno - yavg * yavg
	print "	RMS error per step:" , sqrt(error2)/lineno
	print "	         yvariance=", yvariance

result = matrixmultiply(gainM, atbM)
for i in range (ncols):
    # print "a_", i, " = ", result[i]
    print "	a_%0d = %8.3g " % ( i, result[i] )


################################################################
if __name__ == "__main__":      # when run as a script
    import sys
    if(verbose > 1):
        print getopt.getopt(sys.argv[1:], "vh", ["verbose", "help"])
