#!/opt/local/bin/python

# Author: Christos Faloutsos
# Date: Feb. 2015
# Goal: logarithmic floor, for log-log heatmaps
#       ie, for value $x$, returns the closest power of $b$
#       such that       res <= x
#       and             res       is a power of $b$

import math as M

epsilon=0.00001 # to avoid loss of precision

def log_floor(x,b):
    if( 1.0 > float(x)):
        res = 0.0
    else:
        logx = M.floor( M.log(1.0 * float(x) )/ M.log(b)  + epsilon) 
        res = round( b ** logx )
    return res

if __name__ == "__main__":

    print "testing for 1.0"
    for b in range(2,10):
        assert 1.0 == log_floor(1.0,b), "1 != log_floor(1,%d)" % b

