# General info 

**AUTHOR**:  Christos Faloutsos

**DATE**:    2013; 2017; updated Sept. 24, 2024 (to support comma-separated files)

**PURPOSE**: re-number the entries in the given columns (rudimentary anonymization)


## Usage:

_# to anonymize columns number 1 and 2._

    % perl anonymize_c.pl -c1,2 inp.csv 

Check the 'makefile' to see some usages, eg.,

_# as above, but it will print the look-up table to the file 'lookup'_

    % perl anonymize_c.pl -c1,2 -plookup inp.csv    

## Description
Expects a COMMA-separated file and replaces the values of 
the specified column(s)
with short, unique numbers (1,2,... or 0,1,2,...).

## Important flags:
    -c<n1>[,<n2>...] 	-> the columns to anonymize
    -p<pfname> 			-> print the look-up table to 'pfname', as an ascii file

## Less important flags:

    -d				-> things are stored on disk
    -n<dbname>   		and specifically on the files with name  <dbname>.dbm and r<dbname>.dbm
    -z				-> starts numbering from zero, instead of '1'
