#include <stdio.h>
typedef struct {long a, b;} Double;
typedef struct {long a;} Float;

extern Double __fpreg[];
extern long __fpdepth;

extern Double __Zero;
extern Double __multiply(), __add(), __subtract(), __divide();
extern Double __long2double(), __frexp(), __ldexp(), __modf();
extern Double __float2double();
extern Float __double2float();
extern long __double2long(), __compare();

#define CHECK if(++__fpdepth > 7) \
		   {fprintf(stderr, "fp stack overflow\n"); exit(1);}

void __floatsidf(i)
long i;
{
	CHECK;
	__fpreg[__fpdepth] = __long2double(i);
#ifdef DEBUG
	fprintf(stderr, "floating %d to %08x_%08x\n", i, __fpreg[__fpdepth].b, __fpreg[__fpdepth].a);
#endif
}

long __fixdfsi(d)
Double d;
{
	long i;
	i = __double2long(d);
#ifdef DEBUG
	fprintf(stderr, "fixing %08x_%08x to %d\n", d.b, d.a, i);
	return i;
#endif
}

void __muldf3(a, b)
Double a, b;
{
	CHECK;
	__fpreg[__fpdepth] = __multiply(a, b);
#ifdef DEBUG
	fprintf(stderr, "multiplying %08x_%08x by %08x_%08x giving %08x_%08x\n",
	       a.b, a.a, b.b, b.a, __fpreg[__fpdepth].b, __fpreg[__fpdepth].a);
#endif
}

Double __divdf3 (a, b)
Double a, b;
{
	CHECK;
	__fpreg[__fpdepth] = __divide(a, b);
#ifdef DEBUG
	fprintf(stderr, "dividing %08x_%08x by %08x_%08x giving %08x_%08x\n",
	       a.b, a.a, b.b, b.a, __fpreg[__fpdepth].b, __fpreg[__fpdepth].a);
#endif
}

Double __negdf2 (a)
Double a;
{
	CHECK;
	__fpreg[__fpdepth] = __subtract(__Zero, a);
#ifdef DEBUG
	fprintf(stderr, "negating %08x_%08x giving %08x_%08x\n",
	       a.b, a.a, __fpreg[__fpdepth].b, __fpreg[__fpdepth].a);
#endif
}

Double __adddf3 (a, b)
Double a, b;
{
	CHECK;
	__fpreg[__fpdepth] = __add(a, b);
#ifdef DEBUG
	fprintf(stderr, "adding %08x_%08x by %08x_%08x giving %08x_%08x\n",
	       a.b, a.a, b.b, b.a, __fpreg[__fpdepth].b, __fpreg[__fpdepth].a);
#endif
}

Double __subdf3 (a, b)
Double a, b;
{
	CHECK;
	__fpreg[__fpdepth] = __subtract(a, b);
#ifdef DEBUG
	fprintf(stderr, "subtracting %08x_%08x by %08x_%08x giving %08x_%08x\n",
	       a.b, a.a, b.b, b.a, __fpreg[__fpdepth].b, __fpreg[__fpdepth].a);
#endif
}

long __cmpdf2 (a, b)
Double a, b;
{
	long l;

	l = __compare(a, b);
#ifdef DEBUG
	fprintf(stderr, "comparing %08x_%08x with %08x_%08x giving %d\n",
	       a.b, a.a, b.b, b.a, l);
	return l;
#endif
}

long __fixunsdfsi (a)
Double a;
{
	return __fixdfsi(a);	/* this may be legal... */
}

void frexp(value, eptr)
Double value;
int *eptr;
{
	CHECK;
	__fpreg[__fpdepth] = __frexp(value, eptr);
#ifdef DEBUG
	fprintf(stderr, "frexping %08x_%08x to %08x_%08x and %d\n",
		value.b, value.a, __fpreg[__fpdepth].b, __fpreg[__fpdepth].a, *eptr);
#endif
}

void ldexp(value, exp)
Double value;
int exp;
{
	CHECK;
	__fpreg[__fpdepth] = __ldexp(value, exp);
#ifdef DEBUG
	fprintf(stderr, "ldexping %08x_%08x and %d to %08x_%08x\n",
		value.b, value.a, exp, __fpreg[__fpdepth].b, __fpreg[__fpdepth].a);
#endif
}

void modf(value, iptr)
Double value, *iptr;
{
	CHECK;
	__fpreg[__fpdepth] = __modf(value, iptr);
#ifdef DEBUG
	fprintf(stderr, "modfing %08x_%08x to %08x_%08x and %08x_%08x\n",
		value.b, value.a, iptr->b, iptr->a, __fpreg[__fpdepth].b, __fpreg[__fpdepth].a);
#endif
}

void __truncdfsf2(d)
Double d;
{
    CHECK;
    /* I'm not sure whether we really need to truncate it - maybe
       it's always retrieved with FSTPS - but be safe anyway. */
    __fpreg[__fpdepth] = __float2double(__double2float(d));
#ifdef DEBUG
    fprintf(stderr, "truncating %08x_%08x to %08x_%08x\n",
	    d.b, d.a, __fpreg[__fpdepth].b, __fpreg[__fpdepth].a);
#endif
}

void __extendsfdf2(f)
Float f;
{
	CHECK;
	__fpreg[__fpdepth] = __float2double(f);
#ifdef DEBUG
	fprintf(stderr, "extending %08x to %08x_%08x\n",
		f.a, __fpreg[__fpdepth].b, __fpreg[__fpdepth].a);
#endif
}

