/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.views;

public class VisibleProperty {
    private double value;
    private double visibleValue;
    private double previousValue;
    private boolean animated = false;
    private static float[] eToThePercentComplete = new float[101];

    static {
        int percentComplete = 0;
        while (percentComplete <= 100) {
            VisibleProperty.eToThePercentComplete[percentComplete] = (float)(1.0 / (1.0 + Math.pow(Math.E, (double)(-10.0f * (float)percentComplete) * 0.01 + 5.0)));
            ++percentComplete;
        }
    }

    public double get() {
        return this.value;
    }

    public double getVisible() {
        return this.visibleValue;
    }

    public VisibleProperty(double value) {
        this.value = value;
        this.visibleValue = value;
        this.previousValue = value;
    }

    public boolean set(double newValue) {
        boolean changed = this.value != newValue;
        this.previousValue = this.value;
        this.value = newValue;
        this.visibleValue = newValue;
        this.animated = false;
        return changed;
    }

    public boolean animate(double newValue) {
        boolean changed;
        boolean bl = changed = this.value != newValue;
        if (this.animated) {
            this.previousValue = this.visibleValue;
            this.value = newValue;
        } else {
            this.previousValue = this.value;
            this.value = newValue;
            this.visibleValue = this.previousValue;
            this.animated = true;
        }
        return changed;
    }

    public void update(double percentComplete) {
        if (!this.animated) {
            return;
        }
        if (percentComplete >= 1.0) {
            this.visibleValue = this.value;
            this.previousValue = this.value;
            this.animated = false;
        } else if (this.visibleValue != this.value) {
            float transformedPercentage = eToThePercentComplete[(int)(percentComplete * 100.0)];
            this.visibleValue = (float)(this.previousValue + (double)transformedPercentage * (this.value - this.previousValue));
        }
    }
}

