/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.views;

import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.components.WhylineControlBorder;
import edu.cmu.hcii.whyline.ui.components.WhylineScrollPane;
import edu.cmu.hcii.whyline.ui.views.View;
import edu.cmu.hcii.whyline.ui.views.ViewContainer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DynamicComponent
extends JComponent
implements ViewContainer {
    private Frame frame;
    private View view;
    private final ArrayList<View> viewsUnderMouse = new ArrayList();
    private View mouseFocus;
    private boolean requestFocusOnClick;
    private boolean requestFocusOnEnter;
    private InputEvent mostRecentInputEvent;
    private MouseEvent mostRecentMoveEvent;
    private int mostRecentMouseX;
    private int mostRecentMouseY;
    private int mouseFocusX;
    private int mouseFocusY;
    private WhylineScrollPane scroller;
    protected final FitView container = new FitView();
    public final Sizing widthSizing;
    public final Sizing heightSizing;
    private boolean popupCanceled = false;

    public DynamicComponent(Frame frame, Sizing width, Sizing height) {
        this.frame = frame;
        this.widthSizing = width;
        this.heightSizing = height;
        this.setBorder(new WhylineControlBorder());
        this.setRequestFocusOnClick(false);
        this.setRequestFocusOnEnter(false);
        this.setLayout(new BorderLayout(){

            public void layoutContainer(Container parent) {
                super.layoutContainer(parent);
                DynamicComponent.this.layoutView();
            }
        });
        this.setBackground(UI.getControlBackColor());
        this.scroller = new WhylineScrollPane(this.container, this.heightSizing != Sizing.FIT ? 20 : 21, this.widthSizing != Sizing.FIT ? 30 : 31);
        this.add((Component)this.scroller, "Center");
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                DynamicComponent.this.repaint();
            }

            public void focusLost(FocusEvent e) {
                DynamicComponent.this.repaint();
            }
        });
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                DynamicComponent.this.mostRecentInputEvent = e;
                if (DynamicComponent.this.getView() != null) {
                    DynamicComponent.this.getView().handleKeyPressed(e);
                }
            }

            public void keyReleased(KeyEvent e) {
                DynamicComponent.this.mostRecentInputEvent = e;
                if (DynamicComponent.this.getView() != null) {
                    DynamicComponent.this.getView().handleKeyReleased(e);
                }
            }

            public void keyTyped(KeyEvent e) {
                DynamicComponent.this.mostRecentInputEvent = e;
                if (DynamicComponent.this.getView() != null) {
                    DynamicComponent.this.getView().handleKeyTyped(e);
                }
            }
        });
        this.scroller.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                DynamicComponent.this.mostRecentInputEvent = e;
                if (e.getScrollType() == 0) {
                    for (View view : DynamicComponent.this.viewsUnderMouse) {
                        if (!view.handleWheelMove(e.getUnitsToScroll())) continue;
                        return;
                    }
                }
            }
        });
        View.addRoot(this);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                View.removeRoot(DynamicComponent.this);
            }
        });
        this.validate();
    }

    @Override
    public boolean isMetaDown() {
        return this.mostRecentInputEvent == null ? false : this.mostRecentInputEvent.isMetaDown();
    }

    @Override
    public boolean isControlDown() {
        return this.mostRecentInputEvent == null ? false : this.mostRecentInputEvent.isControlDown();
    }

    @Override
    public boolean isAltDown() {
        return this.mostRecentInputEvent == null ? false : this.mostRecentInputEvent.isAltDown();
    }

    @Override
    public boolean isShiftDown() {
        return this.mostRecentInputEvent == null ? false : this.mostRecentInputEvent.isShiftDown();
    }

    @Override
    public boolean isModifierDown() {
        return this.mostRecentInputEvent == null ? false : this.mostRecentInputEvent.isShiftDown() || this.mostRecentInputEvent.isAltDown() || this.mostRecentInputEvent.isControlDown() || this.mostRecentInputEvent.isMetaDown();
    }

    private void layoutView() {
        this.container.handleSizeChanges(false, true);
        if (this.getView() != null) {
            this.getView().handleContainerResize();
        }
        this.container.handleSizeChanges(false, true);
    }

    public void setRequestFocusOnClick(boolean onClick) {
        this.requestFocusOnClick = onClick;
        this.setFocusable(this.requestFocusOnClick || this.requestFocusOnEnter);
    }

    public void setRequestFocusOnEnter(boolean onEnter) {
        this.requestFocusOnEnter = onEnter;
        this.setFocusable(this.requestFocusOnClick || this.requestFocusOnEnter);
    }

    public JScrollPane getScrollPane() {
        return this.scroller;
    }

    private void updateViewsUnderMouse(int globalX, int globalY) {
        this.mostRecentMouseX = globalX;
        this.mostRecentMouseY = globalY;
        if (this.getView() == null) {
            return;
        }
        View lastViewOnTop = this.viewsUnderMouse.isEmpty() ? null : this.viewsUnderMouse.get(0);
        HashSet<View> viewsUnderMousePreviously = new HashSet<View>(this.viewsUnderMouse);
        this.viewsUnderMouse.clear();
        this.getView().collectViewsUnderMouseFromBottomToTop(this.viewsUnderMouse, globalX, globalY, this.getView().getLocalBoundaries());
        View newViewOnTop = this.viewsUnderMouse.isEmpty() ? null : this.viewsUnderMouse.get(0);
        HashSet<View> viewsExited = new HashSet<View>(viewsUnderMousePreviously);
        viewsExited.removeAll(this.viewsUnderMouse);
        for (View exitedView : viewsExited) {
            exitedView.handleMouseExit();
        }
        HashSet<View> viewsEntered = new HashSet<View>(this.viewsUnderMouse);
        viewsEntered.removeAll(viewsUnderMousePreviously);
        for (View enteredView : viewsEntered) {
            enteredView.handleMouseEnter();
        }
        if (newViewOnTop != lastViewOnTop) {
            View parent;
            if (lastViewOnTop != null) {
                parent = lastViewOnTop.getParent();
                if (parent != null) {
                    lastViewOnTop.handleMouseNoLongerDirectlyOver((int)parent.globalLeftToLocal(this.mostRecentMouseX), (int)parent.globalTopToLocal(this.mostRecentMouseY));
                } else {
                    lastViewOnTop.handleMouseNoLongerDirectlyOver(this.mostRecentMouseX, this.mostRecentMouseY);
                }
            }
            if (newViewOnTop != null) {
                parent = newViewOnTop.getParent();
                if (parent != null) {
                    newViewOnTop.handleMouseDirectlyOver((int)parent.globalLeftToLocal(this.mostRecentMouseX), (int)parent.globalTopToLocal(this.mostRecentMouseY));
                } else {
                    newViewOnTop.handleMouseDirectlyOver(this.mostRecentMouseX, this.mostRecentMouseY);
                }
            }
        }
    }

    @Override
    public final View getView() {
        return this.view;
    }

    public void setView(View newView) {
        this.view = newView;
        this.container.setView(newView);
    }

    @Override
    public void focusMouseOn(View view) {
        assert (this.mouseFocus == null) : "Mouse already focused on " + this.mouseFocus;
        this.mouseFocus = view;
        this.mouseFocusX = (int)view.globalLeftToLocal(this.mostRecentMouseX);
        this.mouseFocusY = (int)view.globalTopToLocal(this.mostRecentMouseY);
    }

    @Override
    public void releaseMouseFocus() {
        this.mouseFocus = null;
    }

    @Override
    public boolean mouseIsFocused() {
        return this.mouseFocus != null;
    }

    @Override
    public int getMouseFocusX() {
        return this.mouseFocusX;
    }

    @Override
    public int getMouseFocusY() {
        return this.mouseFocusY;
    }

    public abstract int getVerticalScrollIncrement();

    public abstract int getHorizontalScrollIncrement();

    @Override
    public boolean viewIsUnderMouse(View view) {
        return this.viewsUnderMouse.contains(view);
    }

    @Override
    public List<View> getViewsUnderMouse() {
        return Collections.unmodifiableList(this.viewsUnderMouse);
    }

    @Override
    public boolean showPopup(JPopupMenu menu, int x, int y) {
        if (menu.getSubElements().length == 0) {
            return false;
        }
        Point p = SwingUtilities.convertPoint(this.container, x, y, this);
        menu.show(this, (int)p.getX(), (int)p.getY());
        return true;
    }

    @Override
    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
    }

    @Override
    public int getMouseX() {
        return this.mostRecentMouseX;
    }

    @Override
    public int getMouseY() {
        return this.mostRecentMouseY;
    }

    protected JViewport getViewport() {
        return this.getScrollPane().getViewport();
    }

    public int getViewportWidth() {
        JViewport viewport = this.getViewport();
        return viewport.getWidth();
    }

    public int getViewportX() {
        JViewport viewport = this.getViewport();
        return (int)viewport.getViewPosition().getX();
    }

    public int getViewportHeight() {
        JViewport viewport = this.getViewport();
        return viewport.getHeight();
    }

    public int getViewportY() {
        JViewport viewport = this.getViewport();
        return (int)viewport.getViewPosition().getY();
    }

    public void setViewPosition(int x, int y) {
        this.validate();
        JViewport viewport = this.getViewport();
        viewport.setViewPosition(new Point(Math.max(x, 0), Math.max(y, 0)));
    }

    @Override
    public void moveMouseAgain() {
        this.container.moveMouseAgain();
    }

    @Override
    public void invokeRunnableLater(Runnable runnable) {
        SwingUtilities.invokeLater(runnable);
    }

    @Override
    public final void rootViewChangedSize() {
        this.container.handleSizeChanges(true, false);
    }

    protected class FitView
    extends JComponent
    implements Scrollable,
    MouseMotionListener,
    MouseListener {
        private View view;
        private int alreadyHandlingSizeChanges = 0;

        public FitView() {
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
        }

        public boolean isBackgroundSet() {
            return true;
        }

        public Color getBackground() {
            return DynamicComponent.this.getBackground();
        }

        public void mouseDragged(MouseEvent event) {
            DynamicComponent.this.mostRecentInputEvent = event;
            DynamicComponent.this.updateViewsUnderMouse(event.getX(), event.getY());
            if (DynamicComponent.this.mouseFocus != null) {
                Point2D point = event.getPoint();
                if (DynamicComponent.this.mouseFocus.getParent() != null) {
                    point = DynamicComponent.this.mouseFocus.getParent().globalToLocal(new Point2D.Double(event.getX(), event.getY()));
                }
                DynamicComponent.this.mouseFocus.handleMouseDrag((int)((Point2D)point).getX(), (int)((Point2D)point).getY(), event.getButton());
            } else {
                this.mouseMoved(event);
            }
        }

        public void moveMouseAgain() {
            if (DynamicComponent.this.mostRecentMoveEvent != null) {
                this.mouseMoved(DynamicComponent.this.mostRecentMoveEvent);
            }
        }

        public void mouseMoved(MouseEvent event) {
            DynamicComponent.this.mostRecentInputEvent = event;
            DynamicComponent.this.mostRecentMoveEvent = event;
            DynamicComponent.this.updateViewsUnderMouse(event.getX(), event.getY());
            for (View view : DynamicComponent.this.viewsUnderMouse) {
                Point2D point = event.getPoint();
                if (view.getParent() != null) {
                    point = view.getParent().globalToLocal(new Point2D.Double(event.getX(), event.getY()));
                }
                if (!view.handleMouseMove((int)((Point2D)point).getX(), (int)((Point2D)point).getY())) continue;
                return;
            }
        }

        public void mouseClicked(MouseEvent event) {
            DynamicComponent.this.mostRecentInputEvent = event;
            DynamicComponent.this.updateViewsUnderMouse(event.getX(), event.getY());
            for (View view : DynamicComponent.this.viewsUnderMouse) {
                Point2D point = event.getPoint();
                if (view.getParent() != null) {
                    point = view.getParent().globalToLocal(new Point2D.Double(event.getX(), event.getY()));
                }
                if (!(event.getClickCount() > 1 ? view.handleMouseDoubleClick((int)((Point2D)point).getX(), (int)((Point2D)point).getY(), event.getButton()) : view.handleMouseClick((int)((Point2D)point).getX(), (int)((Point2D)point).getY(), event.getButton()))) continue;
                return;
            }
        }

        public void mouseEntered(MouseEvent event) {
            DynamicComponent.this.mostRecentInputEvent = event;
            if (DynamicComponent.this.requestFocusOnEnter) {
                DynamicComponent.this.requestFocusInWindow();
            }
            DynamicComponent.this.updateViewsUnderMouse(event.getX(), event.getY());
        }

        public void mouseExited(MouseEvent event) {
            DynamicComponent.this.mostRecentInputEvent = event;
            DynamicComponent.this.updateViewsUnderMouse(event.getX(), event.getY());
        }

        public void mousePressed(MouseEvent event) {
            if (DynamicComponent.this.requestFocusOnClick) {
                DynamicComponent.this.requestFocusInWindow();
            }
            assert (event.getButton() < 4) : "The MouseEvent getButton() protocol changed! It no longer returns a 0-3 button number!";
            DynamicComponent.this.updateViewsUnderMouse(event.getX(), event.getY());
            if (DynamicComponent.this.mouseFocus != null) {
                Point2D point = event.getPoint();
                if (DynamicComponent.this.mouseFocus.getParent() != null) {
                    point = DynamicComponent.this.mouseFocus.getParent().globalToLocal(new Point2D.Double(event.getX(), event.getY()));
                }
                DynamicComponent.this.mouseFocus.handleMouseDown((int)((Point2D)point).getX(), (int)((Point2D)point).getY(), event.getButton());
            } else {
                for (View view : DynamicComponent.this.viewsUnderMouse) {
                    Point2D point = event.getPoint();
                    if (view.getParent() != null) {
                        point = view.getParent().globalToLocal(new Point2D.Double(event.getX(), event.getY()));
                    }
                    if (!view.handleMouseDown((int)((Point2D)point).getX(), (int)((Point2D)point).getY(), event.getButton())) continue;
                    return;
                }
            }
        }

        public void mouseReleased(MouseEvent event) {
            DynamicComponent.this.updateViewsUnderMouse(event.getX(), event.getY());
            if (DynamicComponent.this.mouseFocus != null) {
                Point2D point = event.getPoint();
                if (DynamicComponent.this.mouseFocus.getParent() != null) {
                    point = DynamicComponent.this.mouseFocus.getParent().globalToLocal(new Point2D.Double(event.getX(), event.getY()));
                }
                DynamicComponent.this.mouseFocus.handleMouseUp((int)((Point2D)point).getX(), (int)((Point2D)point).getY(), event.getButton());
            } else {
                for (View view : DynamicComponent.this.viewsUnderMouse) {
                    Point2D point = event.getPoint();
                    if (view.getParent() != null) {
                        point = view.getParent().globalToLocal(new Point2D.Double(event.getX(), event.getY()));
                    }
                    if (!view.handleMouseUp((int)((Point2D)point).getX(), (int)((Point2D)point).getY(), event.getButton())) continue;
                    return;
                }
            }
        }

        public Dimension getPreferredScrollableViewportSize() {
            return null;
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return orientation == 1 ? DynamicComponent.this.getVerticalScrollIncrement() : DynamicComponent.this.getHorizontalScrollIncrement();
        }

        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return this.getScrollableUnitIncrement(visibleRect, orientation, direction);
        }

        public void setView(View newView) {
            if (this.view != null) {
                this.view.setNotifyContainerOfSizeChanges(false);
            }
            this.view = newView;
            this.view.setNotifyContainerOfSizeChanges(true);
            this.repaint();
            this.setBackground(null);
            this.setOpaque(false);
            this.handleSizeChanges(true, false);
        }

        public void handleSizeChanges(boolean viewChanged, boolean viewportChanged) {
            if (this.alreadyHandlingSizeChanges > 0) {
                return;
            }
            if (this.view != null) {
                boolean needVerticalBar;
                double preferredViewWidth = this.view.getPreferredWidth();
                double preferredViewHeight = this.view.getPreferredHeight();
                double newViewWidth = this.view.getLocalWidth();
                double newViewHeight = this.view.getLocalHeight();
                int viewportWidth = DynamicComponent.this.getViewportWidth() - 1;
                int viewportHeight = DynamicComponent.this.getViewportHeight() - 1;
                boolean needHorizontalBar = preferredViewWidth > (double)viewportWidth;
                boolean bl = needVerticalBar = preferredViewHeight > (double)viewportHeight;
                if (DynamicComponent.this.widthSizing == Sizing.FIT) {
                    newViewWidth = viewportWidth - 2;
                } else if (DynamicComponent.this.widthSizing == Sizing.SCROLL) {
                    newViewWidth = preferredViewWidth;
                } else if (DynamicComponent.this.widthSizing == Sizing.SCROLL_OR_FIT_IF_SMALLER) {
                    newViewWidth = preferredViewWidth < (double)viewportWidth ? (double)(viewportWidth - (needVerticalBar ? DynamicComponent.this.scroller.getVerticalScrollBar().getWidth() + 2 : 2)) : preferredViewWidth;
                }
                if (DynamicComponent.this.heightSizing == Sizing.FIT) {
                    newViewHeight = viewportHeight - 2;
                } else if (DynamicComponent.this.heightSizing == Sizing.SCROLL) {
                    newViewHeight = preferredViewHeight;
                } else if (DynamicComponent.this.heightSizing == Sizing.SCROLL_OR_FIT_IF_SMALLER) {
                    newViewHeight = preferredViewHeight < (double)viewportHeight ? (double)(viewportHeight - (needHorizontalBar ? DynamicComponent.this.scroller.getHorizontalScrollBar().getHeight() + 2 : 2)) : preferredViewHeight;
                }
                ++this.alreadyHandlingSizeChanges;
                this.view.setLocalWidth(newViewWidth, false);
                this.view.setLocalHeight(newViewHeight, false);
                Dimension newSize = new Dimension((int)newViewWidth, (int)newViewHeight);
                this.setPreferredSize(newSize);
                this.setSize(newSize);
                DynamicComponent.this.validate();
                --this.alreadyHandlingSizeChanges;
                this.repaint();
            }
        }

        public final void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            View view = DynamicComponent.this.getView();
            if (view != null) {
                view.paintBelowChildren(g2d);
                view.paint(g2d);
                view.paintAboveChildren(g2d);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sizing {
        SCROLL,
        FIT,
        SCROLL_OR_FIT_IF_SMALLER;

    }
}

