/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.source;

import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.qa.Answer;
import edu.cmu.hcii.whyline.qa.Explanation;
import edu.cmu.hcii.whyline.qa.UnexecutedInstruction;
import edu.cmu.hcii.whyline.source.FileInterface;
import edu.cmu.hcii.whyline.source.JavaSourceFile;
import edu.cmu.hcii.whyline.source.Line;
import edu.cmu.hcii.whyline.source.ParseException;
import edu.cmu.hcii.whyline.source.Token;
import edu.cmu.hcii.whyline.source.TokenRange;
import edu.cmu.hcii.whyline.trace.EventKind;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.UserFocusListener;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.arrows.ArrowView;
import edu.cmu.hcii.whyline.ui.arrows.FileControlArrow;
import edu.cmu.hcii.whyline.ui.arrows.FileDataArrow;
import edu.cmu.hcii.whyline.ui.arrows.UnexecutedArrowView;
import edu.cmu.hcii.whyline.ui.components.SimpleHTML;
import edu.cmu.hcii.whyline.ui.qa.UnexecutedInstructionView;
import edu.cmu.hcii.whyline.ui.qa.Visualization;
import edu.cmu.hcii.whyline.ui.source.FileView;
import edu.cmu.hcii.whyline.ui.source.FileWindow;
import edu.cmu.hcii.whyline.ui.source.LineView;
import edu.cmu.hcii.whyline.ui.source.TokenView;
import edu.cmu.hcii.whyline.ui.views.View;
import edu.cmu.hcii.whyline.util.IntegerVector;
import edu.cmu.hcii.whyline.util.Util;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilesView
extends View
implements UserFocusListener {
    private static int MAX_FILES_VIEWS_LOADED = (int)(Runtime.getRuntime().maxMemory() / 10L / 1024L / 1024L / 4L);
    private final ArrayList<FileInterface> recentFiles = new ArrayList();
    private final TreeMap<FileInterface, FileWindow> windowsByFile = new TreeMap();
    private Configuration selectionConfiguration = null;
    private SimpleHTML selectionExplanation;
    private final WhylineUI whylineUI;
    private final ArrowBox arrows;
    private double windowHeaderHeight;
    private double windowScrollBarMargin;
    private TimerTask currentFader = null;
    private final Timer fadeTimer = new Timer(true);
    private final double fadeFactor = 0.33;
    private AlphaComposite fade = null;
    private final int FADED_TIME = 250;
    private final int FADE_IN_TIME = 500;
    private final int TOTAL_FADE_TIME = 750;

    public FilesView(WhylineUI whylineUI) {
        this.whylineUI = whylineUI;
        this.arrows = new ArrowBox();
        this.addChild(this.arrows);
    }

    public WhylineUI getWhylineUI() {
        return this.whylineUI;
    }

    public Trace getTrace() {
        return this.whylineUI.getTrace();
    }

    public ArrowView getSelectedFileArrow() {
        View view;
        int arrowNumber = this.whylineUI.getArrowOver();
        if (arrowNumber >= 0 && arrowNumber <= this.arrows.getNumberOfChildren() && (view = this.arrows.getChildAtIndex(arrowNumber)) instanceof ArrowView) {
            return (ArrowView)view;
        }
        return null;
    }

    @Override
    public void handleContainerResize() {
        if (this.selectionConfiguration != null) {
            this.selectionConfiguration.arrange(false);
        }
    }

    public void handleArrowOverChanged() {
        if (this.selectionConfiguration != null) {
            this.selectionConfiguration.arrange(true);
        }
    }

    @Override
    public boolean handleMouseMove(int x, int y) {
        if (this.whylineUI.getVisualizationUIVisible() == null) {
            return false;
        }
        this.whylineUI.setArrowOver(-1);
        this.repaint();
        return false;
    }

    @Override
    public void paintChildren(Graphics2D g) {
        this.arrows.layoutArrows(true);
        super.paintChildren(g);
    }

    @Override
    public void paintAboveChildren(Graphics2D g) {
        g = (Graphics2D)g.create();
        if (this.selectionConfiguration == null) {
            return;
        }
        if (this.selectionConfiguration.focus instanceof UnexecutedInstruction) {
            UnexecutedInstruction inst = (UnexecutedInstruction)this.selectionConfiguration.focus;
            LineView line = this.getLineViewOfInstruction(inst.getInstruction());
            if (line == null) {
                return;
            }
            int xWidth = (int)UnexecutedInstructionView.XMARK_BOUNDS.getWidth();
            int xLeft = (int)(line.getVisibleGlobalLeft() + (double)line.getLeftAfterWhitespace() - (double)xWidth);
            int xBottom = (int)(line.getVisibleGlobalTop() - (UnexecutedInstructionView.XMARK_BOUNDS.getHeight() - line.getVisibleGlobalHeight()) / 2.0 + (double)UnexecutedInstructionView.GLYPH_ASCENT);
            if (inst.getReason() == UnexecutedInstruction.Reason.DID_EXECUTE) {
                g.setColor(UI.CORRECT_COLOR);
                g.drawGlyphVector(UnexecutedInstructionView.CHECKMARK, xLeft, xBottom);
            } else {
                g.setColor(UI.ERROR_COLOR);
                g.drawGlyphVector(UnexecutedInstructionView.XMARK, xLeft, xBottom);
            }
        }
    }

    public void removeWindowsArrowsAndHighlights() {
        for (View child : this.getChildren()) {
            if (!(child instanceof FileWindow) || ((FileWindow)child).getFileView() == null) continue;
            ((FileWindow)child).getFileView().removeEmphasis();
        }
        this.selectionExplanation = null;
        this.arrows.clear();
        this.removeWindows();
    }

    private void removeWindows() {
        this.removeChildren();
        this.addChild(this.arrows);
    }

    private FileInterface getFileFor(Instruction inst) {
        Classfile classfile;
        if (inst == null) {
            return null;
        }
        FileInterface source = classfile = inst.getCode().getMethod().getClassfile();
        if (classfile.getSourceFile() != null) {
            source = classfile.getSourceFile();
        }
        return source;
    }

    public FileView getViewOf(FileInterface source) {
        return this.getWindowViewOf(source).getFileView();
    }

    public FileWindow getWindowViewOf(FileInterface source) {
        FileInterface file;
        if (source == null) {
            return null;
        }
        FileWindow fileView = this.windowsByFile.get(source);
        if (fileView == null) {
            fileView = new FileWindow(this, this.getContainer(), source);
            this.windowsByFile.put(source, fileView);
        }
        if (this.recentFiles.contains(source)) {
            this.recentFiles.remove(source);
        }
        this.recentFiles.add(source);
        if (this.recentFiles.size() > MAX_FILES_VIEWS_LOADED && (file = this.recentFiles.remove(0)) != source) {
            FileWindow window = this.windowsByFile.get(file);
            this.windowsByFile.remove(file);
            this.removeChild(window);
        }
        return fileView;
    }

    public FileView getFileViewOfInstruction(Instruction inst) {
        FileView fileView = this.getWindowViewOf(this.getFileFor(inst)).getFileView();
        return fileView;
    }

    public LineView getLineViewOfInstruction(Instruction instruction) {
        if (instruction == null) {
            return null;
        }
        return this.getFileViewOfInstruction(instruction).getLineViewOf(instruction);
    }

    private void placeWindow(FileWindow window, double left, double top, double width, double height, boolean animate) {
        double verticalBoundary;
        double horizontalPadding = 0.0;
        double verticalPadding = 0.0;
        if (left < 0.0) {
            double lostWidth = -left;
            left = 0.0;
            width -= lostWidth;
        }
        if (top < verticalPadding) {
            double lostHeight = verticalPadding - top;
            top = verticalPadding;
            height -= lostHeight;
        }
        if (top + height > (verticalBoundary = this.getLocalHeight() - 1.0)) {
            height -= top + height - verticalBoundary;
        }
        if (left + width > this.getLocalWidth() - horizontalPadding) {
            double lostWidth = left + width - this.getLocalWidth();
            width -= lostWidth;
        }
        window.layout(left += horizontalPadding, top += 0.0, width -= horizontalPadding * 2.0 + 1.0, height -= verticalPadding, animate);
    }

    private static void addInstructionToWindowSet(Hashtable<FileWindow, Set<Instruction>> table, FileWindow window, Instruction instruction) {
        Set<Instruction> instructionsToShow = table.get(window);
        if (instructionsToShow == null) {
            instructionsToShow = new HashSet<Instruction>();
            table.put(window, instructionsToShow);
        }
        instructionsToShow.add(instruction);
    }

    private void emphasizeMethod(MethodInfo method) {
        if (method == null) {
            return;
        }
        JavaSourceFile source = method.getClassfile().getSourceFile();
        if (source != null) {
            this.getWindowViewOf(source).getFileView().emphasizeMethod(method);
        }
    }

    @Override
    public void showInstruction(Instruction instruction) {
        this.removeWindowsArrowsAndHighlights();
        this.emphasizeMethod(instruction.getMethod());
        this.selectionConfiguration = new Configuration(instruction, instruction.getFile().getTokenRangeFor(instruction));
        this.selectionConfiguration.arrange(true);
        this.getWhylineUI().getOutlineUI().showMethod(instruction.getMethod());
    }

    @Override
    public void showInstructions(Iterable<? extends Instruction> instructions) {
        this.removeWindowsArrowsAndHighlights();
        for (Instruction instruction : instructions) {
            this.emphasizeMethod(instruction.getMethod());
        }
        this.selectionConfiguration.arrange(true);
    }

    @Override
    public void showEvent(int eventID) {
        if (eventID < 0 || eventID >= this.getTrace().getNumberOfEvents()) {
            return;
        }
        this.removeWindowsArrowsAndHighlights();
        MethodInfo method = this.getTrace().getInstruction(eventID).getMethod();
        this.emphasizeMethod(method);
        this.selectionConfiguration = new Configuration(eventID, this.getRangeFor(eventID));
        this.selectionConfiguration.arrange(true);
        this.getWhylineUI().getOutlineUI().showMethod(method);
    }

    @Override
    public void showExplanation(Explanation selection) {
        if (this.whylineUI.getVisualizationUIVisible() == null) {
            return;
        }
        boolean showSources = !this.whylineUI.getVisualizationUIVisible().getVisualization().isMetaDown();
        Answer answer = this.whylineUI.getVisualizationUIVisible().getAnswer();
        this.removeWindowsArrowsAndHighlights();
        this.selectionExplanation = new SimpleHTML(this.getTrace().getHTMLDescription(selection.getEventID()), (Graphics2D)this.whylineUI.getGraphics(), UI.getSmallFont());
        selection.explain();
        Instruction instruction = this.getTrace().getInstruction(selection.getEventID());
        EventKind kind = this.getTrace().getKind(selection.getEventID());
        this.emphasizeMethod(instruction.getMethod());
        int param = -1;
        if (kind.isArgument) {
            param = this.getTrace().getArgumentLocalIDSet(selection.getEventID());
        }
        this.selectionConfiguration = new Configuration(selection, this.getRangeFor(selection.getEventID()));
        int controlID = this.getTrace().getControlID(selection.getEventID());
        if (controlID >= 0) {
            this.arrows.addArrow(new FileControlArrow(this.arrows, selection.getAnswer().getExplanationFor(controlID), selection));
        }
        int dependencyNumber = 1;
        SortedMap<Explanation, Explanation> terminalCauses = selection.getAnswer().getTerminalDataDependencies(selection);
        if (terminalCauses != null) {
            for (Explanation cause : terminalCauses.keySet()) {
                Explanation temp;
                Explanation effect = (Explanation)terminalCauses.get(cause);
                Explanation source = cause;
                if (showSources && (temp = answer.getSourceOfExplanationsValue(source)) != null) {
                    source = temp;
                }
                Instruction useInstruction = this.getTrace().getInstruction(source.getEventID());
                Instruction defInstruction = this.getTrace().getInstruction(cause.getEventID());
                this.emphasizeMethod(useInstruction.getMethod());
                this.emphasizeMethod(defInstruction.getMethod());
                this.arrows.addArrow(new FileDataArrow(this.arrows, cause, source, effect, dependencyNumber));
                ++dependencyNumber;
            }
        }
        this.selectionConfiguration.arrange(true);
        this.getWhylineUI().getOutlineUI().showMethod(instruction.getMethod());
    }

    @Override
    public void showMethod(MethodInfo method) {
        FileInterface file = method.getClassfile().getSourceFile();
        if (file == null) {
            file = method.getClassfile();
        }
        this.removeWindowsArrowsAndHighlights();
        this.emphasizeMethod(method);
        TokenRange range = file.getTokenRangeForMethod(method);
        this.selectionConfiguration = new Configuration(method, range);
        this.selectionConfiguration.arrange(true);
        this.getWhylineUI().getOutlineUI().showMethod(method);
    }

    private void showWindow(FileWindow window) {
        if (window.getParent() == null) {
            this.addChild(window);
            this.windowHeaderHeight = window.getHeaderHeight();
            this.windowScrollBarMargin = window.getScrollBarMargin();
        }
        window.bringToFront();
    }

    @Override
    public void showFile(FileInterface file) {
        this.removeWindowsArrowsAndHighlights();
        FileWindow window = this.getWindowViewOf(file);
        if (window == null) {
            return;
        }
        this.showWindow(window);
        this.placeWindow(window, 0.0, 0.0, this.getLocalWidth(), this.getLocalHeight(), true);
        this.whylineUI.getOutlineUI().showFile(file);
    }

    public void showLine(Line line) {
        this.removeWindowsArrowsAndHighlights();
        TokenRange range = line.getRange();
        while (line != null && range == null) {
            try {
                line = line.getLineAfter();
            }
            catch (ParseException e) {
                e.printStackTrace();
                range = null;
            }
            if (line == null) continue;
            range = line.getRange();
        }
        if (range == null) {
            return;
        }
        this.selectionConfiguration = new Configuration(line, range);
        this.selectionConfiguration.arrange(true);
        FileWindow window = this.getWindowViewOf(line.getFile());
        LineView view = window.getFileView().getViewOf(line);
        view.setEmphasized(true);
        this.showWindow(window);
        this.placeWindow(window, 0.0, 0.0, this.getLocalWidth(), this.getLocalHeight(), true);
    }

    @Override
    public void showUnexecutedInstruction(UnexecutedInstruction inst) {
        this.removeWindowsArrowsAndHighlights();
        this.selectionExplanation = new SimpleHTML("<b>" + inst.getInstruction().getLineNumber() + "</b> didn't execute because " + inst.getVerbalExplanation(), (Graphics2D)this.whylineUI.getGraphics(), UI.getSmallFont());
        int number = 0;
        for (UnexecutedInstruction incoming : inst.getIncoming()) {
            this.arrows.addArrow(new UnexecutedArrowView(this.arrows, incoming, inst, number++));
        }
        this.emphasizeMethod(inst.getInstruction().getMethod());
        TreeSet tokens = new TreeSet();
        this.selectionConfiguration = new Configuration(inst, inst.getInstruction().getFile().getTokenRangeFor(inst.getInstruction()));
        if (inst.getDecidingEvents() != null) {
            IntegerVector integerVector = inst.getDecidingEvents();
            int i = 0;
            while (i < integerVector.size()) {
                Instruction decidingInstruction = this.getTrace().getInstruction(integerVector.get(i));
                this.emphasizeMethod(decidingInstruction.getMethod());
                ++i;
            }
        } else if (inst.getDecidingInstruction() != null) {
            this.emphasizeMethod(inst.getDecidingInstruction().getMethod());
        } else if (inst.getDecidingMethod() != null) {
            this.emphasizeMethod(inst.getDecidingMethod());
        } else if (inst.getDecidingInstructions() != null) {
            for (Instruction instruction : inst.getDecidingInstructions()) {
                this.emphasizeMethod(instruction.getMethod());
            }
        } else if (inst.getDecidingEventID() >= 0) {
            Instruction instruction = this.getTrace().getInstruction(inst.getDecidingEventID());
            this.emphasizeMethod(instruction.getMethod());
        }
        this.selectionConfiguration.arrange(true);
    }

    @Override
    public void showClass(Classfile classfile) {
        TokenRange range;
        FileInterface file = classfile.getSourceFile();
        if (file == null) {
            file = classfile;
        }
        if ((range = file.getTokenRangeFor(classfile)) == null) {
            this.showFile(file);
        } else {
            this.selectionConfiguration = new Configuration(classfile, range);
            this.removeWindowsArrowsAndHighlights();
            this.selectionConfiguration.arrange(true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TokenRange getRangeFor(int eventID) {
        TokenRange range;
        Trace trace = this.whylineUI.getTrace();
        EventKind kind = trace.getKind(eventID);
        Instruction inst = trace.getInstruction(eventID);
        if (kind.isArtificial) {
            if (kind.isArgument) {
                int localID = trace.getArgumentLocalIDSet(eventID);
                int parameterNumber = inst.getMethod().getArgumentNumberOfLocalID(localID);
                if (inst.getMethod().isStatic()) {
                    ++parameterNumber;
                }
                range = inst.getFile().getTokenRangeForParameter(inst.getMethod(), parameterNumber);
            } else {
                if (kind != EventKind.START_METHOD) return inst.getFile().getTokenRangeFor(inst);
                range = inst.getFile().getTokenRangeForMethod(inst.getMethod());
            }
        } else {
            range = inst.getFile().getTokenRangeFor(inst);
        }
        if (range != null) return range;
        return inst.getLine().getRange();
    }

    public Area getAreaForTokenRange(TokenRange range) {
        if (range == null || range.first == null) {
            return null;
        }
        FileInterface file = range.first.getFile();
        return this.getWindowViewOf(file).getFileView().getTokenRangeOutline(range);
    }

    public void outline(Graphics2D g, Instruction inst) {
        TokenRange range = inst.getFile().getTokenRangeFor(inst);
        if (range != null) {
            this.outline(g, range);
        }
    }

    public Area outline(Graphics2D g, TokenRange range) {
        if (range == null || range.first == null) {
            return null;
        }
        FileInterface file = range.first.getFile();
        FileWindow window = this.getWindowViewOf(file);
        if (window.getFileView() != null) {
            g = (Graphics2D)g.create();
            g.setStroke(UI.SELECTED_STROKE);
            Area path = window.getFileView().getTokenRangeOutline(range);
            g.draw(path);
            return path;
        }
        return null;
    }

    public AlphaComposite getCurrentFade() {
        return this.fade;
    }

    public int getNumberOfArrows() {
        return this.arrows.getNumberOfChildren();
    }

    public class ArrowBox
    extends View {
        private final ArrayList<ArrowView> arrows = new ArrayList(5);
        private boolean atInitialPosition = true;

        public void clear() {
            this.arrows.clear();
            this.removeChildren();
            this.layoutArrows(false);
        }

        public TokenRange getFocusRange() {
            if (FilesView.this.selectionConfiguration == null) {
                return null;
            }
            return FilesView.this.selectionConfiguration.getFocusRange();
        }

        public void layoutArrows(boolean painting) {
            for (ArrowView arrow : this.arrows) {
                arrow.layout();
            }
            int padding = this.getPadding();
            int width = (int)(Math.max((double)(FilesView.this.selectionExplanation == null ? 0 : FilesView.this.selectionExplanation.getWidth()), this.getRightmostChildsRight()) + (double)(padding * 2));
            int height = (int)(Math.max((double)(FilesView.this.selectionExplanation == null ? 0 : FilesView.this.selectionExplanation.getHeight()), this.getBottommostChildsBottom()) + (double)(padding * 2));
            if (this.atInitialPosition) {
                this.setLocalLeft(this.getParent().getLocalWidth() - (double)width - (double)UI.getPanelPadding() - FilesView.this.windowScrollBarMargin, true);
                this.setLocalTop(FilesView.this.windowHeaderHeight + (double)UI.getPanelPadding(), true);
            }
            if ((double)width < this.getParent().getLocalWidth() && this.getLocalLeft() + (double)width > this.getParent().getLocalWidth()) {
                this.setLocalLeft(this.getParent().getLocalWidth() - (double)width - (double)UI.getPanelPadding(), true);
            }
            if ((double)height < this.getParent().getLocalHeight() && this.getLocalTop() + (double)height > this.getParent().getLocalHeight()) {
                this.setLocalTop(this.getParent().getLocalHeight() - (double)height - (double)UI.getPanelPadding(), true);
            }
            this.setLocalWidth(width, !painting);
            this.setLocalHeight(height, !painting);
            if (!painting) {
                this.animate(UI.getDuration(), true);
            }
        }

        public int getPadding() {
            return 5;
        }

        public void addArrow(ArrowView arrow) {
            this.addChild(arrow);
            this.arrows.add(arrow);
        }

        public FilesView getFilesView() {
            return FilesView.this;
        }

        public void paintBelowChildren(Graphics2D g) {
            TokenRange focusRange;
            if (FilesView.this.whylineUI.getVisualizationUIVisible() == null) {
                return;
            }
            g = (Graphics2D)g.create();
            Composite old = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, 0.75f));
            this.fillRoundBoundaries(UI.IDENTIFIER_COLOR, g, UI.getRoundedness(), UI.getRoundedness());
            g.setComposite(old);
            TokenRange range = this.getFocusRange();
            Area area = FilesView.this.getAreaForTokenRange(range);
            if (area != null) {
                g.setColor(UI.getHighlightColor());
                int lineX = (int)area.getBounds().getMaxX();
                int lineY = (int)area.getBounds().getMaxY();
                Line2D line = Util.getLineBetweenRectangleEdges(lineX, lineX, lineY, lineY, this.getVisibleLocalLeft(), this.getVisibleLocalRight(), this.getVisibleLocalTop(), this.getVisibleLocalBottom());
                int offset = line.getX2() > (double)lineX ? 10 : -10;
                g.drawLine(lineX, lineY, (int)line.getX2() - offset, lineY);
                g.drawLine((int)line.getX2() - offset, lineY, (int)line.getX2(), (int)line.getY2());
            }
            if ((focusRange = this.getFocusRange()) != null) {
                boolean lineOtherwiseHighlighted = false;
                List ranges = FilesView.this.selectionConfiguration.getExternalArrowTargetRange();
                if (ranges != null) {
                    for (TokenRange r : ranges) {
                        if (r.first.getLine() != focusRange.first.getLine()) continue;
                        lineOtherwiseHighlighted = true;
                    }
                }
                if (!lineOtherwiseHighlighted) {
                    FilesView.this.outline(g, this.getFocusRange());
                }
            }
        }

        public void paintAboveChildren(Graphics2D g) {
            Visualization viz;
            Visualization visualization = viz = FilesView.this.whylineUI.getVisualizationUIVisible() == null ? null : FilesView.this.whylineUI.getVisualizationUIVisible().getVisualization();
            if (FilesView.this.selectionExplanation != null && viz != null) {
                int x = (int)this.getVisibleLocalLeft() + this.getPadding();
                int y = (int)this.getVisibleLocalTop() + this.getPadding();
                g.setColor(UI.getHighlightColor());
                FilesView.this.selectionExplanation.paint(g, x, y);
            }
        }

        public boolean handleMouseDown(int x, int y, int button) {
            this.getContainer().focusMouseOn(this);
            return true;
        }

        public boolean handleMouseDrag(int x, int y, int button) {
            this.atInitialPosition = false;
            int focusX = this.getContainer().getMouseFocusX();
            int focusY = this.getContainer().getMouseFocusY();
            this.setLocalLeft(x - focusX, false);
            this.setLocalTop(y - focusY, false);
            this.layoutArrows(false);
            return true;
        }

        public boolean handleMouseUp(int x, int y, int button) {
            this.getContainer().releaseMouseFocus();
            return true;
        }

        public boolean handleMouseMove(int x, int y) {
            return true;
        }

        public void handleMouseEnter() {
            this.getContainer().setCursor(Cursor.getPredefinedCursor(12));
        }

        public void handleMouseExit() {
            this.getContainer().setCursor(Cursor.getPredefinedCursor(0));
        }

        public boolean handleMouseClick(int x, int y, int button) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Configuration {
        private final Object focus;
        private final WindowConfiguration focusConfig;
        private final ArrayList<WindowConfiguration> otherConfigs = new ArrayList();

        public Configuration(Object focus, TokenRange focusRange) {
            assert (focusRange != null) : "Must provide legal token range. The user has to look at SOMETHING.";
            this.focus = focus;
            this.focusConfig = new WindowConfiguration(focusRange);
        }

        private void updateOtherWindows() {
            this.otherConfigs.clear();
            List<TokenRange> otherRanges = this.getExternalArrowTargetRange();
            if (otherRanges != null) {
                for (TokenRange range : otherRanges) {
                    WindowConfiguration other;
                    boolean alreadyShowing = false;
                    for (WindowConfiguration config : this.otherConfigs) {
                        if (config.file != range.first.getFile()) continue;
                        alreadyShowing = true;
                    }
                    if (this.focusConfig != null && this.focusConfig.file == range.first.getFile()) {
                        alreadyShowing = true;
                    }
                    if (alreadyShowing || (other = new WindowConfiguration(range)).window == null) continue;
                    this.otherConfigs.add(other);
                }
            }
        }

        private List<TokenRange> getExternalArrowTargetRange() {
            ArrowView arrowView = FilesView.this.getSelectedFileArrow();
            if (arrowView != null) {
                List<TokenRange> ranges = arrowView.getViableTargetTokenRanges();
                return ranges;
            }
            return null;
        }

        public void arrange(boolean animate) {
            this.updateOtherWindows();
            FilesView.this.removeWindows();
            if (this.focusConfig == null) {
                return;
            }
            FilesView.this.showWindow(this.focusConfig.window);
            if (this.otherConfigs.isEmpty()) {
                FilesView.this.placeWindow(this.focusConfig.window, 0.0, 0.0, FilesView.this.getLocalWidth(), FilesView.this.getLocalHeight(), animate);
            } else {
                double availableWidth = FilesView.this.getLocalWidth();
                FilesView.this.placeWindow(this.focusConfig.window, 0.0, 0.0, availableWidth, FilesView.this.getLocalHeight() * 0.66, animate);
                double left = 0.0;
                double top = FilesView.this.getLocalHeight() * 0.66;
                double width = availableWidth / (double)this.otherConfigs.size();
                double height = FilesView.this.getLocalHeight() / 3.0;
                for (WindowConfiguration config : this.otherConfigs) {
                    FilesView.this.showWindow(config.window);
                    FilesView.this.placeWindow(config.window, left, top, width, height, animate);
                    left += width;
                }
            }
            this.focusConfig.scroll();
            for (WindowConfiguration other : this.otherConfigs) {
                other.scroll();
            }
            if (FilesView.this.currentFader != null) {
                FilesView.this.currentFader.cancel();
                FilesView.this.currentFader = null;
            }
            FilesView.this.currentFader = new TimerTask(){
                private long start = System.currentTimeMillis();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    double now = System.currentTimeMillis();
                    double delta = now - (double)this.start;
                    double transparency = 0.33 + 0.6699999999999999 * Math.min(1.0, Math.max(0.0, delta - 250.0) / 500.0);
                    FilesView.this.fade = AlphaComposite.getInstance(3, (float)transparency);
                    if (delta > 750.0) {
                        TimerTask timerTask = FilesView.this.currentFader;
                        synchronized (timerTask) {
                            FilesView.this.currentFader.cancel();
                            FilesView.this.currentFader = null;
                        }
                    }
                    FilesView.this.repaint();
                }
            };
            FilesView.this.fadeTimer.scheduleAtFixedRate(FilesView.this.currentFader, 0L, 50L);
            FilesView.this.arrows.bringToFront();
        }

        public TokenRange getFocusRange() {
            return this.focusConfig == null ? null : this.focusConfig.range;
        }
    }

    private class WindowConfiguration {
        private final TokenRange range;
        private FileInterface file;
        private FileWindow window;
        private Token firstCodeToken;

        public WindowConfiguration(TokenRange range) {
            this.range = range;
            if (range != null && range.first != null) {
                this.firstCodeToken = null;
                for (Token t : range) {
                    if (!t.isCode()) continue;
                    this.firstCodeToken = t;
                    break;
                }
                this.file = range.first.getFile();
                this.window = FilesView.this.getWindowViewOf(this.file);
                for (Token t : range) {
                    TokenView view = this.window.getFileView().getViewOf(t);
                    if (view == null) continue;
                    view.setEmphasized(UI.getHighlightColor());
                }
            }
        }

        public void scroll() {
            if (this.firstCodeToken == null) {
                return;
            }
            TokenView view = this.window.getFileView().getViewOf(this.firstCodeToken);
            if (view != null) {
                this.window.scrollToToken(view);
            }
        }
    }
}

