/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.source;

import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.bytecode.PushConstant;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.qa.SourceFileMenuFactory;
import edu.cmu.hcii.whyline.source.FileInterface;
import edu.cmu.hcii.whyline.source.JavaSourceFile;
import edu.cmu.hcii.whyline.source.Line;
import edu.cmu.hcii.whyline.source.LineNumber;
import edu.cmu.hcii.whyline.source.Parameter;
import edu.cmu.hcii.whyline.source.ParseException;
import edu.cmu.hcii.whyline.source.Token;
import edu.cmu.hcii.whyline.source.TokenRange;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.arrows.CausalArrowView;
import edu.cmu.hcii.whyline.ui.components.WhylinePopup;
import edu.cmu.hcii.whyline.ui.events.LineHover;
import edu.cmu.hcii.whyline.ui.events.NoLineHover;
import edu.cmu.hcii.whyline.ui.source.LineView;
import edu.cmu.hcii.whyline.ui.source.TokenView;
import edu.cmu.hcii.whyline.ui.views.View;
import edu.cmu.hcii.whyline.util.Util;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileView
extends View {
    private static final int LEFT_MARGIN_SPACES = 3;
    private final WhylineUI whylineUI;
    private final FontMetrics metrics;
    private final int margin;
    private final int ascent;
    private final int descent;
    private final int characterWidth;
    private final int lineHeight;
    private final FileInterface file;
    private final ArrayList<LineView> lines;
    private Hashtable<LineView, Instruction> firstInstrumentedInstructionOnLine = new Hashtable();
    private final Vector<MethodInfo> methodsToEmphasize = new Vector();
    private View hoveredView;
    private MethodInfo hoveredMethod;
    private MethodInfo methodMouseIsOver;
    private LineSpan hoveredMethodSpan;
    private Line lineOver = null;
    private final Set<LineView> emphasizedLines = new HashSet<LineView>();
    private final Map<TokenView, Color> emphasizedTokens = new HashMap<TokenView, Color>();
    private SortedSet<LineSpan> spans = new TreeSet<LineSpan>(new Comparator<LineSpan>(){

        @Override
        public int compare(LineSpan o1, LineSpan o2) {
            return o1.first.getLine().getLineNumber().getNumber() - o2.first.getLine().getLineNumber().getNumber();
        }
    });
    private static Composite FADED_LINE_COMPOSITE = AlphaComposite.getInstance(3, 0.3f);
    private static int FADE_HEIGHT = 30;

    public int getWidthOfCharacter() {
        return this.characterWidth;
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public FileView(WhylineUI whylineUI, FileInterface source) {
        this.whylineUI = whylineUI;
        this.file = source;
        Graphics2D g = (Graphics2D)whylineUI.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        assert (g != null) : "Why is whylineUI.getGraphics() " + whylineUI.getGraphics() + "? WhylineUI = " + whylineUI + " and isDisplayable = " + whylineUI.isDisplayable();
        this.metrics = g.getFontMetrics(UI.getFixedFont());
        this.ascent = this.metrics.getMaxAscent();
        this.descent = this.metrics.getMaxDescent();
        this.lineHeight = this.metrics.getHeight();
        this.characterWidth = this.metrics.charWidth('e');
        this.margin = this.characterWidth * 3;
        this.lines = new ArrayList();
        try {
            this.lines.ensureCapacity(source.getNumberOfLines());
            if (source.getLines() != null) {
                Line[] lineArray = source.getLines();
                int n = lineArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Line line = lineArray[n2];
                    LineView view = new LineView(this, line);
                    this.addChild(view);
                    this.lines.add(view);
                    ++n2;
                }
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.trim();
        this.layoutLines();
    }

    public FontMetrics getFontMetrics() {
        return this.metrics;
    }

    public int getCharacterWidth() {
        return this.characterWidth;
    }

    public Set<TokenView> getEmphasizedTokens() {
        return this.emphasizedTokens.keySet();
    }

    public void emphasizeLine(LineView line, boolean yes) {
        if (yes) {
            this.emphasizedLines.add(line);
        } else {
            this.emphasizedLines.remove(line);
        }
    }

    public void emphasizeToken(TokenView token, Color color) {
        if (color == null) {
            this.emphasizedTokens.remove(token);
        } else {
            this.emphasizedTokens.put(token, color);
        }
    }

    public boolean isLineEmphasized(LineView line) {
        return this.emphasizedLines.contains(line);
    }

    public boolean isTokenEmphasized(TokenView token) {
        return this.emphasizedTokens.containsKey(token);
    }

    public boolean isNothingEmphasized() {
        return this.emphasizedTokens.isEmpty() && this.emphasizedLines.isEmpty();
    }

    public Color getEmphasizedTokenColor(TokenView token) {
        return this.emphasizedTokens.get(token);
    }

    public FileInterface getFile() {
        return this.file;
    }

    public WhylineUI getWhylineUI() {
        return this.whylineUI;
    }

    public double getBaseline() {
        return this.metrics.getAscent();
    }

    public double getAscent() {
        return this.ascent;
    }

    private void setHoveredView(View view) {
        this.hoveredView = view;
        this.hoveredMethod = null;
        this.hoveredMethodSpan = null;
        this.methodMouseIsOver = null;
        this.repaint();
    }

    public Line getLineOver() {
        return this.lineOver;
    }

    public LineView getHoveredLine() {
        return this.hoveredView instanceof LineView ? (LineView)this.hoveredView : null;
    }

    public TokenView getTokenUnderMouse() {
        return this.hoveredView instanceof TokenView ? (TokenView)this.hoveredView : null;
    }

    public MethodInfo getHoveredMethod() {
        return this.hoveredMethod;
    }

    public MethodInfo getMethodMouseIsOver() {
        return this.methodMouseIsOver;
    }

    public boolean doesHoveredMethodContain(LineView line) {
        if (this.hoveredMethodSpan == null) {
            return false;
        }
        return this.hoveredMethodSpan.contains(line);
    }

    public void emphasizeMethod(MethodInfo method) {
        if (this.file instanceof JavaSourceFile) assert (method.getClassfile().getSourceFile() == this.file) : "But " + this.file + " isn't the source file for " + method.getQualifiedNameAndDescriptor();
        this.methodsToEmphasize.add(method);
    }

    public void layoutLines() {
        Graphics2D g = (Graphics2D)this.whylineUI.getGraphics();
        int firstLineOfEllisionBlock = -1;
        int maxRight = 0;
        int baseline = this.metrics.getMaxAscent() + this.margin;
        int lineNumber = 0;
        for (View view : this.getChildren()) {
            LineView line = (LineView)view;
            line.setLocalLeft(this.margin, false);
            line.setLocalTop(baseline - this.metrics.getMaxAscent(), false);
            baseline = (int)((double)baseline + line.getLocalHeight());
            if (view.getLocalRight() > (double)maxRight) {
                maxRight = (int)view.getLocalRight() + this.margin;
            }
            ++lineNumber;
        }
        int maxBottom = baseline + this.metrics.getMaxDescent() + this.margin;
        this.setLocalWidth(maxRight, false);
        this.setLocalHeight(maxBottom, false);
    }

    public void removeEmphasis() {
        this.methodsToEmphasize.removeAllElements();
        this.emphasizedLines.clear();
        this.emphasizedTokens.clear();
        this.repaint();
        this.repaint();
    }

    public LineView getLineViewOf(Instruction inst) {
        if (inst != null && inst.getLineNumber() != null) {
            return (LineView)this.getChildAtIndex(inst.getLineNumber().getNumber() - 1);
        }
        return null;
    }

    public Instruction getFirstInstrumentedInstructionOnLine(LineView lineView) {
        Instruction inst = this.firstInstrumentedInstructionOnLine.get(lineView);
        if (inst == null) {
            SortedSet<Instruction> instructionsOnLine = lineView.getLine().getInstructions();
            if (instructionsOnLine == null) {
                return null;
            }
            for (Instruction candidate : instructionsOnLine) {
                if (candidate instanceof PushConstant) continue;
                inst = candidate;
                break;
            }
            if (inst != null) {
                this.firstInstrumentedInstructionOnLine.put(lineView, inst);
            }
        }
        return inst;
    }

    public LineView getViewOf(Line line) {
        if (line.getFile() != this.file) {
            return null;
        }
        return this.lines.get(line.getLineNumber().getNumber() - 1);
    }

    public TokenView getViewOf(Token token) {
        int nextLineNumber;
        LineView lineView = this.getLine(token.getLineNumber());
        do {
            for (View tokenView : lineView.getChildren()) {
                if (((TokenView)tokenView).getToken() != token) continue;
                return (TokenView)tokenView;
            }
        } while ((lineView = (nextLineNumber = lineView.getLine().getLineNumber().getNumber()) >= this.lines.size() ? null : this.lines.get(nextLineNumber)) != null);
        return null;
    }

    public LineView getLine(LineNumber number) {
        int index = number.getNumber() - 1;
        if (index < 0 || index >= this.lines.size()) {
            return null;
        }
        return this.lines.get(index);
    }

    private LineSpan getMethodSpan(MethodInfo method) {
        if (!(this.file instanceof JavaSourceFile)) {
            return null;
        }
        Token first = ((JavaSourceFile)this.file).getFirstTokenOfMethodHeader(method);
        Token last = ((JavaSourceFile)this.file).getLastTokenOfMethod(method);
        if (first != null && last != null) {
            LineView firstView = this.lines.get(first.getLineNumber().getNumber() - 1);
            LineView lastView = this.lines.get(last.getLineNumber().getNumber() - 1);
            return new LineSpan(firstView, lastView);
        }
        return null;
    }

    @Override
    public final void paintChildren(Graphics2D g) {
        MethodInfo clippedMethod;
        Rectangle clip = g.getClipBounds();
        g = (Graphics2D)g.create();
        if (this.hoveredMethodSpan != null) {
            g.setColor(UI.getHighlightColor());
            Paint oldPaint = g.getPaint();
            int width = this.characterWidth * 5;
            g.setPaint(new GradientPaint(0.0f, 0.0f, UI.getHighlightColor(), width, 0.0f, UI.getFileColor()));
            int top = (int)this.hoveredMethodSpan.first.getLocalTop();
            int bottom = (int)this.hoveredMethodSpan.last.getLocalTop();
            g.fillRect(2, top, width, bottom - top);
            g.setPaint(oldPaint);
        }
        if ((clippedMethod = this.getMethodAtVerticalPosition((int)(-this.getLocalTop()))) != null && !clippedMethod.isSynthetic()) {
            this.drawClippedHeader(g, clippedMethod);
        }
        int firstIndex = (int)Math.max(0.0, clip.getY() / (double)this.getLineHeight() - 1.0);
        int lastIndex = (int)Math.min((double)(this.getNumberOfChildren() - 1), (clip.getY() + clip.getHeight()) / (double)this.getLineHeight());
        if (!this.file.isFamiliar()) {
            int spacing = UI.getCrosshatchSpacing() * 15;
            Util.drawCrosshatch(g, UI.FILE_FADED_COLOR, clip.x, clip.x + clip.width, clip.y, clip.height, spacing, clip.y % spacing);
        }
        int i = firstIndex;
        while (i <= lastIndex) {
            this.getChildAtIndex(i).paintBelowChildren(g);
            ++i;
        }
        i = firstIndex;
        while (i <= lastIndex) {
            this.getChildAtIndex(i).paint(g);
            ++i;
        }
        i = firstIndex;
        while (i <= lastIndex) {
            this.getChildAtIndex(i).paintAboveChildren(g);
            ++i;
        }
    }

    private void drawClippedHeader(Graphics2D g, MethodInfo method) {
        Rectangle clip = g.getClipBounds();
        int topOfFrame = (int)(-this.getLocalTop());
        LineSpan span = this.getMethodSpan(method);
        if (span != null && span.first.getLocalTop() < (double)topOfFrame) {
            if (span.first.getLocalTop() != span.first.getVisibleLocalTop()) {
                return;
            }
            int offset = span.first.getLocalTop() < (double)topOfFrame && span.first.getLocalBottom() > (double)topOfFrame ? (int)(span.first.getLocalBottom() - (double)topOfFrame) + 1 : 0;
            Graphics2D oldg = g;
            g = (Graphics2D)g.create();
            g.setClip(new Rectangle(clip.x + UI.getBorderPadding(), topOfFrame - this.lineHeight * 2, clip.width - UI.getBorderPadding(), this.lineHeight * 2));
            LineView methodHeader = span.first;
            int left = (int)(methodHeader.getLocalLeft() + (double)methodHeader.getLeftAfterWhitespace()) - UI.getPanelPadding();
            int top = topOfFrame - this.ascent - 2 + offset;
            int width = (int)methodHeader.getLocalRight() - left + UI.getPanelPadding() * 2;
            int height = (int)methodHeader.getLocalHeight();
            g.setColor(UI.getFileColor());
            g.fillRoundRect(left, top - UI.getBorderPadding() * 2, width, height + UI.getRoundedness() / 3 + this.lineHeight, UI.getRoundedness(), UI.getRoundedness());
            g.setColor(UI.getControlBorderColor());
            g.drawRoundRect(left, top - UI.getBorderPadding() * 2, width, height + UI.getRoundedness() / 3 + this.lineHeight, UI.getRoundedness(), UI.getRoundedness());
            int delta = (int)((double)topOfFrame - methodHeader.getLocalTop() - (double)this.ascent - 2.0) - UI.getBorderPadding() + offset;
            g.translate(0, delta);
            methodHeader.paint(g);
            g.translate(0, -delta);
            g = oldg;
        }
    }

    @Override
    public boolean handleMouseClick(int x, int y, int button) {
        int localY = (int)this.globalTopToLocal(y);
        Line line = this.getLineAtVerticalPosition(localY);
        WhylinePopup popup = new WhylinePopup("");
        SourceFileMenuFactory.addQuestionsForMethod(this.whylineUI, popup, line);
        return this.getContainer().showPopup(popup, (int)this.getGlobalLeft() + (int)((double)x - this.getLocalLeft()), (int)this.getGlobalTop() + (int)((double)y - this.getLocalTop()));
    }

    @Override
    public void handleMouseNoLongerDirectlyOver(int x, int y) {
        this.setHoveredView(null);
    }

    @Override
    public boolean handleMouseMove(int x, int y) {
        if (this.getWhylineUI().userIsAskingQuestion()) {
            return false;
        }
        this.setHoveredView(null);
        int fileY = (int)this.globalTopToLocal(y);
        this.methodMouseIsOver = this.getMethodAtVerticalPosition(fileY);
        List<View> views = this.getContainer().getViewsUnderMouse();
        Line line = this.getLineAtVerticalPosition(y - (int)this.getLocalTop());
        if (line != null) {
            if (line != this.lineOver) {
                this.lineOver = line;
                this.getWhylineUI().log(new LineHover(this.lineOver, "source"));
            }
        } else if (this.lineOver != null) {
            this.lineOver = null;
            this.getWhylineUI().log(new NoLineHover("source"));
        }
        for (View view : views) {
            if (view instanceof CausalArrowView) {
                return false;
            }
            if (view instanceof TokenView) {
                Token token = ((TokenView)view).getToken();
                Instruction code = this.file.getInstructionFor(token);
                QualifiedClassName classname = this.file.getClassnameFor(token);
                Parameter parameter = this.file.getMethodParameterFor(token);
                if (code == null && classname == null && parameter == null) continue;
                this.setHoveredView(view);
                return true;
            }
            if (view instanceof LineView && (double)x > view.getLocalLeft() + (double)((LineView)view).getLeftAfterWhitespace() && ((LineView)view).getFirstInstrumentedInstructionOnLine() != null) {
                this.setHoveredView(view);
                return true;
            }
            if (view != this) continue;
            if (this.methodMouseIsOver != null && this.hoveredMethod != this.methodMouseIsOver) {
                this.hoveredMethod = this.methodMouseIsOver;
                this.hoveredMethodSpan = this.getMethodSpan(this.hoveredMethod);
            }
            return false;
        }
        return false;
    }

    @Override
    public void handleMouseExit() {
        if (this.getWhylineUI().userIsAskingQuestion()) {
            return;
        }
        this.setHoveredView(null);
        this.getWhylineUI().log(new NoLineHover("source"));
    }

    public Line getLineAtVerticalPosition(int y) {
        Line line = null;
        for (View view : this.getChildren()) {
            if (!(view instanceof LineView) || !(view.getLocalTop() <= (double)y) || !(view.getLocalBottom() >= (double)y)) continue;
            line = ((LineView)view).getLine();
            break;
        }
        return line;
    }

    public MethodInfo getMethodAtVerticalPosition(int y) {
        if (!(this.file instanceof JavaSourceFile)) {
            return null;
        }
        Line line = this.getLineAtVerticalPosition(y);
        if (line != null) {
            return ((JavaSourceFile)this.file).getMethodOfLine(line);
        }
        return null;
    }

    public Area getTokenRangeOutline(TokenRange range) {
        int padding = (int)((double)this.characterWidth * 0.66);
        Area area = new Area();
        for (Token token : range) {
            TokenView tokenView;
            LineView lineView = this.getLine(token.getLineNumber());
            TokenView tokenView2 = tokenView = lineView == null ? null : lineView.getViewOf(token);
            if (tokenView == null) continue;
            Rectangle bounds = tokenView.getGlobalBoundaries();
            RoundRectangle2D.Double rect = new RoundRectangle2D.Double(((RectangularShape)bounds).getX() - (double)padding, ((RectangularShape)bounds).getY() - (double)padding, ((RectangularShape)bounds).getWidth() + (double)(padding * 2), ((RectangularShape)bounds).getHeight() + (double)(padding * 2), padding / 2, padding / 2);
            area.add(new Area(rect));
        }
        return area;
    }

    private static class LineSpan {
        public final LineView first;
        public final LineView last;
        private final int firstNumber;
        private final int lastNumber;

        public LineSpan(LineView first, LineView last) {
            this.first = first;
            this.last = last;
            this.firstNumber = first.getLine().getLineNumber().getNumber();
            this.lastNumber = last.getLine().getLineNumber().getNumber();
        }

        public boolean contains(LineView line) {
            int number = line.getLine().getLineNumber().getNumber();
            return this.firstNumber <= number && number <= this.lastNumber;
        }

        public String toString() {
            return this.firstNumber + " to " + this.lastNumber;
        }
    }
}

