/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.qa;

import edu.cmu.hcii.whyline.qa.Answer;
import edu.cmu.hcii.whyline.qa.Explanation;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.qa.EventBlockView;
import edu.cmu.hcii.whyline.ui.qa.EventView;
import edu.cmu.hcii.whyline.ui.qa.SituationUI;
import edu.cmu.hcii.whyline.ui.qa.UnexecutedInstructionView;
import edu.cmu.hcii.whyline.ui.qa.Visualization;
import edu.cmu.hcii.whyline.ui.views.DynamicComponent;
import edu.cmu.hcii.whyline.ui.views.DynamicComponentWithSelection;
import edu.cmu.hcii.whyline.ui.views.View;
import java.util.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VisualizationUI
extends DynamicComponentWithSelection<View> {
    private final SituationUI situationUI;
    private final WhylineUI whylineUI;
    private final Visualization visualization;
    private Timer timerForTrackingScrolling;

    public VisualizationUI(SituationUI ui, Answer answer) {
        super(ui.getWhylineUI(), DynamicComponent.Sizing.SCROLL_OR_FIT_IF_SMALLER, DynamicComponent.Sizing.SCROLL_OR_FIT_IF_SMALLER);
        this.situationUI = ui;
        this.whylineUI = this.situationUI.getWhylineUI();
        this.visualization = new Visualization(this.whylineUI, this, answer);
        this.setView(this.visualization);
        this.setRequestFocusOnEnter(true);
        this.setRequestFocusOnClick(true);
    }

    public Visualization getVisualization() {
        return this.visualization;
    }

    public Answer getAnswer() {
        return this.situationUI.getAnswer();
    }

    public SituationUI getSituationUI() {
        return this.situationUI;
    }

    public void scaleVisualizationToViewport() {
        this.visualization.fitToChildrenAndScaleToViewport();
    }

    public View getEventAfter(View selection) {
        if (selection instanceof EventView) {
            EventView eventView = this.visualization.getUncollapsedEventViewAfter((EventView)selection);
            if (eventView != null) {
                return eventView;
            }
            return this.visualization.getFirstUnexecutedInstructionView();
        }
        if (selection instanceof UnexecutedInstructionView) {
            return this.visualization.getUnexecutedInstructionAt(((UnexecutedInstructionView)selection).getRow(), ((UnexecutedInstructionView)selection).getColumn() - 1);
        }
        return null;
    }

    public View getEventBefore(View selection) {
        if (selection instanceof EventView) {
            return this.visualization.getUncollapsedEventViewBefore((EventView)selection);
        }
        if (selection instanceof UnexecutedInstructionView) {
            UnexecutedInstructionView viewBefore = this.visualization.getUnexecutedInstructionAt(((UnexecutedInstructionView)selection).getRow(), ((UnexecutedInstructionView)selection).getColumn() + 1);
            if (viewBefore != null) {
                return viewBefore;
            }
            Explanation lastEvent = this.visualization.getLastExplanation();
            if (lastEvent != null) {
                return this.visualization.getViewOfExplanation(lastEvent);
            }
            return null;
        }
        return null;
    }

    public View getEnclosingBlock(View selection) {
        if (selection instanceof EventView) {
            EventView eventView = (EventView)selection;
            EventBlockView<?> parent = eventView.getBlockView();
            return parent;
        }
        if (selection instanceof UnexecutedInstructionView) {
            return this.visualization.getUnexecutedInstructionAt(((UnexecutedInstructionView)selection).getRow() - 1, ((UnexecutedInstructionView)selection).getColumn());
        }
        return null;
    }

    public View getNextEnclosedBlock(View selection) {
        if (selection instanceof EventView) {
            EventView eventView = (EventView)selection;
            if (eventView instanceof EventBlockView) {
                for (View child : eventView.getChildren()) {
                    if (!(child instanceof EventBlockView)) continue;
                    return child;
                }
                return this.getEventAfter(eventView.getLastChild());
            }
            return this.getEventAfter(selection);
        }
        if (selection instanceof UnexecutedInstructionView) {
            return this.visualization.getUnexecutedInstructionAt(((UnexecutedInstructionView)selection).getRow() + 1, ((UnexecutedInstructionView)selection).getColumn());
        }
        return null;
    }

    @Override
    public void handleNewSelection(View selection, boolean scroll, String ui) {
        this.visualization.selectAndScrollToView(selection, scroll, ui);
        this.situationUI.updateHintsWith(selection);
    }

    public void show(Explanation subject) {
        EventView view = this.visualization.getViewOfExplanation(subject);
        if (view != null) {
            this.setSelection(view, true);
        }
    }

    @Override
    public int getVerticalScrollIncrement() {
        return 25;
    }

    @Override
    public int getHorizontalScrollIncrement() {
        return 50;
    }
}

