/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.qa;

import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.qa.Explanation;
import edu.cmu.hcii.whyline.qa.Question;
import edu.cmu.hcii.whyline.qa.UnexecutedInstruction;
import edu.cmu.hcii.whyline.source.FileInterface;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.UserFocusListener;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.components.WhylinePanel;
import edu.cmu.hcii.whyline.ui.qa.AnswerUI;
import edu.cmu.hcii.whyline.ui.qa.SituationUI;
import edu.cmu.hcii.whyline.ui.qa.VisualizationUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QuestionsUI
extends WhylinePanel
implements UserFocusListener {
    private final WhylineUI whylineUI;
    private final ArrayList<Question<?>> questions = new ArrayList();
    private final HashMap<Question<?>, AnswerUI> answerPanelsByQuestion = new HashMap();
    private Question<?> questionSelected = null;

    public QuestionsUI(WhylineUI whylineUI) {
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(UI.getDefaultInfoPaneWidth(whylineUI), (int)((double)UI.getDefaultInfoPaneHeight(whylineUI) * 1.5)));
        this.whylineUI = whylineUI;
    }

    public void handleArrowOverChanged() {
        VisualizationUI visualizationUI;
        AnswerUI answerUI = this.getAnswerUIVisible();
        SituationUI situationUI = answerUI == null ? null : answerUI.getSituationSelected();
        VisualizationUI visualizationUI2 = visualizationUI = situationUI == null ? null : situationUI.getVisualizationUI();
        if (visualizationUI != null) {
            visualizationUI.getVisualization().handleArrowOverChanged();
        }
    }

    public void setQuestion(Question<?> question) {
        this.questionSelected = question;
        this.removeAll();
        if (question != null) {
            AnswerUI answerUI = this.answerPanelsByQuestion.get(question);
            if (answerUI == null) {
                answerUI = new AnswerUI(this.whylineUI, question);
                this.answerPanelsByQuestion.put(question, answerUI);
                this.questions.add(question);
            }
            this.add((Component)answerUI, "Center");
            if (answerUI.getSituationSelected() != null) {
                answerUI.getSituationSelected().getVisualizationUI().requestFocusInWindow();
            }
        }
    }

    public Question<?> getQuestionVisible() {
        return this.questionSelected;
    }

    public void removeQuestion(Question<?> question) {
        this.answerPanelsByQuestion.remove(question);
        this.questions.remove(question);
    }

    public SituationUI getSituationVisible() {
        return this.getQuestionVisible() == null ? null : this.answerPanelsByQuestion.get(this.getQuestionVisible()).getSituationSelected();
    }

    public AnswerUI getAnswerUIVisible() {
        return this.getQuestionVisible() == null ? null : this.answerPanelsByQuestion.get(this.getQuestionVisible());
    }

    @Override
    public void showInstruction(Instruction subject) {
    }

    @Override
    public void showInstructions(Iterable<? extends Instruction> subject) {
    }

    @Override
    public void showEvent(int eventID) {
    }

    @Override
    public void showMethod(MethodInfo subject) {
    }

    @Override
    public void showClass(Classfile subject) {
    }

    @Override
    public void showFile(FileInterface subject) {
    }

    @Override
    public void showUnexecutedInstruction(UnexecutedInstruction subject) {
    }

    @Override
    public void showExplanation(Explanation subject) {
        SituationUI answerVisible;
        AnswerUI answerPanel;
        if (this.getQuestionVisible() != null && subject != null && (answerPanel = this.answerPanelsByQuestion.get(this.getQuestionVisible())) != null && (answerVisible = answerPanel.getSituationSelected()) != null) {
            answerVisible.getVisualizationUI().show(subject);
        }
    }
}

