/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.qa;

import edu.cmu.hcii.whyline.qa.Explanation;
import edu.cmu.hcii.whyline.qa.ExplanationBlock;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.qa.EventView;
import edu.cmu.hcii.whyline.ui.qa.Visualization;
import edu.cmu.hcii.whyline.ui.views.View;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EventBlockView<T extends ExplanationBlock>
extends EventView {
    protected final T block;
    private boolean isCollapsed = false;
    protected int numberOfVisibleBlockChildren = 0;

    public EventBlockView(Visualization visualization, T block) {
        super(visualization, (Explanation)block);
        visualization.associateBlockWithView((ExplanationBlock)block, this);
        this.block = block;
        this.setLocalTop(0.0, false);
        this.setPercentToScaleChildren(1.0);
        this.synchronizeWithModel();
        this.setCollapsed(true);
    }

    @Override
    protected boolean isFamiliarInitially() {
        return this.visualization.getTrace().hasUserSourceFileFor(this.visualization.getTrace().getInstruction(this.getEventID()).getClassfile());
    }

    public final double determineHeight(boolean animate) {
        double maxHeight = 48.0;
        for (View child : this.getChildren()) {
            maxHeight = child instanceof EventBlockView ? Math.max(maxHeight, ((EventBlockView)child).determineHeight(animate)) : Math.max(maxHeight, 48.0);
        }
        if (!this.isHidden() || this.numberOfVisibleBlockChildren != 0) {
            maxHeight += 0.0;
        }
        this.setLocalHeight(maxHeight, animate);
        return maxHeight;
    }

    public void setCollapsed(boolean collapsed) {
        boolean changed = this.isCollapsed ^ collapsed;
        this.isCollapsed = collapsed;
        for (View view : this.getChildren()) {
            ((EventView)view).markAncestorIsCollapsed(this.isCollapsed || this.ancestorIsCollapsed);
        }
        if (changed) {
            this.updateDescription();
        }
    }

    @Override
    protected final void markAncestorIsCollapsed(boolean parentIsCollapsed) {
        boolean ancestorIsCollapsed = this.isCollapsed || parentIsCollapsed;
        for (View view : this.getChildren()) {
            ((EventView)view).markAncestorIsCollapsed(ancestorIsCollapsed);
        }
        super.markAncestorIsCollapsed(parentIsCollapsed);
    }

    public boolean isCollapsed() {
        return this.isCollapsed;
    }

    public void uncollapseAncestors() {
        EventBlockView<?> blockView = this;
        while (blockView != null) {
            blockView.setCollapsed(false);
            blockView = blockView.getBlockView();
        }
    }

    @Override
    public final double getWidthBasedOnBlocksCollapsedState() {
        return this.ancestorIsCollapsed() ? 0.0 : (this.isCollapsed ? this.getGlobalOffsetForFirstView() : Math.max(this.getGlobalOffsetForFirstView(), this.getRightmostChildsRight() * this.getPercentToScaleChildren()));
    }

    public final double getGlobalOffsetForFirstView() {
        if (this.isHidden()) {
            return 0.0;
        }
        if (this.isCollapsed) {
            return 8.0 + this.widthOfLabel;
        }
        return 4.0 + this.widthOfLabel + 4.0 + this.getPaddingAfterLabel();
    }

    protected double getPaddingAfterLabel() {
        return 0.0;
    }

    public void synchronizeWithModel() {
        this.removeChildren();
        for (Explanation explanation : ((ExplanationBlock)this.block).getEvents()) {
            EventView child;
            EventBlockView<?> eventBlockView = child = explanation instanceof ExplanationBlock ? this.visualization.getViewOfBlock((ExplanationBlock)explanation) : this.visualization.getViewOfExplanation(explanation);
            if (child == null) {
                child = this.visualization.createViewFor(explanation);
            }
            this.addChild(child);
        }
        this.numberOfVisibleBlockChildren = 0;
        for (View view : this.getChildren()) {
            ((EventView)view).markAncestorIsCollapsed(this.isCollapsed || this.ancestorIsCollapsed);
            if (!(view instanceof EventBlockView) || ((EventBlockView)view).isHidden()) continue;
            ++this.numberOfVisibleBlockChildren;
        }
    }

    public Visualization getVisualization() {
        return this.visualization;
    }

    public T getBlock() {
        return this.block;
    }

    @Override
    public int getGlobalSelectionPointX() {
        return (int)(this.getGlobalLeft() + 4.0 + this.widthOfLabel / 2.0);
    }

    @Override
    public int getGlobalYToPointTo() {
        return (int)(this.getGlobalTop() + this.heightOfLabel / 2.0);
    }

    @Override
    public boolean containsGlobalTimeControllerX(int timeControllerX) {
        double globalLeftOfLabel = this.getGlobalLeft() + 4.0;
        double globalRightOfLabel = globalLeftOfLabel + this.widthOfLabel;
        return (double)timeControllerX >= globalLeftOfLabel && (double)timeControllerX <= globalRightOfLabel;
    }

    protected boolean thisOrChildOfThisIsSelected() {
        EventView selection = this.visualization.getSelectedEventView();
        return selection == this;
    }

    @Override
    public final void paintAboveChildren(Graphics2D g) {
        if (!this.isHidden() && !this.isFamiliar()) {
            this.paintCrosshatch(g, (int)this.widthOfLabel + 4);
        }
    }

    @Override
    public final void paintBelowChildren(Graphics2D g) {
        super.paintBelowChildren(g);
        if (!this.isHidden()) {
            g = (Graphics2D)g.create();
            if (this.isCollapsed) {
                this.paintCollapsed(g);
            } else {
                this.paintExpanded(g);
            }
        }
    }

    @Override
    public final void paintChildren(Graphics2D g) {
        if (!this.isCollapsed && !this.ancestorIsCollapsed()) {
            super.paintChildren(g);
        }
    }

    protected void paintExpanded(Graphics2D g) {
        boolean selected;
        EventView selection = this.visualization.getSelectedEventView();
        boolean bl = selected = selection == this;
        if (selected) {
            this.drawSelection(g);
        } else if (this.getBlockView() != null && selection != null && selection.getNearestVisibleBlockView() == this) {
            this.drawRoundBoundaries(this.determineBorderColor(), g, UI.getRoundedness(), UI.getRoundedness());
        }
        g.setColor(UI.getControlTextColor());
        this.paintLabel(g);
    }

    protected void drawSelection(Graphics2D g) {
        double y = this.getVisibleLocalBottom() - (this.getVisibleLocalHeight() - this.heightOfLabel) / 2.0;
        Stroke stroke = g.getStroke();
        g.setStroke(UI.SELECTED_STROKE);
        g.setColor(UI.getHighlightColor());
        g.drawRoundRect((int)this.getVisibleLocalLeft(), (int)(y - this.heightOfLabel), (int)this.widthOfLabel + 8, (int)this.heightOfLabel, UI.getRoundedness(), UI.getRoundedness());
        g.setStroke(stroke);
    }

    private void paintCollapsed(Graphics2D g) {
        boolean selected = this.visualization.getSelectedEventView() == this;
        Color borderColor = this.determineBorderColor();
        if (borderColor != null) {
            this.fillRoundBoundaries(borderColor, g, UI.getRoundedness(), UI.getRoundedness());
            if (selected) {
                this.paintSelectionBorder(g);
            } else {
                this.drawRoundBoundaries(borderColor, g, UI.getRoundedness(), UI.getRoundedness());
            }
        }
        g.setColor(UI.getControlTextColor());
        this.paintLabel(g);
    }
}

