/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.qa;

import edu.cmu.hcii.whyline.bytecode.Branch;
import edu.cmu.hcii.whyline.qa.BranchBlock;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.qa.EventBlockView;
import edu.cmu.hcii.whyline.ui.qa.Visualization;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchBlockView
extends EventBlockView<BranchBlock> {
    private boolean isRedundantLoopBlock;

    public BranchBlockView(Visualization visualization, BranchBlock block) {
        super(visualization, block);
    }

    @Override
    public boolean isFamiliarInitially() {
        return this.visualization.getTrace().hasUserSourceFileFor(this.visualization.getTrace().getInstruction(this.getEventID()).getClassfile());
    }

    protected void setIsRedundantLoopBlock(boolean isRedundant) {
        this.isRedundantLoopBlock = isRedundant;
        this.updateDescription();
    }

    @Override
    public String determineFirstLine() {
        return ((Branch)this.visualization.getTrace().getInstruction(this.getExplanation().getEventID())).getKeyword();
    }

    @Override
    public String determineSecondLine() {
        return null;
    }

    @Override
    protected Color determineBorderColor() {
        if (this.isRedundantLoopBlock) {
            return UI.CONTROL_COLOR;
        }
        return UI.CONTROL_COLOR;
    }

    @Override
    protected void paintExpanded(Graphics2D g) {
        g.setColor(this.determineBorderColor());
        int x = (int)(this.getVisibleLocalLeft() + this.widthOfLabel + 8.0);
        g.drawLine(x, (int)this.getVisibleLocalTop(), x, (int)this.getVisibleLocalBottom());
        super.paintExpanded(g);
    }

    @Override
    public void drawSelection(Graphics2D g) {
        Stroke stroke = g.getStroke();
        g.setStroke(UI.SELECTED_STROKE);
        g.setColor(UI.getHighlightColor());
        g.drawRoundRect((int)this.getLocalLeft(), (int)this.getLocalTop(), (int)this.widthOfLabel + 8, (int)this.getLocalHeight(), UI.getRoundedness(), UI.getRoundedness());
        g.setStroke(stroke);
    }

    @Override
    protected void paintLabel(Graphics2D g) {
        g.drawGlyphVector(this.getFirstLineGlyphs(), (float)this.getVisibleLocalLeft() + 4.0f, (float)(this.getLocalTop() + this.heightOfLabel));
    }
}

