/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.launcher;

import edu.cmu.hcii.whyline.ui.launcher.LauncherUI;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;

public class LauncherUIActions {
    private final LauncherUI launcher;
    public final Action createConfiguration;
    public final Action clearConfigurations;
    public final Action removeConfiguration;
    public final Action editConfiguration;
    public final Action clearClassCache;
    public final Action deleteSelectedTrace;
    public final Action deleteAllSavedTraces;
    public final Action cancelRunning;

    public LauncherUIActions(LauncherUI ui) {
        this.launcher = ui;
        this.createConfiguration = new AbstractAction("Create config"){

            public void actionPerformed(ActionEvent arg0) {
                LauncherUIActions.this.launcher.createConfig();
            }
        };
        this.editConfiguration = new AbstractAction("Edit config"){

            public void actionPerformed(ActionEvent arg0) {
                LauncherUIActions.this.launcher.editSelectedConfiguration();
            }
        };
        this.clearConfigurations = new AbstractAction("Delete all configs"){

            public void actionPerformed(ActionEvent arg0) {
                int choice = JOptionPane.showConfirmDialog(LauncherUIActions.this.launcher, "Are you sure you want to delete all executions?", "Are you sure?", 0);
                if (choice == 0) {
                    LauncherUIActions.this.launcher.clearAllConfigurations();
                }
            }
        };
        this.removeConfiguration = new AbstractAction("Delete config"){

            public void actionPerformed(ActionEvent arg) {
                if (LauncherUIActions.this.launcher.getConfigurationBeingEdited() == null) {
                    return;
                }
                int choice = JOptionPane.showConfirmDialog(LauncherUIActions.this.launcher, "<html>Are you sure you want to delete <i>" + LauncherUIActions.this.launcher.getConfigurationBeingEdited().getName() + "</i>?</html>", "Are you sure?", 0);
                if (choice == 0) {
                    LauncherUIActions.this.launcher.removeConfigurationBeingEdited();
                }
            }
        };
        this.clearClassCache = new AbstractAction("Clear class cache"){

            public void actionPerformed(ActionEvent arg) {
                Object[] options = new String[]{"Yes, delete the cache!", "Don't delete it!"};
                int answer = JOptionPane.showOptionDialog(LauncherUIActions.this.launcher, "Are you sure you want to delete the class cache?", "Delete the cache?", 0, 3, null, options, "Don't delete it!");
                if (answer == 0) {
                    LauncherUIActions.this.launcher.clearClassCache();
                }
            }
        };
        this.deleteSelectedTrace = new AbstractAction("Delete trace"){

            public void actionPerformed(ActionEvent e) {
                Object trace = LauncherUIActions.this.launcher.getSelectedSavedTrace();
                int choice = JOptionPane.showConfirmDialog(LauncherUIActions.this.launcher, "<html>Are you sure you want to delete <i>" + trace + "</i>?</html>", "Are you sure?", 0);
                if (choice == 0) {
                    LauncherUIActions.this.launcher.deleteSelectedTrace();
                }
            }
        };
        this.deleteAllSavedTraces = new AbstractAction("Delete all traces"){

            public void actionPerformed(ActionEvent e) {
                int choice = JOptionPane.showConfirmDialog(LauncherUIActions.this.launcher, "<html>Are you sure you want to delete <i>all of the traces</i>?", "Are you sure?", 0);
                if (choice == 0) {
                    LauncherUIActions.this.launcher.deleteAllTraces();
                }
            }
        };
        this.cancelRunning = new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent e) {
                LauncherUIActions.this.launcher.cancelCurrentExecution();
            }
        };
    }
}

