/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.io;

import edu.cmu.hcii.whyline.io.ModifyClipEvent;
import edu.cmu.hcii.whyline.io.ModifyTransformEvent;
import edu.cmu.hcii.whyline.io.SetBackgroundEvent;
import edu.cmu.hcii.whyline.io.SetCompositeEvent;
import edu.cmu.hcii.whyline.io.SetFontEvent;
import edu.cmu.hcii.whyline.io.SetPaintEvent;
import edu.cmu.hcii.whyline.io.SetStrokeEvent;
import edu.cmu.hcii.whyline.io.TranslateEvent;
import edu.cmu.hcii.whyline.io.WindowState;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class GraphicsContext {
    private final WindowState windowState;
    private final Graphics2D context;
    private int originX = 0;
    private int originY = 0;
    private final Rectangle clip;
    private SetPaintEvent latestPaintChange;
    private SetFontEvent latestFontChange;
    private SetStrokeEvent latestStrokeChange;
    private ModifyTransformEvent latestTransformChange;
    private SetCompositeEvent latestCompositeChange;
    private ModifyClipEvent latestClipChange;
    private SetBackgroundEvent latestBackgroundChange;
    private final boolean representsWindow;

    public GraphicsContext(WindowState windowState, Graphics2D context, int originX, int originY, boolean representsWindow) {
        this.windowState = windowState;
        this.context = context;
        this.originX = originX;
        this.originY = originY;
        this.clip = context.getClipBounds() == null ? null : new Rectangle(context.getClipBounds());
        this.representsWindow = representsWindow;
    }

    public GraphicsContext(GraphicsContext contextToCopy) {
        this.windowState = contextToCopy.windowState;
        this.context = (Graphics2D)contextToCopy.context.create();
        this.originX = contextToCopy.originX;
        this.originY = contextToCopy.originY;
        this.clip = contextToCopy.clip;
        this.latestPaintChange = contextToCopy.latestPaintChange;
        this.latestFontChange = contextToCopy.latestFontChange;
        this.latestStrokeChange = contextToCopy.latestStrokeChange;
        this.latestTransformChange = contextToCopy.latestTransformChange;
        this.latestCompositeChange = contextToCopy.latestCompositeChange;
        this.latestClipChange = contextToCopy.latestClipChange;
        this.latestBackgroundChange = contextToCopy.latestBackgroundChange;
        this.representsWindow = contextToCopy.representsWindow;
    }

    public boolean representsWindow() {
        return this.representsWindow;
    }

    public WindowState getWindowState() {
        return this.windowState;
    }

    public Graphics2D getGraphics() {
        return this.context;
    }

    public int getOriginX() {
        return this.originX;
    }

    public int getOriginY() {
        return this.originY;
    }

    public Rectangle getClipBounds() {
        return this.clip;
    }

    public ModifyClipEvent getLatestClipChange() {
        return this.latestClipChange;
    }

    public void setLatestClipChange(ModifyClipEvent latestClipChange) {
        this.latestClipChange = latestClipChange;
    }

    public SetCompositeEvent getLatestCompositeChange() {
        return this.latestCompositeChange;
    }

    public void setLatestCompositeChange(SetCompositeEvent latestCompositeChange) {
        this.latestCompositeChange = latestCompositeChange;
    }

    public SetFontEvent getLatestFontChange() {
        return this.latestFontChange;
    }

    public void setLatestFontChange(SetFontEvent latestFontChange) {
        this.latestFontChange = latestFontChange;
    }

    public SetPaintEvent getLatestPaintChange() {
        return this.latestPaintChange;
    }

    public void setLatestPaintChange(SetPaintEvent latestPaintChange) {
        this.latestPaintChange = latestPaintChange;
    }

    public SetStrokeEvent getLatestStrokeChange() {
        return this.latestStrokeChange;
    }

    public void setLatestStrokeChange(SetStrokeEvent latestStrokeChange) {
        this.latestStrokeChange = latestStrokeChange;
    }

    public ModifyTransformEvent getLatestTransformChange() {
        return this.latestTransformChange;
    }

    public void setLatestTransformChange(ModifyTransformEvent latestTransformChange) {
        if (latestTransformChange instanceof TranslateEvent) {
            this.originX += ((TranslateEvent)latestTransformChange).getTranslateX();
            this.originY += ((TranslateEvent)latestTransformChange).getTranslateY();
        }
        this.latestTransformChange = latestTransformChange;
    }

    public SetBackgroundEvent getLatestBackgroundChange() {
        return this.latestBackgroundChange;
    }

    public void setLatestBackgroundChange(SetBackgroundEvent latestBackgroundChange) {
        this.latestBackgroundChange = latestBackgroundChange;
    }
}

