/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.io;

import edu.cmu.hcii.whyline.qa.ExceptionMenuFactory;
import edu.cmu.hcii.whyline.qa.QuestionMenu;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.components.WhylineControlBorder;
import edu.cmu.hcii.whyline.ui.components.WhylineList;
import edu.cmu.hcii.whyline.ui.components.WhylinePanel;
import edu.cmu.hcii.whyline.ui.components.WhylinePopup;
import edu.cmu.hcii.whyline.ui.components.WhylineScrollPane;
import edu.cmu.hcii.whyline.util.IntegerVector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class ExceptionsUI
extends WhylinePanel {
    private final WhylineUI whylineUI;
    private final IntegerVector exceptions = new IntegerVector(20);
    private final WhylineList list;
    private boolean parsedExceptions = false;
    private MouseEvent recentMouseEvent = null;

    public ExceptionsUI(WhylineUI whylineUI) {
        super(new BorderLayout());
        this.setBorder(new WhylineControlBorder());
        this.whylineUI = whylineUI;
        this.list = new WhylineList();
        this.list.setSelectionMode(0);
        this.list.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ExceptionsUI.this.recentMouseEvent = e;
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (ExceptionsUI.this.whylineUI.getVisualizationUIVisible() != null) {
                    return;
                }
                int exceptionEventID = (Integer)ExceptionsUI.this.list.getSelectedValue();
                ExceptionsUI.this.whylineUI.selectInstruction(ExceptionsUI.this.whylineUI.getTrace().getInstruction(exceptionEventID), true, "exceptions");
                QuestionMenu menu = ExceptionMenuFactory.getQuestionMenuForException(ExceptionsUI.this.whylineUI, exceptionEventID);
                WhylinePopup popup = menu.generatePopupMenu();
                popup.show(ExceptionsUI.this.list, ExceptionsUI.this.recentMouseEvent == null ? 0 : ExceptionsUI.this.recentMouseEvent.getX(), ExceptionsUI.this.recentMouseEvent == null ? 0 : ExceptionsUI.this.recentMouseEvent.getY());
            }
        });
        this.add((Component)new WhylineScrollPane(this.list), "Center");
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                ExceptionsUI.this.parseExceptions();
            }
        });
    }

    private void parseExceptions() {
        if (this.parsedExceptions) {
            return;
        }
        this.parsedExceptions = true;
        Trace trace = this.whylineUI.getTrace();
        IntegerVector times = trace.getExceptionHistory().getTimes();
        int i = 0;
        while (i < times.size()) {
            this.exceptions.append(times.get(i));
            ++i;
        }
        this.list.setModel(new AbstractListModel(){

            public int getSize() {
                return ExceptionsUI.this.exceptions.size();
            }

            public Object getElementAt(int i) {
                return new Integer(ExceptionsUI.this.exceptions.get(i));
            }
        });
        if (this.exceptions.isEmpty()) {
            this.list.setFont(UI.getLargeFont());
            this.list.setListData(new String[]{"Program didn't throw or catch any exceptions."});
            this.list.setEnabled(false);
        } else {
            this.list.setCellRenderer(new ExceptionRenderer());
        }
    }

    class ExceptionRenderer
    extends JLabel
    implements ListCellRenderer {
        private ExceptionRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            int exceptionEventID = (Integer)value;
            this.setText("<html>" + ExceptionsUI.this.whylineUI.getTrace().getHTMLDescription(exceptionEventID));
            if (isSelected) {
                this.setBackground(UI.getHighlightColor());
                this.setForeground(Color.white);
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

