/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.components;

import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.components.WhylineControlBorder;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.font.GlyphVector;
import javax.swing.JTextField;

public class WhylineTextField
extends JTextField {
    private GlyphVector label;
    private String labelText;

    public WhylineTextField(String defaultText, int numberOfColumns, String label) {
        super(defaultText, numberOfColumns);
        this.labelText = label;
        this.setBorder(new WhylineControlBorder());
        this.setColumns(20);
        this.setFont(UI.getMediumFont());
        this.setForeground(UI.getControlTextColor());
        this.setCaretColor(UI.getControlFrontColor());
        this.setOpaque(false);
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                WhylineTextField.this.repaint();
            }

            public void focusLost(FocusEvent e) {
                WhylineTextField.this.repaint();
            }
        });
    }

    public void paintComponent(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setColor(UI.getControlBackColor());
        g.fillRoundRect(this.getInsets().left / 2 + 1, this.getInsets().top / 2 + 1, this.getWidth() - this.getInsets().right - 1, this.getHeight() - this.getInsets().top - 1, UI.getRoundedness(), UI.getRoundedness());
        super.paintComponent(g);
        if (this.label == null) {
            this.label = this.getFont().createGlyphVector(((Graphics2D)g).getFontRenderContext(), this.labelText);
        }
        g = g.create();
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setColor(UI.getControlDisabledColor());
        if (this.getText().equals("")) {
            int heightWithoutInsets = this.getHeight() - this.getInsets().top;
            int labelHeight = (int)this.label.getLogicalBounds().getHeight();
            int offset = (heightWithoutInsets - labelHeight) / 2;
            int y = this.getHeight() - this.getInsets().top - offset + 1;
            ((Graphics2D)g).drawGlyphVector(this.label, this.getInsets().left + 4, y);
        }
    }
}

