/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.components;

import edu.cmu.hcii.whyline.ui.UI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.plaf.metal.MetalScrollBarUI;
import javax.swing.plaf.metal.MetalScrollButton;

public class WhylineScrollPane
extends JScrollPane {
    public WhylineScrollPane(Component view) {
        this(view, 20, 30);
    }

    public WhylineScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
        super(view, vsbPolicy, hsbPolicy);
        this.getViewport().setBackground(null);
        this.getViewport().setOpaque(false);
        this.setBorder(null);
        this.setOpaque(true);
        this.getHorizontalScrollBar().setUI(new WhylineScrollBarUI());
        this.getVerticalScrollBar().setUI(new WhylineScrollBarUI());
        this.getHorizontalScrollBar().setBackground(UI.getControlBackColor());
        this.getVerticalScrollBar().setBackground(UI.getControlBackColor());
    }

    public Color getBackground() {
        Component view = this.getViewport().getView();
        if (view == null || !view.isBackgroundSet()) {
            return UI.getControlBackColor();
        }
        return view.getBackground();
    }

    public static class WhylineScrollBarUI
    extends MetalScrollBarUI {
        protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(UI.getControlCenterColor());
            g.fillRoundRect(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height, UI.getRoundedness(), UI.getRoundedness());
            g.setColor(UI.getControlFrontColor());
            g.drawRoundRect(trackBounds.x, trackBounds.y, trackBounds.width - 1, trackBounds.height - 1, UI.getRoundedness(), UI.getRoundedness());
        }

        protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(UI.getControlFrontColor());
            g.fillRoundRect(thumbBounds.x + 2, thumbBounds.y + 2, thumbBounds.width - 4, thumbBounds.height - 4, UI.getRoundedness(), UI.getRoundedness());
        }

        protected JButton createDecreaseButton(int orientation) {
            this.decreaseButton = new WhylineScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
            return this.decreaseButton;
        }

        protected JButton createIncreaseButton(int orientation) {
            this.increaseButton = new WhylineScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
            return this.increaseButton;
        }
    }

    public static class WhylineScrollButton
    extends MetalScrollButton {
        public WhylineScrollButton(int direction, int width, boolean freeStanding) {
            super(direction, 1, freeStanding);
            this.setVisible(false);
        }
    }
}

