/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.arrows;

import edu.cmu.hcii.whyline.qa.Explanation;
import edu.cmu.hcii.whyline.source.TokenRange;
import edu.cmu.hcii.whyline.trace.EventKind;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.arrows.CausalArrowView;
import edu.cmu.hcii.whyline.ui.qa.EventView;
import edu.cmu.hcii.whyline.ui.qa.Visualization;
import edu.cmu.hcii.whyline.util.Util;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualizationArrow
extends CausalArrowView {
    private final Visualization visualization;
    private final char shortcut;
    private GlyphVector glyphs;
    private Shape curve;
    private Shape arrowhead;
    private Rectangle2D glyphBounds;
    private int ascent;
    private int lineHeight;
    private final EventView fromView;
    private final EventView toView;
    private int fromX;
    private int fromY;
    private int toX;
    private int toY;
    private int labelX;
    private int labelY;

    public VisualizationArrow(Visualization viz, Explanation value, Explanation from, Explanation to, int dependencyNumber, CausalArrowView.Relationship relationship) {
        super(viz.getWhylineUI(), value, from, to, relationship, dependencyNumber);
        this.visualization = viz;
        this.shortcut = (char)(dependencyNumber < 1 ? 8679 : (int)Visualization.getCharacterShortcutForNumber(dependencyNumber));
        Trace trace = this.whylineUI.getTrace();
        int causeID = this.from.getEventID();
        EventKind kind = this.whylineUI.getTrace().getKind(causeID);
        this.fromView = viz.getViewOfExplanation(this.from);
        this.toView = viz.getViewOfExplanation(this.to);
    }

    @Override
    public void layout() {
        Font font = UI.getSmallFont();
        Graphics2D g = (Graphics2D)this.whylineUI.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.glyphs = font.createGlyphVector(g.getFontRenderContext(), this.label);
        FontMetrics metrics = g.getFontMetrics(font);
        this.ascent = metrics.getAscent();
        this.lineHeight = (int)((double)metrics.getHeight() * 1.25);
        this.fromX = this.fromView.getGlobalSelectionPointX();
        this.fromY = (int)this.fromView.getGlobalTop();
        if (this.fromView.isHidden() || this.fromView.ancestorIsCollapsed()) {
            this.fromX = (int)(this.fromView.getGlobalLeft() + 30.0);
            this.fromY += (int)(this.fromView.getLocalHeight() / 2.0);
        }
        this.toX = (int)this.toView.getGlobalLeft();
        this.toY = (int)(this.toView.getGlobalTop() - (double)((this.visualization.getNumberOfArrows() - this.dependencyNumber) * this.lineHeight));
        this.labelX = this.toX;
        this.labelY = this.toY - this.lineHeight / 2 + this.ascent;
        Rectangle2D glyphBoundsTemp = this.glyphs.getLogicalBounds();
        this.glyphBounds = new Rectangle2D.Double(this.labelX, this.labelY - this.ascent, glyphBoundsTemp.getWidth(), glyphBoundsTemp.getHeight());
        this.curve = Util.getCurve(this.fromX, this.fromY, this.toX, this.toY, -10, -12, true);
        this.arrowhead = Util.getArrowhead(this.fromX, this.fromY, this.toX, this.toY, -10, -12);
        Rectangle2D curveBounds = this.curve.getBounds2D();
        Rectangle2D arrowBounds = this.arrowhead.getBounds2D();
        Rectangle2D.Double bounds = new Rectangle2D.Double();
        ((Rectangle2D)bounds).setRect(curveBounds);
        bounds.add(arrowBounds);
        bounds.add(this.glyphBounds);
        this.setLocalLeft(bounds.getMinX(), false);
        this.setLocalTop(bounds.getMinY(), false);
        this.setLocalWidth(((RectangularShape)bounds).getWidth(), false);
        this.setLocalHeight(((RectangularShape)bounds).getHeight(), false);
    }

    @Override
    public boolean containsLocalPoint(int x, int y) {
        return this.curve.contains(x, y) || this.arrowhead.contains(x, y) || this.glyphBounds.contains(x, y);
    }

    @Override
    public void paintAboveChildren(Graphics2D g) {
        boolean selected;
        g = (Graphics2D)g.create();
        g.setColor(UI.getControlTextColor());
        g.drawGlyphVector(this.glyphs, this.labelX, this.labelY);
        boolean bl = selected = this.whylineUI.getArrowOver() == this.dependencyNumber;
        if (selected) {
            g.setColor(UI.getControlTextColor());
            g.drawLine(this.labelX, this.labelY + 2, (int)((double)this.labelX + this.glyphBounds.getWidth()), this.labelY + 2);
        }
        g.setColor(this.relationship.getColor(selected));
        g.setStroke(this.relationship.getStroke(selected));
        g.draw(this.curve);
        if (selected) {
            Rectangle bounds = this.arrowhead.getBounds();
            double scale = 1.5;
            int x = (int)bounds.getMinX();
            int y = (int)bounds.getCenterY();
            AffineTransform scaleT = new AffineTransform();
            scaleT.scale(scale, scale);
            scaleT.translate(-x, -y);
            Shape scaledArrowhead = scaleT.createTransformedShape(this.arrowhead);
            g.translate(x, y);
            g.fill(scaledArrowhead);
            g.translate(-x, -y);
        } else {
            g.fill(this.arrowhead);
        }
    }

    @Override
    public List<TokenRange> getViableTargetTokenRanges() {
        return Collections.emptyList();
    }
}

