/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.arrows;

import edu.cmu.hcii.whyline.qa.Explanation;
import edu.cmu.hcii.whyline.ui.arrows.CausalArrowView;
import edu.cmu.hcii.whyline.ui.arrows.FileCausalArrow;
import edu.cmu.hcii.whyline.ui.source.FilesView;
import edu.cmu.hcii.whyline.util.Util;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Line2D;

public class FileControlArrow
extends FileCausalArrow {
    public FileControlArrow(FilesView.ArrowBox arrows, Explanation from, Explanation to) {
        super(arrows, null, from, to, CausalArrowView.Relationship.CONTROL, 0);
        this.toRange = arrows.getFilesView().getRangeFor(from.getEventID());
    }

    protected void paintSelectedArrow(Graphics2D g, int labelLeft, int labelRight, int labelTop, int labelBottom) {
        Area area;
        if (this.toRange != null && this.toRange.first != null && (area = this.files.getAreaForTokenRange(this.toRange)) != null) {
            Rectangle tokens = area.getBounds();
            g.setColor(this.relationship.getColor(true));
            this.files.outline(g, this.toRange);
            int tokenLeft = (int)tokens.getMinX();
            int tokenRight = (int)tokens.getMaxX();
            int tokenTop = (int)tokens.getMinY();
            int tokenBottom = (int)tokens.getMaxY();
            int labelX = tokenRight < (labelLeft + labelRight) / 2 ? labelLeft : labelRight;
            int labelY = labelBottom - this.descent;
            Line2D line = Util.getLineBetweenRectangleEdges(labelX, labelX + 1, labelY, labelY + 1, tokenLeft, tokenRight, tokenTop, tokenBottom);
            int xOff = 0;
            int yOff = 0;
            Util.drawQuadraticCurveArrow(g, (int)line.getX1(), (int)line.getY1(), (int)line.getX2(), (int)line.getY2(), xOff, yOff, true, this.relationship.getStroke(true));
            g.drawLine(labelLeft, labelY, labelRight, labelY);
        }
    }
}

