/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui;

import edu.cmu.hcii.whyline.Whyline;
import edu.cmu.hcii.whyline.analysis.AnalysisException;
import edu.cmu.hcii.whyline.analysis.DynamicSlice;
import edu.cmu.hcii.whyline.analysis.TextSearch;
import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.io.IOEvent;
import edu.cmu.hcii.whyline.io.OutputEvent;
import edu.cmu.hcii.whyline.io.WindowState;
import edu.cmu.hcii.whyline.qa.Asker;
import edu.cmu.hcii.whyline.qa.Explanation;
import edu.cmu.hcii.whyline.qa.Question;
import edu.cmu.hcii.whyline.qa.QuestionMenu;
import edu.cmu.hcii.whyline.qa.Scope;
import edu.cmu.hcii.whyline.qa.UnexecutedInstruction;
import edu.cmu.hcii.whyline.source.FileInterface;
import edu.cmu.hcii.whyline.source.JavaSourceFile;
import edu.cmu.hcii.whyline.source.Line;
import edu.cmu.hcii.whyline.source.ParseException;
import edu.cmu.hcii.whyline.source.Token;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.trace.TraceListener;
import edu.cmu.hcii.whyline.trace.nodes.ObjectState;
import edu.cmu.hcii.whyline.ui.Actions;
import edu.cmu.hcii.whyline.ui.DebugMenu;
import edu.cmu.hcii.whyline.ui.DocumentationUI;
import edu.cmu.hcii.whyline.ui.JVMMemoryUI;
import edu.cmu.hcii.whyline.ui.LineTablesUI;
import edu.cmu.hcii.whyline.ui.ObjectsUI;
import edu.cmu.hcii.whyline.ui.OutlineUI;
import edu.cmu.hcii.whyline.ui.PersistentState;
import edu.cmu.hcii.whyline.ui.ThreadsUI;
import edu.cmu.hcii.whyline.ui.TraceExplorerUI;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.UserFocusListener;
import edu.cmu.hcii.whyline.ui.UserQuestionListener;
import edu.cmu.hcii.whyline.ui.UserTimeListener;
import edu.cmu.hcii.whyline.ui.annotations.NarrativeUI;
import edu.cmu.hcii.whyline.ui.components.MultipleSplitPane;
import edu.cmu.hcii.whyline.ui.components.WhylineButton;
import edu.cmu.hcii.whyline.ui.components.WhylineLabel;
import edu.cmu.hcii.whyline.ui.components.WhylineMultiStateButton;
import edu.cmu.hcii.whyline.ui.components.WhylinePanel;
import edu.cmu.hcii.whyline.ui.components.WhylineProgressBar;
import edu.cmu.hcii.whyline.ui.components.WhylineScrollPane;
import edu.cmu.hcii.whyline.ui.components.WhylineTabbedPane;
import edu.cmu.hcii.whyline.ui.components.WhylineToolbar;
import edu.cmu.hcii.whyline.ui.components.WhylineWindow;
import edu.cmu.hcii.whyline.ui.events.AbstractUIEvent;
import edu.cmu.hcii.whyline.ui.events.ClassNavigation;
import edu.cmu.hcii.whyline.ui.events.EventNavigation;
import edu.cmu.hcii.whyline.ui.events.ExplanationNavigation;
import edu.cmu.hcii.whyline.ui.events.FileNavigation;
import edu.cmu.hcii.whyline.ui.events.InstructionNavigation;
import edu.cmu.hcii.whyline.ui.events.LineHover;
import edu.cmu.hcii.whyline.ui.events.LineNavigation;
import edu.cmu.hcii.whyline.ui.events.MethodNavigation;
import edu.cmu.hcii.whyline.ui.events.ModeSet;
import edu.cmu.hcii.whyline.ui.events.NoLineHover;
import edu.cmu.hcii.whyline.ui.events.Note;
import edu.cmu.hcii.whyline.ui.events.QuestionSelected;
import edu.cmu.hcii.whyline.ui.events.UndoableUIEvent;
import edu.cmu.hcii.whyline.ui.events.UnexecutedInstructionNavigation;
import edu.cmu.hcii.whyline.ui.io.BreakpointConsoleUI;
import edu.cmu.hcii.whyline.ui.io.BreakpointDebugger;
import edu.cmu.hcii.whyline.ui.io.ConsoleUI;
import edu.cmu.hcii.whyline.ui.io.ExceptionsUI;
import edu.cmu.hcii.whyline.ui.io.GraphicsScaleSlider;
import edu.cmu.hcii.whyline.ui.io.GraphicsUI;
import edu.cmu.hcii.whyline.ui.io.TimeUI;
import edu.cmu.hcii.whyline.ui.launcher.LauncherUI;
import edu.cmu.hcii.whyline.ui.qa.EventView;
import edu.cmu.hcii.whyline.ui.qa.QuestionTabsUI;
import edu.cmu.hcii.whyline.ui.qa.QuestionsUI;
import edu.cmu.hcii.whyline.ui.qa.VisualizationUI;
import edu.cmu.hcii.whyline.ui.source.FilesUI;
import edu.cmu.hcii.whyline.ui.source.FilesView;
import edu.cmu.hcii.whyline.util.Feedback;
import edu.cmu.hcii.whyline.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WhylineUI
extends WhylineWindow
implements Asker {
    private static final Dimension MIN_SIZE = new Dimension(320, 240);
    private static final Dimension MAX_SIZE = Toolkit.getDefaultToolkit().getScreenSize();
    private final Trace trace;
    private final PersistentState persistentState;
    private final Mode debuggingMode;
    private final Actions actions = new Actions(this);
    private final UserListeners listeners = new UserListeners();
    private final LauncherUI launcher;
    private final ConsoleUI consoleUI;
    private final GraphicsUI graphicsUI;
    private final ExceptionsUI exceptionsUI;
    private final WhylinePanel outputUI;
    private final TimeUI timeUI;
    private final WhylineTabbedPane outputTabs;
    private QuestionsUI questionsUI;
    private final QuestionTabsUI questionTabsUI;
    private final FilesUI filesUI;
    private final LineTablesUI resultsUI;
    private final DocumentationUI documentationUI;
    private final OutlineUI outlineUI;
    private final WhylineMultiStateButton<TextSearch.Mode> whatToSearch;
    private final ThreadsUI threadsUI;
    private final ObjectsUI objectsUI;
    private BreakpointConsoleUI printsUI;
    private final WhylineToolbar toolbar;
    private final JVMMemoryUI memoryUI;
    private final NarrativeUI narrativeUI;
    private WhylineButton stepInto;
    private WhylineButton stepOver;
    private WhylineButton stepOut;
    private WhylineButton runToBreakpoint;
    private WhylineButton stop;
    private final MultipleSplitPane staticSplit;
    private final MultipleSplitPane dynamicSplit;
    private final MultipleSplitPane center;
    private final MultipleSplitPane sourceEtc;
    private final WhylinePanel main;
    private final Overlay overlay;
    private final WhylinePanel tasksPanel;
    private final GraphicsScaleSlider scaleSlider;
    private final WhylineButton backButton;
    private final WhylineButton forwardButton;
    private final WhylineButton showStaticInfo;
    private final WhylineButton showDynamicInfo;
    private final WhylineButton showJavaDoc;
    private final WhylineButton feedback;
    private boolean staticInfoShowing = false;
    private boolean dynamicInfoShowing = false;
    private int arrowNumberOver = -1;
    private Question<?> questionOver;
    private Timer saver = new Timer(true);
    private Timer taskWatcher = new Timer(true);
    private BreakpointDebugger breakpointDebugger;
    private WhylineLabel runningState;
    private DynamicSlice currentSlice = null;
    private HashMap<Object, Task> tasksOngoing = new HashMap(5);
    private HashSet<Task> tasksShowing = new HashSet(5);
    private final HashMap<String, GlyphVector> glyphCache = new HashMap(1000);
    private final Stack<UndoableUIEvent<?>> undoStack = new Stack();
    private final ArrayList<Line> navigationHistory = new ArrayList();
    private int undoStackIndex = -1;
    private Object selection;
    private int inputEventID = 0;
    private int outputEventID = 0;
    private ChangeListener popupMenuListener;
    private KeyEventPostProcessor keyEventPostProcessor;
    private int mostRecentEventIDSelected = -1;
    private Question<?> questionInProgress = null;
    private int processingNotices = 0;
    private QuestionMenu.MakerMenu recentMakerHovered = null;

    private Window getSelectedWindow(Window[] windows) {
        Window result = null;
        int i = 0;
        while (i < windows.length) {
            Window window = windows[i];
            if (window.isActive()) {
                result = window;
            } else {
                Window[] ownedWindows = window.getOwnedWindows();
                if (ownedWindows != null) {
                    result = this.getSelectedWindow(ownedWindows);
                }
            }
            ++i;
        }
        return result;
    }

    public WhylineUI(LauncherUI launcher, File path, Mode mode) throws IOException, AnalysisException, ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        this.launcher = launcher;
        this.debuggingMode = mode;
        this.trace = new Trace(new LoadingListener(), path);
        this.persistentState = new PersistentState(this);
        this.setSize(this.persistentState.getWindowWidth(), this.persistentState.getWindowHeight());
        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                WhylineUI.this.saveIfNecessaryThenClose();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                int width = Math.min(Math.max(MIN_SIZE.width, WhylineUI.this.getWidth()), MAX_SIZE.width);
                int height = Math.min(Math.max(MIN_SIZE.height, WhylineUI.this.getHeight()), MAX_SIZE.height);
                WhylineUI.this.setSize(width, height);
                WhylineUI.this.persistentState.updateWindowSize(width, height);
            }
        });
        this.feedback = new WhylineButton(new AbstractAction("send feedback"){

            public void actionPerformed(ActionEvent e) {
                WhylineUI.this.feedback();
            }
        }, UI.getSmallFont(), "Send feedback to the Whyline devs");
        this.timeUI = new TimeUI(this);
        this.filesUI = new FilesUI(this);
        this.graphicsUI = new GraphicsUI(this, false);
        this.consoleUI = new ConsoleUI(this);
        this.exceptionsUI = new ExceptionsUI(this);
        this.questionsUI = new QuestionsUI(this);
        this.objectsUI = new ObjectsUI(this);
        this.narrativeUI = new NarrativeUI(this);
        this.resultsUI = new LineTablesUI(this);
        this.whatToSearch = new WhylineMultiStateButton((Enum[])TextSearch.Mode.values());
        this.questionTabsUI = new QuestionTabsUI(this);
        this.threadsUI = new ThreadsUI(this);
        this.outlineUI = new OutlineUI(this);
        this.documentationUI = new DocumentationUI(this);
        this.memoryUI = new JVMMemoryUI();
        this.overlay = new Overlay();
        this.scaleSlider = new GraphicsScaleSlider(this);
        this.backButton = new WhylineButton(new AbstractAction(Character.toString('\u2190')){

            public void actionPerformed(ActionEvent e) {
                WhylineUI.this.back();
            }
        }, "navigate to the previously selected file, event, line, etc.");
        this.forwardButton = new WhylineButton(new AbstractAction(Character.toString('\u2192')){

            public void actionPerformed(ActionEvent e) {
                WhylineUI.this.forward();
            }
        }, "navigate forward to the next file, event, line, etc. in the navigation history");
        this.updateBackForwardButtonState();
        Dimension maxSize = new Dimension(60, 25);
        this.showStaticInfo = new WhylineButton(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                WhylineUI.this.showStaticInfo(!WhylineUI.this.staticInfoShowing);
            }
        }, UI.getSmallFont(), "show information about source files");
        this.showStaticInfo.setEnabled(true);
        this.showDynamicInfo = new WhylineButton(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                WhylineUI.this.showDynamicInfo(!WhylineUI.this.dynamicInfoShowing);
            }
        }, UI.getSmallFont(), "show information about call stacks, local variables, and object state");
        this.showDynamicInfo.setEnabled(false);
        this.showJavaDoc = new WhylineButton(new AbstractAction("<html><center>show<br><i>javadoc"){

            public void actionPerformed(ActionEvent e) {
                WhylineUI.this.showJavaDoc(WhylineUI.this.getSelectedMethod());
            }
        }, maxSize, UI.getSmallFont(), "show javadocs for the currently selected method");
        this.listeners.addFocusListener(this.questionsUI);
        this.listeners.addFocusListener(this.filesUI.getFilesView());
        this.listeners.addFocusListener(this.timeUI);
        this.listeners.addQuestionListener(this.timeUI);
        this.listeners.addTimeListener(this.timeUI);
        this.listeners.addTimeListener(this.graphicsUI);
        WhylinePanel graphicsUIWithSlider = new WhylinePanel(new BorderLayout(UI.getPanelPadding(), UI.getPanelPadding()));
        graphicsUIWithSlider.add((Component)this.graphicsUI, "Center");
        graphicsUIWithSlider.add((Component)this.scaleSlider, "South");
        this.outputTabs = new WhylineTabbedPane();
        this.outputTabs.addTab("graphics", graphicsUIWithSlider);
        this.outputTabs.addTab("text", this.consoleUI);
        this.outputTabs.addTab("exceptions", this.exceptionsUI);
        this.outputUI = new WhylinePanel(new BorderLayout(0, UI.getPanelPadding()));
        this.outputUI.add((Component)this.outputTabs, "Center");
        this.outputUI.add((Component)this.timeUI, "South");
        this.outputUI.setMinimumSize(new Dimension(UI.getDefaultInfoPaneWidth(this), 0));
        Dimension infoBoxDimension = new Dimension(UI.getDefaultInfoPaneWidth(this), 0);
        this.staticSplit = new MultipleSplitPane(0, this.outlineUI, this.resultsUI);
        this.staticSplit.setMinimumSize(new Dimension(50, 0));
        this.staticSplit.setPreferredSize(infoBoxDimension);
        this.dynamicSplit = new MultipleSplitPane(0, this.outputUI, this.objectsUI, this.threadsUI);
        this.dynamicSplit.setMinimumSize(new Dimension(50, 0));
        this.dynamicSplit.setPreferredSize(infoBoxDimension);
        this.toolbar = new WhylineToolbar(0);
        this.toolbar.setBorder(new EmptyBorder(UI.getPanelPadding(), UI.getPanelPadding(), UI.getPanelPadding(), UI.getPanelPadding()));
        this.toolbar.setMinimumSize(new Dimension(0, UI.getToolbarHeight()));
        this.toolbar.setOpaque(true);
        this.toolbar.setBackground(UI.getPanelDarkColor());
        this.toolbar.add(new DebugMenu(this));
        this.toolbar.addSeparator();
        this.toolbar.add(this.backButton);
        this.toolbar.addSeparator();
        this.toolbar.add(this.forwardButton);
        if (this.isWhyline()) {
            this.toolbar.addSeparator();
            this.toolbar.add(this.showStaticInfo);
            this.toolbar.add(this.showDynamicInfo);
        }
        this.toolbar.add(this.feedback);
        this.sourceEtc = new MultipleSplitPane(0, this.filesUI, new JComponent[0]);
        this.sourceEtc.add((Component)this.filesUI, "Center");
        if (this.debuggingMode == Mode.WHYLINE) {
            this.center = new MultipleSplitPane(1, this.staticSplit, this.sourceEtc, this.dynamicSplit);
            this.listeners.addTimeListener(this.consoleUI);
            this.popupMenuListener = new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    WhylineUI.this.handlePopupMenuChange(e);
                }
            };
            MenuSelectionManager.defaultManager().addChangeListener(this.popupMenuListener);
        } else if (this.debuggingMode == Mode.SLICER) {
            this.center = new MultipleSplitPane(1, this.staticSplit, this.sourceEtc);
            this.listeners.addTimeListener(this.consoleUI);
            this.listeners.addTimeListener(this.graphicsUI);
        } else {
            this.center = new MultipleSplitPane(1, this.staticSplit, this.sourceEtc, this.dynamicSplit);
            this.printsUI = new BreakpointConsoleUI(this);
            this.listeners.addTimeListener(this.consoleUI);
            this.listeners.addTimeListener(this.graphicsUI);
            this.listeners.addTimeListener(this.printsUI);
            this.breakpointDebugger = new BreakpointDebugger(this);
            this.stepOver = new WhylineButton(this.actions.stepOver, "step over calls on this line");
            this.stepOver.setIcon(UI.STEP_OVER);
            this.stepOver.setText(null);
            this.stepOver.setFocusable(false);
            this.stepInto = new WhylineButton(this.actions.stepInto, "step into the next call on this line");
            this.stepInto.setIcon(UI.STEP_INTO);
            this.stepInto.setText(null);
            this.stepInto.setFocusable(false);
            this.stepOut = new WhylineButton(this.actions.stepOut, "step out of the current call");
            this.stepOut.setIcon(UI.STEP_OUT);
            this.stepOut.setText(null);
            this.stepOut.setFocusable(false);
            this.runToBreakpoint = new WhylineButton(this.actions.runToBreakpoint, "run the program until reaching the next breakpoint");
            this.runToBreakpoint.setIcon(UI.RESUME);
            this.runToBreakpoint.setText(null);
            this.runToBreakpoint.setFocusable(false);
            this.stop = new WhylineButton(this.actions.stop, "stop the program");
            this.stop.setIcon(UI.STOP);
            this.stop.setText(null);
            this.stop.setFocusable(false);
            this.runningState = new WhylineLabel("stopped", UI.getSmallFont());
            this.runningState.setOpaque(true);
            this.runningState.setBorder(new EmptyBorder(3, 3, 3, 3){

                public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                    g.setColor(UI.getControlBorderColor());
                    g.drawRect(x, y, width - 1, height - 1);
                }
            });
            this.breakpointDebugger.stop();
            this.toolbar.addSeparator();
            this.toolbar.add(new WhylineLabel("stepping", UI.getLargeFont()));
            this.toolbar.addSeparator();
            this.toolbar.add(this.runToBreakpoint);
            this.toolbar.add(this.stepInto);
            this.toolbar.add(this.stepOver);
            this.toolbar.add(this.stepOut);
            this.toolbar.add(this.stop);
            this.toolbar.addSeparator();
            this.toolbar.add(this.runningState);
            this.outputTabs.addTab("prints", this.printsUI);
            this.staticInfoShowing = true;
            this.dynamicInfoShowing = true;
        }
        this.tasksPanel = new WhylinePanel();
        this.tasksPanel.setLayout(new BoxLayout(this.tasksPanel, 0));
        this.toolbar.addSeparator();
        this.toolbar.add(this.tasksPanel);
        this.center.giveResizeWeightTo(this.sourceEtc);
        this.center.setBorder(new EmptyBorder(UI.getPanelPadding(), UI.getPanelPadding(), UI.getPanelPadding(), UI.getPanelPadding()));
        this.main = new WhylinePanel(new BorderLayout());
        this.main.add((Component)this.center, "Center");
        if (mode == Mode.WHYLINE) {
            WhylinePanel toolbars = new WhylinePanel(new BorderLayout());
            toolbars.add((Component)this.questionTabsUI, "North");
            toolbars.add((Component)this.toolbar, "South");
            this.main.add((Component)toolbars, "South");
        } else {
            this.main.add((Component)this.toolbar, "South");
        }
        this.getContentPane().setLayout(new OverlayLayout(this.getContentPane()));
        this.getContentPane().add(this.overlay);
        this.getContentPane().add(this.main);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((int)(screenSize.getWidth() - (double)this.getWidth()) / 2, (int)(screenSize.getHeight() - (double)this.getHeight()) / 2);
        this.setVisible(true);
        this.toFront();
        this.requestFocus();
        this.arrangeForPlayback();
        this.log(new Note(Util.getDateString()));
        this.log(new ModeSet(mode));
        this.log(new Note("Loading trace..."));
        this.addTask(this.trace, "Loading trace");
        this.trace.load(100);
        this.keyEventPostProcessor = new KeyEventPostProcessor(){

            public boolean postProcessKeyEvent(KeyEvent e) {
                boolean inField = e.getComponent() instanceof JTextField;
                if (e.getID() == 401) {
                    boolean forward;
                    if (e.getKeyCode() == 112) {
                        UI.setCreamColors();
                        WhylineUI.this.repaint();
                    }
                    boolean back = e.getKeyCode() == 91;
                    boolean bl = forward = e.getKeyCode() == 93;
                    if (back || forward) {
                        boolean success;
                        if (inField) {
                            int position = ((JTextField)e.getComponent()).getCaretPosition();
                            if (position > 0) {
                                return true;
                            }
                            VisualizationUI viz = WhylineUI.this.getVisualizationUIVisible();
                            if (viz != null) {
                                viz.requestFocusInWindow();
                            }
                            return true;
                        }
                        boolean bl2 = success = back ? WhylineUI.this.back() : WhylineUI.this.forward();
                        if (!success) {
                            Toolkit.getDefaultToolkit().beep();
                        }
                        return true;
                    }
                    if (inField) {
                        return true;
                    }
                    switch (e.getKeyCode()) {
                        case 68: {
                            WhylineUI.this.showJavaDoc(WhylineUI.this.getSelectedMethod());
                        }
                    }
                }
                return true;
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(this.keyEventPostProcessor);
        this.taskWatcher.scheduleAtFixedRate(new TimerTask(){

            public void run() {
                WhylineUI.this.updateTasks();
            }
        }, 1000L, 500L);
        if (this.isWhyline()) {
            this.showStaticInfo(false);
            this.showDynamicInfo(false);
        }
    }

    private void feedback() {
        int choice;
        String result = JOptionPane.showInputDialog(this, (Object)"<html>What would you like to tell the Whyline developers?<br>This will just send an e-mail containing the text you type here.");
        if (result != null && (choice = JOptionPane.showConfirmDialog(this, "<html>Is it okay to send <b>a screenshot of this window</b>?", "Screenshot?", 1)) != 2) {
            try {
                Feedback.feedback(result, choice == 0 ? this : null);
                JOptionPane.showMessageDialog(this, "<html>Feedback sent successfully!");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this, "<html>Couldn't send the feedback. There was some sort of exception:<br><br>" + ex.getMessage());
            }
        }
    }

    public void setBreakpointDebuggerState(String label, boolean isRunning) {
        this.runningState.setBackground(isRunning ? UI.getRunningColor() : UI.getStoppedColor());
        this.runningState.setText(label);
        this.runningState.repaint();
    }

    public void showMemoryUsage() {
        if (this.memoryUI.getParent() == null) {
            this.toolbar.add(this.memoryUI);
            this.toolbar.addSeparator();
            this.toolbar.revalidate();
        }
    }

    public List<Line> getNavigationHistory() {
        return this.navigationHistory;
    }

    public void showTraceBreakdown() {
        WhylineWindow window = new WhylineWindow();
        window.getContentPane().add(new WhylineScrollPane(new TraceExplorerUI(this.trace)));
        window.setSize(320, 240);
        window.setVisible(true);
    }

    public GlyphVector getTokenGlyphs(Token token) {
        GlyphVector glyphs = this.glyphCache.get(token.getText());
        if (glyphs == null) {
            Graphics2D g2d = (Graphics2D)this.getGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            FontRenderContext context = g2d.getFontRenderContext();
            Font font = UI.getFixedFont();
            String text = token.getText();
            text = text.replace("\t", "    ");
            glyphs = font.createGlyphVector(context, text);
            if (!token.isComment()) {
                this.glyphCache.put(token.getText(), glyphs);
            }
        }
        return glyphs;
    }

    public boolean isGraphicsFitToWindow() {
        return this.scaleSlider.isFitToWindow();
    }

    public void setGraphicsScale(int percent) {
        this.scaleSlider.setValue(percent);
    }

    public int getGraphicsScale() {
        return this.scaleSlider.getValue();
    }

    public OutlineUI getOutlineUI() {
        return this.outlineUI;
    }

    public QuestionsUI getQuestionsUI() {
        return this.questionsUI;
    }

    public FilesView getFilesView() {
        return this.filesUI.getFilesView();
    }

    public TimeUI getTimeControllerUI() {
        return this.timeUI;
    }

    public NarrativeUI getNarrativeUI() {
        return this.narrativeUI;
    }

    public GraphicsUI getGraphicsUI() {
        return this.graphicsUI;
    }

    public ObjectsUI getObjectsUI() {
        return this.objectsUI;
    }

    public Actions getActions() {
        return this.actions;
    }

    public LineTablesUI getLinesUI() {
        return this.resultsUI;
    }

    public VisualizationUI getVisualizationUIVisible() {
        if (this.questionsUI == null || this.questionsUI.getAnswerUIVisible() == null || this.questionsUI.getAnswerUIVisible().getSituationSelected() == null) {
            return null;
        }
        return this.questionsUI.getAnswerUIVisible().getSituationSelected().getVisualizationUI();
    }

    public int getOutputEventID() {
        return this.outputEventID;
    }

    public int getInputEventID() {
        return this.inputEventID;
    }

    public int getCurrentEventID() {
        VisualizationUI viz = this.getVisualizationUIVisible();
        if (viz == null) {
            return this.getInputEventID();
        }
        EventView selection = viz.getVisualization().getSelectedEventView();
        if (selection == null) {
            return this.getInputEventID();
        }
        return selection.getEventID();
    }

    public IOEvent getEventAtInputTime() {
        return this.trace.getIOHistory().getEventAtTime(this.inputEventID);
    }

    public IOEvent getEventAtOutputTime() {
        return this.trace.getIOHistory().getEventAtTime(this.outputEventID);
    }

    public BreakpointDebugger getBreakpointDebugger() {
        return this.breakpointDebugger;
    }

    public void setBreakpointPauseMode(boolean inPauseMode) {
        this.runToBreakpoint.setIcon(inPauseMode ? UI.PAUSE : UI.RESUME);
        this.runToBreakpoint.revalidate();
    }

    @Override
    public Dimension getMinimumSize() {
        return MIN_SIZE;
    }

    @Override
    public Trace getTrace() {
        return this.trace;
    }

    private void updateBackForwardButtonState() {
        this.forwardButton.setEnabled(this.undoStackIndex < this.undoStack.size() - 1);
        this.backButton.setEnabled(this.undoStackIndex > 0);
    }

    public boolean back() {
        if (this.undoStack.isEmpty()) {
            return false;
        }
        boolean last = false;
        if (this.undoStackIndex > 0) {
            --this.undoStackIndex;
        }
        UndoableUIEvent selection = (UndoableUIEvent)this.undoStack.get(this.undoStackIndex);
        selection.select(this);
        this.updateBackForwardButtonState();
        return !last;
    }

    public boolean forward() {
        if (this.undoStackIndex < this.undoStack.size() - 1) {
            ++this.undoStackIndex;
            UndoableUIEvent selection = (UndoableUIEvent)this.undoStack.get(this.undoStackIndex);
            selection.select(this);
            this.updateBackForwardButtonState();
            return true;
        }
        return false;
    }

    public void log(AbstractUIEvent<?> event) {
        if (event instanceof UndoableUIEvent && event.wasUserInitiated()) {
            while (this.undoStack.size() > this.undoStackIndex + 1) {
                this.undoStack.pop();
            }
            this.undoStack.push((UndoableUIEvent)event);
            ++this.undoStackIndex;
            this.updateBackForwardButtonState();
            try {
                Line line = ((UndoableUIEvent)event).getCorrespondingLine(this.trace);
                if (line != null) {
                    this.navigationHistory.add(0, line);
                    this.resultsUI.updateHistory(line);
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        this.persistentState.addNavigation(event);
    }

    public void addTask(Object key, String description) {
        Task task = new Task(this, description);
        this.tasksOngoing.put(key, task);
    }

    private void updateTasks() {
        for (Task task : this.tasksOngoing.values()) {
            if (this.tasksShowing.contains(task) || task.getMillisecondsSinceCreation() < 500L) continue;
            this.tasksShowing.add(task);
            this.tasksPanel.add(task);
            this.tasksPanel.validate();
            this.tasksPanel.invalidate();
            this.tasksPanel.repaint();
        }
    }

    public void updateTask(Object key, String message, double progress) {
        Task task = this.tasksOngoing.get(key);
        if (task != null) {
            if (message != null) {
                task.setNote(message);
            }
            if (progress >= 0.0) {
                task.setProgress(progress);
            }
            this.repaint();
        }
    }

    public void removeTask(Object key) {
        Task task = this.tasksOngoing.get(key);
        this.tasksOngoing.remove(key);
        if (task != null) {
            this.tasksShowing.remove(task);
            this.tasksPanel.remove(task);
            this.tasksPanel.revalidate();
        }
    }

    public void showStaticInfo(boolean yes) {
        this.staticInfoShowing = yes;
        this.showStaticInfo.setText(String.valueOf(this.staticInfoShowing ? "hide" : "show") + " code info");
        if (this.trace.isDoneLoading()) {
            if (this.getQuestionVisible() == null) {
                this.arrangeForAsking();
            } else {
                this.arrangeForInspecting();
            }
        }
    }

    public void showDynamicInfo(boolean yes) {
        this.dynamicInfoShowing = yes;
        this.showDynamicInfo.setText(String.valueOf(this.dynamicInfoShowing ? "hide" : "show") + " execution info");
        if (this.trace.isDoneLoading()) {
            this.arrangeForInspecting();
        }
    }

    public boolean isDynamicInfoShowing() {
        return this.dynamicInfoShowing;
    }

    public boolean isStaticInfoShowing() {
        return this.staticInfoShowing;
    }

    public TextSearch.Mode getSearchMode() {
        return TextSearch.Mode.valueOf(this.whatToSearch.getState().name());
    }

    public WhylineMultiStateButton<?> getSearchModeButton() {
        return this.whatToSearch;
    }

    public PersistentState getPersistentState() {
        return this.persistentState;
    }

    public void save(final boolean closeAfterwards) {
        String message = "What would you like to call it?";
        String desiredName = null;
        while (desiredName == null) {
            desiredName = JOptionPane.showInputDialog(this, (Object)message);
            File folder = this.trace.getSaveLocation(desiredName);
            if (!folder.exists()) continue;
            message = "<html>A trace named <b>" + desiredName + "</b> already exists.<br>What would you like to call it instead?";
            desiredName = null;
        }
        final String name = desiredName;
        if (name != null) {
            this.addTask(this.trace, "Saving");
            this.updateTask(this.trace, "Saving...", 0.0);
            Thread save = new Thread(){

                public void run() {
                    try {
                        boolean success = WhylineUI.this.trace.save(name, new Util.ProgressListener(){

                            public void progress(double percent) {
                                WhylineUI.this.updateTask(WhylineUI.this.trace, null, percent);
                            }

                            public void notice(String notice) {
                                WhylineUI.this.updateTask(WhylineUI.this.trace, notice, -1.0);
                            }
                        });
                        if (!success) {
                            JOptionPane.showMessageDialog(WhylineUI.this, "Failed to save because the folder already exists.", "Couldn't save", 0);
                        }
                        if (closeAfterwards) {
                            WhylineUI.this.close();
                        }
                    }
                    catch (IOException e1) {
                        JOptionPane.showMessageDialog(WhylineUI.this, "Couldn't save the trace: " + e1.getMessage());
                    }
                    WhylineUI.this.removeTask(WhylineUI.this.trace);
                }
            };
            save.start();
        }
    }

    public boolean saveIfNecessaryThenClose() {
        if (!this.trace.isSaved()) {
            Object[] options = new String[]{"Yes, save!", "No, just close the window", "Don't close this window"};
            int answer = JOptionPane.showOptionDialog(this, "Do you want me to save this trace to the whyline's workspace for later?", "Save this trace?", 1, 3, null, options, "No");
            if (answer == 2) {
                return true;
            }
            if (answer == 0) {
                this.save(true);
                return false;
            }
        }
        this.close();
        return false;
    }

    private void close() {
        this.trace.cancelLoading();
        this.saver.cancel();
        this.taskWatcher.cancel();
        this.saver = null;
        try {
            this.persistentState.write();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        MenuSelectionManager.defaultManager().removeChangeListener(this.popupMenuListener);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(this.keyEventPostProcessor);
        this.graphicsUI.freeGlobalListeners();
        this.memoryUI.dispose();
        this.setVisible(false);
        this.dispose();
        if (this.launcher != null) {
            this.launcher.close(this);
        }
    }

    public void arrangeForPlayback() {
        this.center.resetWith(this.outputUI, new JComponent[0]);
        this.center.revalidate();
    }

    public void arrangeForAsking() {
        this.showDynamicInfo.setEnabled(false);
        if (this.debuggingMode == Mode.WHYLINE) {
            this.scaleSlider.setFitToWindow(false);
            if (this.staticInfoShowing) {
                this.center.resetWith(this.staticSplit, this.outputUI);
            } else {
                this.center.resetWith(this.outputUI, new JComponent[0]);
            }
            this.center.giveResizeWeightTo(this.outputUI);
            this.sourceEtc.resetWith(this.filesUI, new JComponent[0]);
            this.timeUI.setRequestFocusOnEnter(true);
            this.timeUI.requestFocusInWindow();
        } else if (this.debuggingMode == Mode.SLICER) {
            this.dynamicSplit.resetWith(this.outputUI, this.objectsUI, this.threadsUI);
            this.center.resetWith(this.staticSplit, this.sourceEtc);
            this.center.giveResizeWeightTo(this.sourceEtc);
        } else if (this.debuggingMode == Mode.BREAKPOINT) {
            this.scaleSlider.setFitToWindow(false);
            this.dynamicSplit.resetWith(this.outputUI, this.objectsUI, this.threadsUI);
            this.center.resetWith(this.staticSplit, this.sourceEtc, this.dynamicSplit);
            this.center.giveResizeWeightTo(this.sourceEtc);
        }
        this.center.revalidate();
        this.repaint();
    }

    private void arrangeForInspecting() {
        assert (this.debuggingMode == Mode.WHYLINE) : "Can only arrange for inspecting " + (Object)((Object)Mode.WHYLINE) + " mode";
        this.showDynamicInfo.setEnabled(true);
        this.scaleSlider.setFitToWindow(true);
        this.dynamicSplit.resetWith(this.outputUI, this.objectsUI, this.threadsUI);
        this.sourceEtc.setMinimumSize(new Dimension(UI.getDefaultInfoPaneWidth(this), 0));
        this.sourceEtc.resetWith(this.filesUI, this.questionsUI);
        this.sourceEtc.giveResizeWeightTo(this.filesUI);
        if (this.staticInfoShowing && this.dynamicInfoShowing) {
            this.center.resetWith(this.staticSplit, this.sourceEtc, this.dynamicSplit);
        } else if (this.staticInfoShowing) {
            this.center.resetWith(this.staticSplit, this.sourceEtc);
        } else if (this.dynamicInfoShowing) {
            this.center.resetWith(this.sourceEtc, this.dynamicSplit);
        } else {
            this.center.resetWith(this.sourceEtc, new JComponent[0]);
        }
        this.center.giveResizeWeightTo(this.sourceEtc);
        this.timeUI.setRequestFocusOnEnter(false);
        this.center.revalidate();
    }

    public void addDynamicSlice(Line line, boolean onlyMostRecent) {
        assert (this.debuggingMode == Mode.SLICER) : "Can only add slices in dynamic slice mode. Currently in " + (Object)((Object)this.debuggingMode) + " mode";
        this.clearDynamicSlice();
        this.currentSlice = new DynamicSlice(this, line, onlyMostRecent);
        this.resultsUI.addResults(this.currentSlice);
        this.validate();
        this.repaint();
    }

    public void clearDynamicSlice() {
        assert (this.debuggingMode == Mode.SLICER) : "Can only clear slices in dynamic slice mode.";
        this.filesUI.getFilesView().removeWindowsArrowsAndHighlights();
        this.validate();
        this.repaint();
    }

    @Override
    public void answer(final Question<?> question) {
        if (this.questionInProgress != null) {
            JOptionPane.showMessageDialog(this, "Already answering a question. Wait until its finished to ask another!");
            return;
        }
        this.questionInProgress = question;
        this.addTask(this.questionInProgress, "Answering question");
        this.setQuestion(question);
        this.updateAnsweringStatus(this.questionInProgress, "Answering question...", 0.0);
        Thread answeringThread = new Thread("asker"){

            public void run() {
                question.computeAnswer();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        WhylineUI.this.updateTask(WhylineUI.this.questionInProgress, "Done answering.", 0.0);
                        WhylineUI.this.updateTask(question, "Showing answer....", 0.0);
                        WhylineUI.this.questionsUI.getAnswerUIVisible().showSituation(question.getAnswer());
                        WhylineUI.this.removeTask(WhylineUI.this.questionInProgress);
                        WhylineUI.this.questionInProgress = null;
                    }
                });
            }
        };
        answeringThread.start();
    }

    @Override
    public void problemAnswering(Question<?> question, AnalysisException e) {
        JOptionPane.showMessageDialog(this, "There was an error determine the answer. See the console for the error.");
        e.printStackTrace();
        this.removeTask(question);
        this.questionInProgress = null;
    }

    @Override
    public void updateAnsweringStatus(Question<?> question, String status, double percentComplete) {
        this.updateTask(question, status, percentComplete);
    }

    @Override
    public void doneAnswering() {
    }

    @Override
    public void processing(boolean isProcessing) {
        boolean wasWaiting;
        boolean bl = wasWaiting = this.processingNotices > 0;
        this.processingNotices = isProcessing ? ++this.processingNotices : --this.processingNotices;
        if (this.processingNotices > 0 != wasWaiting) {
            boolean done = this.processingNotices == 0;
            Cursor wait = Cursor.getPredefinedCursor(3);
            Cursor normal = Cursor.getPredefinedCursor(0);
            Cursor hand = Cursor.getPredefinedCursor(12);
            this.main.setCursor(done ? normal : wait);
            this.graphicsUI.setCursor(done ? hand : wait);
        }
    }

    public boolean userIsAskingQuestion() {
        return MenuSelectionManager.defaultManager().getSelectedPath().length > 0;
    }

    public void setQuestion(Question<?> question) {
        this.log(new QuestionSelected(question, true));
        this.questionsUI.setQuestion(question);
        this.questionTabsUI.addQuestion(question);
        for (UserQuestionListener listener : this.listeners.getQuestionListeners()) {
            listener.questionChanged(question);
        }
        if (question == null) {
            this.arrangeForAsking();
        } else {
            this.arrangeForInspecting();
        }
    }

    public void removeQuestion(Question<?> question) {
        this.questionsUI.removeQuestion(question);
        this.questionTabsUI.removeQuestion(question);
    }

    public boolean isQuestionVisible() {
        return this.getQuestionVisible() != null;
    }

    public Question<?> getQuestionVisible() {
        return this.questionsUI == null ? null : this.questionsUI.getQuestionVisible();
    }

    public int getMostRecentEventIDSelected() {
        return this.mostRecentEventIDSelected;
    }

    public void setArrowOver(int number) {
        if (this.arrowNumberOver == number) {
            return;
        }
        this.arrowNumberOver = number;
        this.filesUI.handleArrowOverChanged();
        this.questionsUI.handleArrowOverChanged();
    }

    public int getArrowOver() {
        return this.arrowNumberOver;
    }

    public Question<?> getQuestionOver() {
        return this.questionOver;
    }

    public void showJavaDoc(MethodInfo method) {
        String url = method.getJavaDocURL();
        url = String.valueOf(Whyline.getJDKJavaDocPath()) + url;
        Util.openURL(url);
    }

    public MethodInfo getSelectedMethod() {
        Instruction instruction;
        if (this.selection instanceof MethodInfo) {
            return (MethodInfo)this.selection;
        }
        Instruction instruction2 = this.selection instanceof Integer ? this.trace.getInstruction((Integer)this.selection) : (instruction = this.selection instanceof Explanation ? this.trace.getInstruction(((Explanation)this.selection).getEventID()) : null);
        if (instruction == null) {
            return null;
        }
        return instruction.getMethod();
    }

    public int getSelectedEventID() {
        if (this.selection instanceof Integer) {
            return (Integer)this.selection;
        }
        if (this.selection instanceof Explanation) {
            return ((Explanation)this.selection).getEventID();
        }
        return -1;
    }

    private void handleNewSelection(Object newSelection) {
        this.selection = newSelection;
        this.showJavaDoc.setEnabled(this.getSelectedMethod() != null);
    }

    public void selectLine(Line line, boolean isNavigation, String ui) {
        this.log(new LineNavigation(line, ui, isNavigation));
        this.handleNewSelection(line);
        this.getFilesView().showLine(line);
    }

    public void selectEvent(int eventID, boolean isNavigation, String ui) {
        if (eventID >= 0) {
            this.log(new EventNavigation(eventID, ui, isNavigation));
        }
        this.handleNewSelection(eventID);
        this.handleEventIDSelection(eventID, ui);
        for (UserFocusListener l : this.listeners.getFocusListeners()) {
            l.showEvent(eventID);
        }
    }

    public void selectExplanation(Explanation subject, boolean userInitiated, String ui) {
        if (this.selection == subject) {
            return;
        }
        this.handleNewSelection(subject);
        this.log(new ExplanationNavigation(subject, ui, userInitiated));
        for (UserFocusListener l : this.listeners.getFocusListeners()) {
            l.showExplanation(subject);
        }
        this.handleEventIDSelection(subject.getEventID(), ui);
    }

    private void handleEventIDSelection(int eventID, String ui) {
        Instruction instruction = this.trace.getInstruction(eventID);
        boolean newID = eventID != this.mostRecentEventIDSelected;
        this.mostRecentEventIDSelected = eventID;
        this.objectsUI.showEventID(eventID);
        this.threadsUI.showEventID(eventID);
        this.documentationUI.showInstruction(instruction);
        if (newID) {
            Line line;
            Line line2 = line = instruction == null ? null : instruction.getLine();
            if (line == null) {
                this.log(new NoLineHover(ui));
            } else {
                this.log(new LineHover(line, ui));
            }
        }
    }

    public void selectInstruction(Instruction subject, boolean isNavigation, String ui) {
        if (this.selection == subject) {
            return;
        }
        this.handleNewSelection(subject);
        this.log(new InstructionNavigation(subject, ui, isNavigation));
        for (UserFocusListener l : this.listeners.getFocusListeners()) {
            l.showInstruction(subject);
        }
        this.documentationUI.showInstruction(subject);
    }

    public UndoableUIEvent<UnexecutedInstruction> selectUnexecutedInstruction(UnexecutedInstruction subject, boolean isNavigation, String ui) {
        if (this.selection == subject) {
            return null;
        }
        this.handleNewSelection(subject);
        for (UserFocusListener l : this.listeners.getFocusListeners()) {
            l.showUnexecutedInstruction(subject);
        }
        this.log(new UnexecutedInstructionNavigation(subject, ui, isNavigation));
        this.documentationUI.showInstruction(subject.getInstruction());
        return null;
    }

    public void selectInstructions(Iterable<Instruction> subject) {
        if (this.selection == subject) {
            return;
        }
        this.handleNewSelection(subject);
        for (UserFocusListener l : this.listeners.getFocusListeners()) {
            l.showInstructions(subject);
        }
    }

    public UndoableUIEvent<MethodInfo> selectMethod(MethodInfo subject, boolean isNavigation, String ui) {
        if (this.selection == subject) {
            return null;
        }
        this.handleNewSelection(subject);
        for (UserFocusListener l : this.listeners.getFocusListeners()) {
            l.showMethod(subject);
        }
        this.documentationUI.showMethod(subject);
        this.log(new MethodNavigation(subject, ui, isNavigation));
        return null;
    }

    public UndoableUIEvent<Classfile> selectClass(Classfile subject, boolean userInitiated, String ui) {
        if (this.selection == subject) {
            return null;
        }
        this.handleNewSelection(subject);
        for (UserFocusListener l : this.listeners.getFocusListeners()) {
            l.showClass(subject);
        }
        this.documentationUI.showClass(subject);
        this.log(new ClassNavigation(subject, ui, userInitiated));
        return null;
    }

    public UndoableUIEvent<FileInterface> selectFile(FileInterface subject, boolean isNavigation, String ui) {
        if (this.selection == subject) {
            return null;
        }
        if (subject == null) {
            return null;
        }
        this.handleNewSelection(subject);
        for (UserFocusListener l : this.listeners.getFocusListeners()) {
            l.showFile(subject);
        }
        this.log(new FileNavigation(subject, ui, isNavigation));
        return null;
    }

    private int boundTime(int time) {
        return Math.min(Math.max(0, time), this.trace.getNumberOfEvents() - 1);
    }

    public void setInputTime(int newTime) {
        if ((newTime = this.boundTime(newTime)) == this.inputEventID) {
            return;
        }
        this.inputEventID = newTime;
        if (this.inputEventID > this.outputEventID) {
            this.setOutputTime(this.inputEventID);
        }
        for (UserTimeListener l : this.listeners.getTimeListeners()) {
            l.inputTimeChanged(this.inputEventID);
        }
    }

    public void setOutputTime(int newTime) {
        this.outputEventID = newTime = this.boundTime(newTime);
        if (this.outputEventID < this.inputEventID) {
            this.setInputTime(this.outputEventID);
        }
        for (UserTimeListener l : this.listeners.getTimeListeners()) {
            l.outputTimeChanged(this.outputEventID);
        }
    }

    @Override
    public Scope getCurrentScope() {
        return new Scope(this.trace, this.inputEventID, this.outputEventID);
    }

    public Mode getMode() {
        return this.debuggingMode;
    }

    public boolean canAskOutputQuestions() {
        return this.debuggingMode == Mode.WHYLINE;
    }

    public boolean canAskCodeQuestions() {
        return this.debuggingMode == Mode.WHYLINE;
    }

    public boolean isWhyline() {
        return this.debuggingMode == Mode.WHYLINE;
    }

    private void handlePopupMenuChange(ChangeEvent e) {
        if (!this.isActive()) {
            return;
        }
        MenuSelectionManager msm = (MenuSelectionManager)e.getSource();
        MenuElement[] path = msm.getSelectedPath();
        this.questionOver = null;
        this.overlay.setIntercepting(path.length > 0);
        if (path.length > 0) {
            MenuElement selection = path[path.length - 1];
            Object subject = null;
            if (selection instanceof JPopupMenu && path.length - 2 >= 0) {
                selection = path[path.length - 2];
            }
            if (selection instanceof QuestionMenu.Menu) {
                subject = ((QuestionMenu.Menu)selection).getSubject();
                ((QuestionMenu.Menu)selection).addItemsIfNecessary(true);
                if (selection instanceof QuestionMenu.MakerMenu) {
                    if (this.recentMakerHovered != null) {
                        this.recentMakerHovered.cancel();
                    }
                    this.recentMakerHovered = (QuestionMenu.MakerMenu)selection;
                }
            } else if (selection instanceof QuestionMenu.MessageItem) {
                if (((QuestionMenu.MessageItem)selection).getParentMenu() != null) {
                    ((QuestionMenu.MessageItem)selection).getParentMenu().addItemsIfNecessary(true);
                }
            } else if (selection instanceof QuestionMenu.QuestionItem) {
                subject = ((QuestionMenu.QuestionItem)selection).getSubject();
                this.questionOver = ((QuestionMenu.QuestionItem)selection).getQuestion();
            }
            if (subject instanceof ObjectState) {
                this.objectsUI.addObject(((ObjectState)subject).getObjectID());
                QualifiedClassName classname = this.getTrace().getClassnameOfObjectID(((ObjectState)subject).getObjectID());
                Classfile classfile = this.getTrace().getClassfileByName(classname);
                FileInterface fileToShow = null;
                if (classfile != null) {
                    fileToShow = classfile.getSourceFile() != null ? classfile.getSourceFile() : classfile;
                    this.selectFile(fileToShow, false, "question");
                }
            } else if (subject instanceof OutputEvent) {
                Instruction instruction = this.trace.getInstruction(((OutputEvent)subject).getEventID());
                this.selectInstruction(instruction, false, "question");
            } else if (subject instanceof Integer) {
                this.selectInstruction(this.trace.getInstruction((Integer)subject), false, "question");
            } else if (subject instanceof Instruction) {
                this.selectInstruction((Instruction)subject, false, "question");
            } else if (subject instanceof MethodInfo) {
                this.selectMethod((MethodInfo)subject, false, "question");
            } else if (subject instanceof Classfile) {
                this.selectClass((Classfile)subject, false, "question");
            } else if (subject instanceof Iterable) {
                this.selectInstructions((Iterable)subject);
            }
        }
        this.timeUI.repaint();
    }

    private class LoadingListener
    implements TraceListener {
        private LoadingListener() {
        }

        public void loadingProgress(String message, double percentLoaded) {
            if (WhylineUI.this.trace == null) {
                return;
            }
            WhylineUI.this.updateTask(WhylineUI.this.trace, message, percentLoaded);
        }

        public void loadingClassFiles() {
        }

        public void doneLoadingClassFiles() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WhylineUI.this.outlineUI.addFamiliarSource();
                    if (WhylineUI.this.trace.hasTextualOutputInstructions() && !WhylineUI.this.trace.hasGraphicalOutputInstructions()) {
                        WhylineUI.this.listeners.removeTimeListener(WhylineUI.this.graphicsUI);
                    } else if (!WhylineUI.this.trace.hasTextualOutputInstructions() && WhylineUI.this.trace.hasGraphicalOutputInstructions()) {
                        WhylineUI.this.listeners.removeTimeListener(WhylineUI.this.consoleUI);
                    }
                    if (WhylineUI.this.debuggingMode != Mode.WHYLINE && (WhylineUI.this.debuggingMode == Mode.SLICER || WhylineUI.this.debuggingMode == Mode.BREAKPOINT)) {
                        for (JavaSourceFile file : WhylineUI.this.trace.getAllSourceFiles()) {
                            WhylineUI.this.filesUI.getFilesView().getWindowViewOf(file);
                        }
                    }
                    WhylineUI.this.validate();
                    WhylineUI.this.repaint();
                }
            });
        }

        public void loadingMetadata() {
        }

        public void doneLoadingMetadata() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (!WhylineUI.this.isVisible()) {
                        return;
                    }
                    StringBuilder builder = new StringBuilder();
                    MethodInfo mainMethod = WhylineUI.this.trace.getMain();
                    if (mainMethod != null) {
                        builder.append(mainMethod.getClassfile().getInternalName().getText().replace('/', '.'));
                        for (String arg : WhylineUI.this.getTrace().getMainArguments()) {
                            builder.append(" " + arg);
                        }
                    } else {
                        builder.append("(didn't record main())");
                    }
                    WhylineUI.this.setTitle("Whyline for Java - " + builder.toString());
                    WhylineUI.this.selectMethod(WhylineUI.this.trace.getMain(), true, "loading");
                }
            });
        }

        public void doneLoading(final long time) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    double seconds = (double)(time / 10L) / 100.0;
                    boolean hasTextualOutput = WhylineUI.this.trace.hasTextualOutputEvents();
                    boolean hasGraphicalOutput = WhylineUI.this.trace.hasGraphicalOutputEvents();
                    WhylineUI.this.outputTabs.setSelectedIndex(hasGraphicalOutput || !hasTextualOutput ? 0 : 1);
                    WhylineUI.this.arrangeForAsking();
                    WhylineUI.this.timeUI.setProgress(1.0);
                    WhylineUI.this.log(new Note(NumberFormat.getNumberInstance().format(WhylineUI.this.trace.getNumberOfEvents()) + " events, " + seconds + " seconds"));
                    WhylineUI.this.setInputTime(WhylineUI.this.getTrace().getIOHistory().getNumberOfEvents() > 0 ? WhylineUI.this.getTrace().getIOHistory().getLastEvent().getEventID() : 0);
                    WhylineUI.this.setOutputTime(WhylineUI.this.trace.getNumberOfEvents() - 1);
                    if (WhylineUI.this.debuggingMode == Mode.WHYLINE) {
                        WhylineUI.this.timeUI.selectButtonBasedOnTrace();
                    }
                    WhylineUI.this.removeTask(WhylineUI.this.trace);
                    WhylineUI.this.persistentState.initializeState();
                    if (WhylineUI.this.saver != null) {
                        WhylineUI.this.saver.scheduleAtFixedRate(new TimerTask(){

                            public void run() {
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        try {
                                            WhylineUI.this.persistentState.write();
                                        }
                                        catch (IOException e) {
                                            e.printStackTrace();
                                        }
                                    }
                                });
                            }
                        }, 1000L, 2000L);
                    }
                }
            });
        }

        public void exceptionDuringLoading(Exception e) {
            JOptionPane.showMessageDialog(WhylineUI.this, "<html><p>There was an exception during the loading of the trace:<br><br>" + e.getMessage() + "</html>", "Trace loading error...", 0);
            WhylineUI.this.saveIfNecessaryThenClose();
        }

        public void additionalSourceLoaded(JavaSourceFile source) {
            WhylineUI.this.outlineUI.addSource(source);
        }

        public void blockEvent(boolean loaded, int blockID, int frequency) {
        }

        public void windowParsed(final WindowState window) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WhylineUI.this.graphicsUI.addWindowState(window);
                }
            });
        }

        public void ioEventsParsed(final int inputTime) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WhylineUI.this.setInputTime(inputTime);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        BREAKPOINT{

            public String getReadableName() {
                return "Breakpoints";
            }
        }
        ,
        SLICER{

            public String getReadableName() {
                return "Slicer";
            }
        }
        ,
        WHYLINE{

            public String getReadableName() {
                return "Whyline";
            }
        };


        public abstract String getReadableName();
    }

    private class Overlay
    extends WhylinePanel {
        private final MouseListener clicks = new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                Overlay.this.setIntercepting(false);
            }
        };
        private final MouseWheelListener scrolls = new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                Overlay.this.setIntercepting(false);
            }
        };
        private boolean addedListeners = false;

        public Overlay() {
            this.setIntercepting(false);
        }

        public void setIntercepting(boolean intercepting) {
            if (intercepting) {
                this.setEnabled(true);
                if (!this.addedListeners) {
                    this.addMouseListener(this.clicks);
                    this.addMouseWheelListener(this.scrolls);
                    this.addedListeners = true;
                }
            } else {
                this.setEnabled(false);
                this.removeMouseListener(this.clicks);
                this.removeMouseWheelListener(this.scrolls);
                this.addedListeners = false;
            }
            WhylineUI.this.repaint();
        }

        public void paintComponent(Graphics g) {
        }
    }

    private static class Task
    extends WhylineProgressBar {
        private final long creationTime = System.currentTimeMillis();
        private final String description;

        private Task(WhylineUI whylineUI, String description) {
            this.description = description;
            this.setBorder(new EmptyBorder(UI.getBorderPadding(), UI.getBorderPadding(), UI.getBorderPadding(), UI.getBorderPadding()));
            this.setProgress(0.0);
        }

        public String getDescription() {
            return this.description;
        }

        public void setProgress(double value) {
            this.setValue(value);
        }

        public void setStatus(String note) {
            this.setNote(note);
        }

        public long getMillisecondsSinceCreation() {
            return System.currentTimeMillis() - this.creationTime;
        }

        public String toString() {
            return this.description.toUpperCase();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UserListeners {
        private final Set<UserFocusListener> focusListeners = new HashSet<UserFocusListener>();
        private final Set<UserTimeListener> timeListeners = new HashSet<UserTimeListener>();
        private final Set<UserQuestionListener> questionListeners = new HashSet<UserQuestionListener>();

        private UserListeners() {
        }

        public synchronized Iterable<UserFocusListener> getFocusListeners() {
            return this.focusListeners;
        }

        public synchronized Iterable<UserTimeListener> getTimeListeners() {
            return this.timeListeners;
        }

        public synchronized Iterable<UserQuestionListener> getQuestionListeners() {
            return this.questionListeners;
        }

        public synchronized void addFocusListener(UserFocusListener listener) {
            this.focusListeners.add(listener);
        }

        public synchronized void addTimeListener(UserTimeListener listener) {
            this.timeListeners.add(listener);
        }

        public synchronized void addQuestionListener(UserQuestionListener listener) {
            this.questionListeners.add(listener);
        }

        public synchronized void removeFocusListener(UserFocusListener listener) {
            this.focusListeners.remove(listener);
        }

        public synchronized void removeTimeListener(UserTimeListener listener) {
            this.timeListeners.remove(listener);
        }
    }
}

