/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui;

import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.components.WhylineControlBorder;
import edu.cmu.hcii.whyline.ui.components.WhylineScrollPane;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicPopupMenuSeparatorUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class UI {
    public static final char LEFT_ARROW = '\u2190';
    public static final char UP_ARROW = '\u2191';
    public static final char RIGHT_ARROW = '\u2192';
    public static final char DOWN_ARROW = '\u2193';
    public static final char UP_WHITE_ARROW = '\u21e7';
    public static final char CHECKMARK = '\u2713';
    public static final char XMARK = '\u2716';
    public static final char INFINITY = '\u221e';
    public static final char EM_DASH = '\u2015';
    public static final char MINUS = '\u2212';
    public static final String EXPLANATION_BOX_TITLE = "notes";
    public static final String LOCALS_BOX_TITLE = "locals";
    public static final String CALL_STACK_BOX_TITLE = "call stack";
    public static final String SHOW_ORIGIN_LABEL = "show origin of value";
    public static final String SHOW_PRODUCER_LABEL = "show producer of value";
    public static final String POPUP_UI = "popup";
    public static final String BACK_UI = "back";
    public static final String OUTLINE_UI = "outline";
    public static final String RUN_TO_UI = "runto";
    public static final String STEP_INTO_UI = "into";
    public static final String STEP_OUT_UI = "out";
    public static final String STEP_OVER_UI = "over";
    public static final String SOURCE_ARROW_UI = "sourcearrow";
    public static final String EXCEPTIONS_UI = "exceptions";
    public static final String QUESTION_HOVER_UI = "question";
    public static final String LOADING_UI = "loading";
    public static final String OVERRIDE_UI = "override";
    public static final String DECLARATION_UI = "declaration";
    public static final String CLICK_EVENT_UI = "click";
    public static final String CLICK_UNEXECUTED_UI = "click";
    public static final String COLLAPSE_UI = "collapse";
    public static final String DATA_DEPENDENCY_UI = "data";
    public static final String INITIALIZATION_UI = "init";
    public static final String NEXT_EVENT_UI = "nextevent";
    public static final String PREVIOUS_EVENT_UI = "previousevent";
    public static final String NEXT_BLOCK_UI = "nextblock";
    public static final String PREVIOUS_BLOCK_UI = "previousblock";
    public static final String SOURCE_UI = "source";
    public static final String SEARCH_RESULTS_UI = "search";
    public static final String RELEVANT_LINES_UI = "search";
    public static final String BREAKPOINT_LINES_UI = "search";
    public static final String NAVIGATION_HISTORY_UI = "search";
    public static final String TIME_UI = "time";
    private static final String[] fontFamilyNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    private static final Set<String> fontFamilyNameSet = new HashSet<String>();
    private static final String VARIABLE_WIDTH_FONT_NAME;
    private static final String FIXED_WIDTH_FONT_NAME;
    private static final Font SMALL_FONT;
    private static final Font MEDIUM_FONT;
    private static final Font LARGE_FONT;
    private static final Font FIXED_WIDTH_FONT;
    private static Color FOCUS_COLOR;
    private static Color HIGHLIGHT_COLOR;
    private static Color HIGHLIGHT_TEXT_COLOR;
    private static Color PANEL_LIGHT_COLOR;
    private static Color PANEL_DARK_COLOR;
    private static Color CONTROL_BORDER_COLOR;
    private static Color PANEL_TEXT_COLOR;
    private static Color CONTROL_BACK_COLOR;
    private static Color CONTROL_CENTER_COLOR;
    private static Color CONTROL_FRONT_COLOR;
    private static Color CONTROL_TEXT_COLOR;
    private static Color CONTROL_DISABLED_COLOR;
    private static Color CONSOLE_BACK_COLOR;
    private static Color CONSOLE_TEXT_COLOR;
    public static final Color ERROR_COLOR;
    public static final Color CORRECT_COLOR;
    public static final Color CONTROL_COLOR;
    public static final Color DATA_COLOR;
    public static final Color IO_COLOR;
    public static final Color UNFAMILIAR_COLOR;
    private static Color FILE_COLOR;
    public static final Color FILE_FADED_COLOR;
    public static final Color IDENTIFIER_COLOR;
    public static final Color KEYWORD_COLOR;
    public static final Color LITERAL_COLOR;
    public static final Color COMMENT_COLOR;
    public static final Color DELIMITER_COLOR;
    public static final Color OPERATOR_COLOR;
    public static final Color BREAKPOINT_COLOR;
    public static final Color EXECUTING_LINE_COLOR;
    public static final BasicStroke UNSELECTED_STROKE;
    public static final BasicStroke SELECTED_STROKE;
    public static final BasicStroke UNSELECTED_DASHED_STROKE;
    public static final BasicStroke SELECTED_DASHED_STROKE;
    public static final BasicStroke INTERACTIVE_UNDERLINE_STROKE;
    public static final int MAX_EVENT_LENGTH = 12;
    public static final int MENU_CHARACTER_LENGTH_LIMIT = 16;
    private static final int ROUNDEDNESS = 10;
    private static final int PANEL_PADDING = 12;
    private static final int BORDER_PADDING = 4;
    private static final double INFO_PANE_PROPORTION = 0.2;
    private static final int TOOLBAR_HEIGHT = 32;
    private static final int CROSSHATCH_SPACING = 40;
    public static final int SCROLL_BAR_SIZE = 12;
    public static final int TIME_UI_HEIGHT = 100;
    public static final int GRAPHICS_SCALE_MIN = 25;
    public static final int GRAPHICS_SCALE_MAX = 250;
    public static final int PADDING_BETWEEN_EVENTS = 10;
    public static final int ELISION_PADDING = 60;
    public static final int ELISION_DIAMETER = 4;
    public static final int DIAMETERS_PER_ELISION = 4;
    public static final int PADDING_WITHIN_EVENTS = 4;
    public static final int BLOCK_VERTICAL_PADDING = 0;
    public static final int MIN_THREAD_ROW_HEIGHT = 48;
    public static final int HIDDEN_EVENT_SIZE = 0;
    public static final int ARROWHEAD_WIDTH = 8;
    public static final int CALLOUT_BOX_PADDING = 5;
    public static final double EVENT_BLOCK_SCALING = 1.0;
    public static final double MAX_MINIMIZED_FILE_HEIGHT = 20.0;
    public static final double MAX_MINIMIZED_FILE_WIDTH = 80.0;
    public static final int MOUSE_POSITION_MARKER_SIZE = 6;
    public static final double PROPORTION_OF_WINDOW_AT_WHICH_TO_SCROLL = 0.2;
    public static final double PROPORTION_OF_PIXELS_TO_SCROLL = 0.25;
    public static final float TRANSPARENCY_OF_IRRELEVANT_LINES = 0.5f;
    public static final float DESELECTED_ICON_TRANSPARENCY = 0.5f;
    private static final int ANIMATION_DURATION = 250;
    public static final String TAB_SPACES = "    ";
    public static int FILE_HEADER_PADDING;
    public static int ICON_SIZE;
    public static int WIDE_ICON_SIZE;
    public static ImageIcon WHYLINE_IMAGE;
    public static ImageIcon WHYLINE_ICON;
    public static ImageIcon REPAINT_ICON;
    public static ImageIcon MOUSE_UP_ICON;
    public static ImageIcon MOUSE_DOWN_ICON;
    public static ImageIcon MOUSE_MOVE_ICON;
    public static ImageIcon MOUSE_DRAG_ICON;
    public static ImageIcon MOUSE_WHEEL_ICON;
    public static ImageIcon KEY_UP_ICON;
    public static ImageIcon KEY_DOWN_ICON;
    public static ImageIcon CONSOLE_IN_ICON;
    public static ImageIcon CONSOLE_OUT_ICON;
    public static ImageIcon PREVIOUS_EVENT;
    public static ImageIcon NEXT_EVENT;
    public static ImageIcon PREVIOUS_BLOCK;
    public static ImageIcon NEXT_BLOCK;
    public static ImageIcon HIDE_THREADS;
    public static ImageIcon SHOW_THREADS;
    public static ImageIcon EXPAND;
    public static ImageIcon COLLAPSE;
    public static ImageIcon GO_BACK;
    public static ImageIcon STEP_INTO;
    public static ImageIcon STEP_OVER;
    public static ImageIcon STEP_OUT;
    public static ImageIcon STOP;
    public static ImageIcon RESUME;
    public static ImageIcon PAUSE;
    public static Icon TREE_BLANK;
    public static Icon TREE_OPEN;
    public static Icon TREE_CLOSED;
    public static Icon TREE_COLLAPSED;
    public static Icon TREE_EXPANDED;
    public static Icon TREE_LEAF;

    static {
        String[] stringArray = fontFamilyNames;
        int n = fontFamilyNames.length;
        int n2 = 0;
        while (n2 < n) {
            String family = stringArray[n2];
            fontFamilyNameSet.add(family);
            ++n2;
        }
        VARIABLE_WIDTH_FONT_NAME = fontFamilyNameSet.contains("Arial") ? "Arial" : "SansSerif";
        FIXED_WIDTH_FONT_NAME = fontFamilyNameSet.contains("Monaco") ? "Monaco" : "Monospaced";
        SMALL_FONT = new Font(VARIABLE_WIDTH_FONT_NAME, 0, 11);
        MEDIUM_FONT = new Font(VARIABLE_WIDTH_FONT_NAME, 0, 12);
        LARGE_FONT = new Font(VARIABLE_WIDTH_FONT_NAME, 1, 14);
        FIXED_WIDTH_FONT = new Font(FIXED_WIDTH_FONT_NAME, 0, 11);
        FOCUS_COLOR = Color.white;
        HIGHLIGHT_COLOR = new Color(255, 128, 0);
        HIGHLIGHT_TEXT_COLOR = Color.white;
        PANEL_LIGHT_COLOR = new Color(40, 40, 40);
        PANEL_DARK_COLOR = new Color(20, 20, 20);
        CONTROL_BORDER_COLOR = new Color(64, 64, 64);
        PANEL_TEXT_COLOR = Color.white;
        CONTROL_BACK_COLOR = Color.black;
        CONTROL_CENTER_COLOR = Color.darkGray;
        CONTROL_FRONT_COLOR = Color.lightGray;
        CONTROL_TEXT_COLOR = Color.white;
        CONTROL_DISABLED_COLOR = new Color(96, 96, 96);
        CONSOLE_BACK_COLOR = Color.black;
        CONSOLE_TEXT_COLOR = new Color(89, 225, 22);
        ERROR_COLOR = new Color(200, 0, 0);
        CORRECT_COLOR = new Color(0, 200, 0);
        CONTROL_COLOR = new Color(64, 155, 83);
        DATA_COLOR = new Color(103, 105, 211);
        IO_COLOR = new Color(196, 196, 196);
        UNFAMILIAR_COLOR = new Color(128, 128, 128);
        FILE_COLOR = Color.white;
        FILE_FADED_COLOR = new Color(228, 228, 228);
        IDENTIFIER_COLOR = new Color(0, 0, 0);
        KEYWORD_COLOR = new Color(79, 14, 120);
        LITERAL_COLOR = new Color(42, 92, 255);
        COMMENT_COLOR = new Color(63, 127, 112);
        DELIMITER_COLOR = new Color(64, 64, 64);
        OPERATOR_COLOR = new Color(64, 64, 64);
        BREAKPOINT_COLOR = new Color(125, 125, 255);
        EXECUTING_LINE_COLOR = new Color(255, 200, 200);
        UNSELECTED_STROKE = new BasicStroke(1.0f, 1, 1);
        SELECTED_STROKE = new BasicStroke(4.0f, 1, 1);
        UNSELECTED_DASHED_STROKE = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{4.0f, 8.0f}, 0.0f);
        SELECTED_DASHED_STROKE = new BasicStroke(4.0f, 1, 1, 1.0f, new float[]{4.0f, 8.0f}, 0.0f);
        INTERACTIVE_UNDERLINE_STROKE = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{1.0f, 1.0f}, 0.0f);
        FILE_HEADER_PADDING = 3;
        ICON_SIZE = 24;
        WIDE_ICON_SIZE = 48;
        WHYLINE_IMAGE = new ImageIcon(WhylineUI.class.getResource("images/whyline_large.png"));
        WHYLINE_ICON = UI.loadImage("whyline.png");
        REPAINT_ICON = UI.loadImage("repaint.png");
        MOUSE_UP_ICON = UI.loadImage("mouseup.png");
        MOUSE_DOWN_ICON = UI.loadImage("mousedown.png");
        MOUSE_MOVE_ICON = UI.loadImage("mousemove.png");
        MOUSE_DRAG_ICON = UI.loadImage("mousedrag.png");
        MOUSE_WHEEL_ICON = UI.loadImage("mousewheel.png");
        KEY_UP_ICON = UI.loadImage("keyup.png");
        KEY_DOWN_ICON = UI.loadImage("keydown.png");
        CONSOLE_IN_ICON = UI.loadImage("consolein.png");
        CONSOLE_OUT_ICON = UI.loadImage("consoleout.png");
        PREVIOUS_EVENT = UI.loadImageWithWidth("previous_event.png", WIDE_ICON_SIZE);
        NEXT_EVENT = UI.loadImageWithWidth("next_event.png", WIDE_ICON_SIZE);
        PREVIOUS_BLOCK = UI.loadImageWithWidth("previous_block.png", WIDE_ICON_SIZE);
        NEXT_BLOCK = UI.loadImageWithWidth("next_block.png", WIDE_ICON_SIZE);
        HIDE_THREADS = UI.loadImageWithWidth("hide_threads.png", WIDE_ICON_SIZE);
        SHOW_THREADS = UI.loadImageWithWidth("show_threads.png", WIDE_ICON_SIZE);
        EXPAND = UI.loadImageWithWidth("expand.png", WIDE_ICON_SIZE);
        COLLAPSE = UI.loadImageWithWidth("collapse.png", WIDE_ICON_SIZE);
        GO_BACK = UI.loadImageWithWidth("back.png", ICON_SIZE);
        STEP_INTO = new ImageIcon(WhylineUI.class.getResource("images/stepinto.gif"));
        STEP_OVER = new ImageIcon(WhylineUI.class.getResource("images/stepover.gif"));
        STEP_OUT = new ImageIcon(WhylineUI.class.getResource("images/stepout.gif"));
        STOP = new ImageIcon(WhylineUI.class.getResource("images/stop.png"));
        RESUME = new ImageIcon(WhylineUI.class.getResource("images/resume.gif"));
        PAUSE = new ImageIcon(WhylineUI.class.getResource("images/pause.png"));
        TREE_BLANK = new Icon(){

            public int getIconHeight() {
                return 12;
            }

            public int getIconWidth() {
                return 12;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
            }
        };
        TREE_OPEN = new Icon(){

            public int getIconHeight() {
                return 12;
            }

            public int getIconWidth() {
                return 12;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                g = g.create();
                g.setColor(UI.getControlFrontColor());
                g.drawLine(x + 3, y + 6, x + 9, y + 6);
            }
        };
        TREE_CLOSED = new Icon(){

            public int getIconHeight() {
                return 12;
            }

            public int getIconWidth() {
                return 12;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                g = g.create();
                g.setColor(UI.getControlFrontColor());
                g.drawLine(x + 3, y + 6, x + 9, y + 6);
                g.drawLine(x + 6, y + 3, x + 6, y + 9);
            }
        };
        TREE_COLLAPSED = TREE_BLANK;
        TREE_EXPANDED = TREE_BLANK;
        TREE_LEAF = new Icon(){

            public int getIconHeight() {
                return 12;
            }

            public int getIconWidth() {
                return 12;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
            }
        };
        UI.setDefaultColors();
    }

    public static Font getSmallFont() {
        return SMALL_FONT;
    }

    public static Font getMediumFont() {
        return MEDIUM_FONT;
    }

    public static Font getLargeFont() {
        return LARGE_FONT;
    }

    public static Font getFixedFont() {
        return FIXED_WIDTH_FONT;
    }

    public static void setColors(Color focus, Color highlight, Color highlightText, Color panelLight, Color panelDark, Color panelText, Color controlBorder, Color controlBack, Color controlCenter, Color controlFront, Color controlText, Color disabledText, Color consoleBack, Color consoleText) {
        FOCUS_COLOR = focus;
        HIGHLIGHT_COLOR = highlight;
        HIGHLIGHT_TEXT_COLOR = highlightText;
        PANEL_LIGHT_COLOR = panelLight;
        PANEL_DARK_COLOR = panelDark;
        CONTROL_BORDER_COLOR = controlBorder;
        PANEL_TEXT_COLOR = panelText;
        CONTROL_BACK_COLOR = controlBack;
        CONTROL_CENTER_COLOR = controlCenter;
        CONTROL_FRONT_COLOR = controlFront;
        CONTROL_TEXT_COLOR = controlText;
        CONTROL_DISABLED_COLOR = disabledText;
        CONSOLE_BACK_COLOR = consoleBack;
        CONSOLE_TEXT_COLOR = consoleText;
        FILE_COLOR = CONTROL_BACK_COLOR;
        UI.installColorsInSwingComponents();
    }

    public static void setDefaultColors() {
        UI.setCreamColors();
    }

    public static void setBlackColors() {
        UI.setColors(new Color(255, 255, 255), new Color(255, 128, 0), new Color(255, 255, 255), new Color(40, 40, 40), new Color(20, 20, 20), new Color(255, 255, 255), new Color(64, 64, 64), new Color(0, 0, 0), new Color(64, 64, 64), new Color(192, 192, 192), new Color(255, 255, 255), new Color(96, 96, 96), new Color(0, 0, 0), new Color(89, 225, 22));
    }

    public static void setCreamColors() {
        UI.setColors(new Color(0, 0, 0), new Color(255, 165, 0), new Color(0, 0, 0), new Color(215, 210, 181), new Color(181, 171, 113), new Color(0, 0, 0), new Color(102, 98, 74), new Color(255, 255, 245), new Color(200, 200, 200), new Color(128, 128, 128), new Color(0, 0, 0), new Color(64, 64, 64), new Color(255, 255, 245), new Color(0, 0, 0));
    }

    public static void setGrayColors() {
        Color light = new Color(220, 220, 220);
        Color dark = new Color(160, 160, 160);
        Color darker = new Color(120, 120, 120);
        UI.setColors(new Color(0, 0, 0), new Color(255, 145, 0), new Color(0, 0, 0), light, dark, new Color(0, 0, 0), darker, new Color(255, 255, 255), light, darker, new Color(0, 0, 0), darker, new Color(0, 0, 0), new Color(89, 225, 22));
    }

    public static Color getFocusColor() {
        return FOCUS_COLOR;
    }

    public static Color getHighlightColor() {
        return HIGHLIGHT_COLOR;
    }

    public static Color getHighlightTextColor() {
        return HIGHLIGHT_TEXT_COLOR;
    }

    public static Color getPanelLightColor() {
        return PANEL_LIGHT_COLOR;
    }

    public static Color getPanelDarkColor() {
        return PANEL_DARK_COLOR;
    }

    public static Color getPanelTextColor() {
        return PANEL_TEXT_COLOR;
    }

    public static Color getControlBorderColor() {
        return CONTROL_BORDER_COLOR;
    }

    public static Color getControlBackColor() {
        return CONTROL_BACK_COLOR;
    }

    public static Color getControlCenterColor() {
        return CONTROL_CENTER_COLOR;
    }

    public static Color getControlFrontColor() {
        return CONTROL_FRONT_COLOR;
    }

    public static Color getControlTextColor() {
        return CONTROL_TEXT_COLOR;
    }

    public static Color getControlDisabledColor() {
        return CONTROL_DISABLED_COLOR;
    }

    public static Color getConsoleTextColor() {
        return CONSOLE_TEXT_COLOR;
    }

    public static Color getConsoleBackColor() {
        return CONSOLE_BACK_COLOR;
    }

    public static Color getStoppedColor() {
        return new Color(255, 128, 128);
    }

    public static Color getRunningColor() {
        return new Color(96, 255, 96);
    }

    public static Color getFileColor() {
        return FILE_COLOR;
    }

    public static int getRoundedness() {
        return 10;
    }

    public static int getPanelPadding() {
        return 12;
    }

    public static int getBorderPadding() {
        return 4;
    }

    public static int getDefaultInfoPaneWidth(Window window) {
        return (int)((double)window.getWidth() * 0.2);
    }

    public static int getDefaultInfoPaneHeight(Window window) {
        return (int)((double)window.getHeight() * 0.2);
    }

    public static int getToolbarHeight() {
        return 32;
    }

    public static int getCrosshatchSpacing() {
        return 40;
    }

    public static int getDuration() {
        return 250;
    }

    private static ImageIcon loadImage(String name) {
        return new ImageIcon(new ImageIcon(WhylineUI.class.getResource("images/" + name)).getImage().getScaledInstance(ICON_SIZE, ICON_SIZE, 4));
    }

    private static ImageIcon loadImageWithWidth(String name, int width) {
        ImageIcon newImage = new ImageIcon(WhylineUI.class.getResource("images/" + name));
        double ratio = (double)newImage.getIconHeight() / (double)newImage.getIconWidth();
        int height = (int)(ratio * (double)width);
        return new ImageIcon(newImage.getImage().getScaledInstance(width, height, 4));
    }

    public static void installColorsInSwingComponents() {
        UIManager.put("Panel.background", new ColorUIResource(UI.getPanelLightColor()));
        UIManager.put("Panel.font", new FontUIResource(UI.getSmallFont()));
        UIManager.put("Panel.foreground", new ColorUIResource(UI.getPanelTextColor()));
        UIManager.put("Label.background", new ColorUIResource(UI.getPanelLightColor()));
        UIManager.put("Label.font", new FontUIResource(UI.getSmallFont()));
        UIManager.put("Label.foreground", new ColorUIResource(UI.getPanelTextColor()));
        UIManager.put("Label.disabledForeground", new ColorUIResource(UI.getPanelTextColor()));
        UIManager.put("Label.disabledShadow", new ColorUIResource(UI.getPanelLightColor()));
        UIManager.put("OptionPane.background", new ColorUIResource(UI.getPanelLightColor()));
        UIManager.put("OptionPane.foreground", new ColorUIResource(UI.getPanelTextColor()));
        UIManager.put("OptionPane.questionDialog.border.background", new ColorUIResource(UI.getPanelLightColor()));
        UIManager.put("OptionPane.messageAreaBorder", new BorderUIResource(new EmptyBorder(10, 10, 10, 10)));
        UIManager.put("OptionPane.messageForeground", new ColorUIResource(UI.getPanelTextColor()));
        UIManager.put("Viewport.background", new ColorUIResource(UI.getPanelLightColor()));
        UIManager.put("windowBorder", UI.getPanelLightColor());
        UIManager.put("control", UI.getControlBackColor());
        UIManager.put("controlShadow", UI.getControlBackColor());
        UIManager.put("controlDkShadow", UI.getControlBackColor());
        UIManager.put("controlHighlight", UI.getControlBackColor());
        UIManager.put("controlLtHighlight", UI.getControlBackColor());
        UIManager.put("controlShadow", UI.getControlBackColor());
        UIManager.put("controlText", UI.getControlTextColor());
        ArrayList<Serializable> gradient = new ArrayList<Serializable>();
        gradient.add(Double.valueOf(0.2));
        gradient.add(Double.valueOf(0.6));
        gradient.add(UI.getControlFrontColor());
        gradient.add(UI.getControlCenterColor());
        gradient.add(UI.getControlFrontColor());
        UIManager.put("Button.gradient", gradient);
        UIManager.put("Button.background", new ColorUIResource(UI.getControlBackColor()));
        final Insets insets = new Insets(6, 4, 6, 4);
        Border buttonBorder = new Border(){

            public Insets getBorderInsets(Component c) {
                return insets;
            }

            public boolean isBorderOpaque() {
                return false;
            }

            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                if (c.isEnabled()) {
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.setColor(UI.getControlBorderColor());
                    g.drawRoundRect(x, y, width - 1, height - 1, 4, 4);
                }
            }
        };
        UIManager.put("Button.border", new BorderUIResource(buttonBorder));
        UIManager.put("Button.darkShadow", new ColorUIResource(UI.getHighlightColor()));
        UIManager.put("Button.disabledText", new ColorUIResource(UI.getControlDisabledColor()));
        UIManager.put("Button.focus", new ColorUIResource(UI.getHighlightColor()));
        UIManager.put("Button.foreground", new ColorUIResource(UI.getControlTextColor()));
        UIManager.put("Button.highlight", new ColorUIResource(UI.getHighlightColor()));
        UIManager.put("Button.light", new ColorUIResource(UI.getHighlightColor()));
        UIManager.put("Button.select", new ColorUIResource(UI.getHighlightColor()));
        UIManager.put("Button.shadow", new ColorUIResource(UI.getHighlightColor()));
        UIManager.put("Button.font", new FontUIResource(UI.getSmallFont()));
        UIManager.put("RootPane.questionDialogBorder", new BorderUIResource(new EmptyBorder(10, 10, 10, 10)));
        UIManager.put("RootPane.warningDialogBorder", new BorderUIResource(new EmptyBorder(10, 10, 10, 10)));
        UIManager.put("RootPane.informationDialogBorder", new BorderUIResource(new EmptyBorder(10, 10, 10, 10)));
        UIManager.put("RootPane.frameBorder", new BorderUIResource(new EmptyBorder(10, 10, 10, 10)));
        UIManager.put("Checkbox.select", new ColorUIResource(UI.getHighlightColor()));
        UIManager.put("EditorPane.selectionBackground", new ColorUIResource(UI.getHighlightColor()));
        UIManager.put("EditorPane.selectionForeground", new ColorUIResource(UI.getHighlightTextColor()));
        UIManager.put("EditorPane.caretForeground", new ColorUIResource(UI.getControlTextColor()));
        UIManager.put("FormattedTextField.selectionBackground", new ColorUIResource(UI.getHighlightColor()));
        UIManager.put("FormattedTextField.selectionBackground", new ColorUIResource(UI.getHighlightTextColor()));
        UIManager.put("FormattedTextField.border", new BorderUIResource(new WhylineControlBorder()));
        UIManager.put("FormattedTextField.foreground", new ColorUIResource(UI.getControlTextColor()));
        UIManager.put("FormattedTextField.background", new ColorUIResource(UI.getControlBackColor()));
        UIManager.put("TextField.selectionBackground", new ColorUIResource(UI.getHighlightColor()));
        UIManager.put("TextField.selectionForeground", new ColorUIResource(UI.getHighlightTextColor()));
        UIManager.put("TextField.border", new BorderUIResource(new WhylineControlBorder()));
        UIManager.put("TextField.foreground", new ColorUIResource(UI.getControlTextColor()));
        UIManager.put("TextField.background", new ColorUIResource(UI.getControlBackColor()));
        UIManager.put("List.selectionForeground", new ColorUIResource(UI.getHighlightTextColor()));
        UIManager.put("List.selectionBackground", new ColorUIResource(UI.getHighlightColor()));
        UIManager.put("List.focusCellHighlightBorder", new ColorUIResource(UI.getHighlightColor()));
        UIManager.put("RadioButton.select", new ColorUIResource(UI.getHighlightColor()));
        UIManager.put("Table.selectionBackground", new ColorUIResource(UI.getHighlightColor()));
        UIManager.put("Table.selectionForeground", new ColorUIResource(UI.getHighlightTextColor()));
        UIManager.put("TextArea.selectionBackground", new ColorUIResource(UI.getHighlightColor()));
        UIManager.put("TextArea.selectionForeground", new ColorUIResource(UI.getHighlightTextColor()));
        UIManager.put("TextArea.caretForeground", new ColorUIResource(UI.getControlTextColor()));
        UIManager.put("TextPane.selectionBackground", new ColorUIResource(UI.getHighlightColor()));
        UIManager.put("TextPane.selectionForeground", new ColorUIResource(UI.getHighlightTextColor()));
        UIManager.put("TextPane.caretForeground", new ColorUIResource(UI.getControlTextColor()));
        UIManager.put("ToggleButton.selectionBackground", new ColorUIResource(UI.getHighlightColor()));
        UIManager.put("ToggleButton.selectionForeground", new ColorUIResource(UI.getHighlightTextColor()));
        UIManager.put("ToggleButton.select", new ColorUIResource(UI.getHighlightColor()));
        UIManager.put("Tree.selectionBackground", new ColorUIResource(UI.getHighlightColor()));
        UIManager.put("Tree.selectionForeground", new ColorUIResource(UI.getHighlightTextColor()));
        LineBorder tooltipBorder = new LineBorder(UI.getControlBorderColor(), 1, true){

            public Insets getBorderInsets(Component c) {
                return new Insets(3, 3, 3, 3);
            }
        };
        UIManager.put("ToolTip.background", new ColorUIResource(UI.getPanelLightColor()));
        UIManager.put("ToolTip.foreground", new ColorUIResource(UI.getHighlightTextColor()));
        UIManager.put("ToolTip.border", tooltipBorder);
        UIManager.put("ToolTip.backgroundInactive", new ColorUIResource(UI.getHighlightColor()));
        UIManager.put("ToolTip.foregroundInactive", new ColorUIResource(UI.getHighlightTextColor()));
        UIManager.put("ToolTip.borderInactive", tooltipBorder);
        UIManager.put("ToolTip.font", new FontUIResource(UI.getSmallFont()));
        ToolTipManager.sharedInstance().setInitialDelay(1000);
        ToolTipManager.sharedInstance().setDismissDelay(3000);
        ToolTipManager.sharedInstance().setReshowDelay(1000);
        UIManager.put("ToolBar.background", new ColorUIResource(UI.getPanelLightColor()));
        UIManager.put("ToolBar.border", new BorderUIResource(new EmptyBorder(UI.getPanelPadding(), UI.getPanelPadding(), UI.getPanelPadding(), UI.getPanelPadding())));
        UIManager.put("ToolBar.darkShadow", new ColorUIResource(UI.getPanelLightColor()));
        UIManager.put("ToolBar.foreground", new ColorUIResource(UI.getPanelLightColor()));
        UIManager.put("ToolBar.nonrolloverBorder", new BorderUIResource(buttonBorder));
        UIManager.put("ToolBar.rolloverBorder", new BorderUIResource(buttonBorder));
        UIManager.put("ToolBar.separatorSize", new Dimension(UI.getPanelPadding(), UI.getPanelPadding()));
        UIManager.put("textHighlight", new ColorUIResource(UI.getHighlightColor()));
        UIManager.put("textHighlightText", new ColorUIResource(UI.getHighlightTextColor()));
        UIManager.put("Menu.selectionForeground", new ColorUIResource(UI.getHighlightTextColor()));
        UIManager.put("Menu.selectionBackground", new ColorUIResource(UI.getHighlightColor()));
        UIManager.put("MenuItem.selectionForeground", new ColorUIResource(UI.getHighlightTextColor()));
        UIManager.put("MenuItem.selectionBackground", new ColorUIResource(UI.getHighlightColor()));
        UIManager.put("Tree.background", new ColorUIResource(UI.getControlBackColor()));
        UIManager.put("Tree.foreground", new ColorUIResource(UI.getControlTextColor()));
        UIManager.put("Tree.textBackground", new ColorUIResource(UI.getControlBackColor()));
        UIManager.put("Tree.textForeground", new ColorUIResource(UI.getControlTextColor()));
        UIManager.put("Tree.line", new ColorUIResource(UI.getControlBackColor()));
        UIManager.put("Tree.selectionBackground", new ColorUIResource(UI.getHighlightColor()));
        UIManager.put("Tree.selectionBorderColor", new ColorUIResource(UI.getHighlightColor()));
        UIManager.put("Tree.selectionForeground", new ColorUIResource(UI.getHighlightTextColor()));
        UIManager.put("Tree.scrollsOnExpand", true);
        UIManager.put("Tree.font", new FontUIResource(UI.getSmallFont()));
        UIManager.put("Tree.openIcon", new IconUIResource(TREE_OPEN));
        UIManager.put("Tree.closedIcon", new IconUIResource(TREE_CLOSED));
        UIManager.put("Tree.collapsedIcon", new IconUIResource(TREE_COLLAPSED));
        UIManager.put("Tree.expandedIcon", new IconUIResource(TREE_EXPANDED));
        UIManager.put("Tree.leafIcon", new IconUIResource(TREE_LEAF));
        UIManager.put("ComboBox.font", new FontUIResource(UI.getMediumFont()));
        UIManager.put("ComboBox.background", new ColorUIResource(UI.getControlBackColor()));
        UIManager.put("ComboBox.buttonBackground", new ColorUIResource(UI.getControlBackColor()));
        UIManager.put("ComboBox.buttonDarkShadow", new ColorUIResource(UI.getControlBackColor()));
        UIManager.put("ComboBox.buttonHighlight", new ColorUIResource(UI.getControlBackColor()));
        UIManager.put("ComboBox.buttonShadow", new ColorUIResource(UI.getControlBackColor()));
        UIManager.put("ComboBox.disabledBackground", new ColorUIResource(UI.getControlBackColor()));
        UIManager.put("ComboBox.disabledForeground", new ColorUIResource(UI.getControlCenterColor()));
        UIManager.put("ComboBox.foreground", new ColorUIResource(UI.getControlTextColor()));
        UIManager.put("ComboBox.selectionForeground", new ColorUIResource(UI.getHighlightTextColor()));
        UIManager.put("ComboBox.selectionBackground", new ColorUIResource(UI.getHighlightColor()));
        UIManager.put("Table.background", new ColorUIResource(UI.getControlBackColor()));
        UIManager.put("Table.foreground", new ColorUIResource(UI.getControlTextColor()));
        UIManager.put("Table.gridColor", new ColorUIResource(UI.getControlBackColor()));
        UIManager.put("Table.focusCellBackground", new ColorUIResource(UI.getControlBackColor()));
        UIManager.put("Table.focusCellForeground", new ColorUIResource(UI.getControlBackColor()));
        UIManager.put("Table.focusCellHighlightBorder", new ColorUIResource(UI.getControlBackColor()));
        UIManager.put("Table.selectionBackground", new ColorUIResource(UI.getHighlightColor()));
        UIManager.put("Table.selectionForeground", new ColorUIResource(UI.getHighlightTextColor()));
        UIManager.put("Table.font", new FontUIResource(UI.getMediumFont().deriveFont(10.0f)));
        UIManager.put("Table.scrollPaneBorder", new BorderUIResource(new EmptyBorder(2, 2, 2, 2)));
        UIManager.put("TableHeader.cellBorder", new BorderUIResource(new EmptyBorder(2, 2, 2, 2)));
        UIManager.put("TableHeader.font", new FontUIResource(UI.getMediumFont().deriveFont(1)));
        UIManager.put("TableHeader.background", new ColorUIResource(UI.getControlBackColor()));
        UIManager.put("TableHeader.foreground", new ColorUIResource(UI.getControlTextColor()));
        UIManager.put("TableHeader.font", new FontUIResource(UI.getMediumFont()));
        int padding = UI.getBorderPadding();
        UIManager.put("TabbedPane.selectedTabPadInsets", new InsetsUIResource(padding, padding, padding, padding));
        UIManager.put("TabbedPane.tabAreaInsets", new InsetsUIResource(0, padding, -padding - 1, padding));
        UIManager.put("TabbedPane.tabInsets", new InsetsUIResource(padding, padding, padding, padding));
        UIManager.put("TabbedPane.font", new FontUIResource(UI.getLargeFont()));
        UIManager.put("TabbedPane.contentBorderInsets", new InsetsUIResource(0, 0, 0, 0));
        UIManager.put("TabbedPane.background", new ColorUIResource(UI.getControlBackColor()));
        UIManager.put("TabbedPane.darkShadow", new ColorUIResource(UI.getPanelDarkColor()));
        UIManager.put("TabbedPane.foreground", new ColorUIResource(UI.getControlTextColor()));
        UIManager.put("TabbedPane.highlight", new ColorUIResource(UI.getControlFrontColor()));
        UIManager.put("TabbedPane.light", new ColorUIResource(UI.getControlCenterColor()));
        UIManager.put("TabbedPane.selectHighlight", new ColorUIResource(UI.getControlBorderColor()));
        UIManager.put("TabbedPane.selected", new ColorUIResource(UI.getControlCenterColor()));
        UIManager.put("TabbedPane.shadow", new ColorUIResource(UI.getPanelLightColor()));
        UIManager.put("Separator.background", new ColorUIResource(UI.getPanelDarkColor()));
        UIManager.put("Separator.foreground", new ColorUIResource(UI.getPanelDarkColor()));
        UIManager.put("Separator.highlight", new ColorUIResource(UI.getPanelDarkColor()));
        UIManager.put("Separator.shadow", new ColorUIResource(UI.getPanelDarkColor()));
        UIManager.put("ScrollBarUI", WhylineScrollPane.WhylineScrollBarUI.class.getName());
        UIManager.put("ScrollBar.darkShadow", new ColorUIResource(UI.getControlBackColor()));
        UIManager.put("ScrollBar.highlight", new ColorUIResource(UI.getControlBackColor()));
        UIManager.put("ScrollBar.width", 12);
        UIManager.put("SliderUI", BasicSliderUI.class.getName());
        UIManager.put("Slider.background", new ColorUIResource(UI.getPanelLightColor()));
        UIManager.put("Slider.foreground", new ColorUIResource(UI.getControlFrontColor()));
        UIManager.put("Slider.highlight", new ColorUIResource(UI.getControlCenterColor()));
        UIManager.put("Slider.shadow", new ColorUIResource(UI.getControlFrontColor()));
        UIManager.put("Slider.focus", new ColorUIResource(UI.getControlCenterColor()));
        UIManager.put("PopupMenuSeparatorUI", PopupSeparatorUI.class.getName());
        UIManager.put("SplitPane.dividerSize", UI.getPanelPadding());
        UIManager.put("SplitPaneDivider.border", new Border(){

            public Insets getBorderInsets(Component c) {
                return null;
            }

            public boolean isBorderOpaque() {
                return true;
            }

            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                g.setColor(UI.getPanelLightColor());
                g.fillRect(0, 0, width, height);
            }
        });
        ArrayList<Serializable> checkboxGradient = new ArrayList<Serializable>();
        checkboxGradient.add(Double.valueOf(0.2));
        checkboxGradient.add(Double.valueOf(0.6));
        checkboxGradient.add(UI.getControlFrontColor());
        checkboxGradient.add(UI.getControlCenterColor());
        checkboxGradient.add(UI.getControlFrontColor());
        UIManager.put("CheckBox.background", new ColorUIResource(UI.getControlFrontColor()));
        UIManager.put("CheckBox.foreground", new ColorUIResource(UI.getControlTextColor()));
        UIManager.put("CheckBox.disabledText", new ColorUIResource(UI.getControlDisabledColor()));
        UIManager.put("CheckBox.focus", new ColorUIResource(UI.getControlBorderColor()));
        UIManager.put("CheckBox.gradient", checkboxGradient);
        UIManager.put("CheckBox.select", new ColorUIResource(UI.getHighlightColor()));
        UIManager.put("CheckBox.shadow", new ColorUIResource(UI.getHighlightColor()));
        UIManager.put("CheckBox.light", new ColorUIResource(UI.getHighlightColor()));
        UIManager.put("CheckBox.highlight", new ColorUIResource(UI.getHighlightColor()));
        UIManager.put("CheckBox.darkShadow", new ColorUIResource(UI.getHighlightColor()));
        UI.setOSXFieldShortcuts();
    }

    public static void setOSXFieldShortcuts() {
        String lowercaseOSName = System.getProperty("os.name").toLowerCase();
        boolean MAC_OS_X = lowercaseOSName.startsWith("mac os x");
        if (MAC_OS_X) {
            UIDefaults.LazyInputMap fieldInputMap = new UIDefaults.LazyInputMap(new Object[]{"meta C", "copy-to-clipboard", "meta V", "paste-from-clipboard", "meta X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "alt LEFT", "caret-previous-word", "alt KP_LEFT", "caret-previous-word", "alt RIGHT", "caret-next-word", "alt KP_RIGHT", "caret-next-word", "alt shift LEFT", "selection-previous-word", "alt shift KP_LEFT", "selection-previous-word", "alt shift RIGHT", "selection-next-word", "alt shift KP_RIGHT", "selection-next-word", "meta A", "select-all", "HOME", "caret-begin-line", "meta LEFT", "caret-begin-line", "END", "caret-end-line", "meta RIGHT", "caret-end-line", "shift HOME", "selection-begin-line", "meta shift LEFT", "selection-begin-line", "meta shift RIGHT", "selection-end-line", "shift END", "selection-end-line", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "UP", "caret-begin", "DOWN", "caret-end", "shift UP", "selection-begin", "shift DOWN", "selection-end", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "meta shift A", "unselect", "control shift O", "toggle-componentOrientation"});
            UIManager.put("TextField.focusInputMap", fieldInputMap);
            UIManager.put("TextArea.focusInputMap", fieldInputMap);
            UIManager.put("TextPane.focusInputMap", fieldInputMap);
        }
    }

    public static class PopupSeparatorUI
    extends BasicPopupMenuSeparatorUI {
        public static ComponentUI createUI(JComponent c) {
            return new PopupSeparatorUI();
        }

        public void paint(Graphics g, JComponent c) {
            Dimension s = c.getSize();
            g.setColor(UI.getControlBorderColor());
            int y = UI.getPanelPadding() / 2;
            g.drawLine(0, y, s.width, y);
        }

        public Dimension getPreferredSize(JComponent c) {
            return new Dimension(0, UI.getPanelPadding());
        }
    }
}

