/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui;

import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.components.WhylinePanel;
import edu.cmu.hcii.whyline.util.Util;
import gnu.trove.TIntObjectHashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class TraceExplorerUI
extends WhylinePanel
implements Scrollable {
    private final Trace trace;
    private final JTree tree;
    private final TreeNode root = new TreeNode(){
        private final TIntObjectHashMap<ThreadNode> threads = new TIntObjectHashMap();

        public Enumeration<TreeNode> children() {
            return null;
        }

        @Override
        public int getIndex(TreeNode node) {
            return ((ThreadNode)node).id;
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public TreeNode getChildAt(int id) {
            ThreadNode node = this.threads.get(id);
            if (node == null) {
                node = new ThreadNode(id);
                this.threads.put(id, node);
            }
            return node;
        }

        @Override
        public int getChildCount() {
            return TraceExplorerUI.this.trace.getNumberOfThreads();
        }

        @Override
        public TreeNode getParent() {
            return null;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        public String toString() {
            return "events";
        }
    };
    private final DefaultTreeModel model = new DefaultTreeModel(this.root);

    public TraceExplorerUI(Trace trace) {
        this.trace = trace;
        this.tree = new JTree(this.model);
        this.tree.setShowsRootHandles(false);
        this.tree.setFont(UI.getFixedFont());
        this.setLayout(new BorderLayout());
        this.add((Component)this.tree, "Center");
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 100;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 100;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return null;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MethodNode
    implements TreeNode {
        private final ThreadNode thread;
        private final MethodInfo method;
        private int count;

        public MethodNode(ThreadNode thread, MethodInfo method) {
            this.thread = thread;
            this.method = method;
        }

        public Enumeration<TreeNode> children() {
            return null;
        }

        @Override
        public int getIndex(TreeNode node) {
            return 0;
        }

        @Override
        public boolean getAllowsChildren() {
            return false;
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return null;
        }

        @Override
        public int getChildCount() {
            return 0;
        }

        @Override
        public TreeNode getParent() {
            return this.thread;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        public String toString() {
            return String.valueOf(Util.fillOrTruncateString(Integer.toString(this.count), 10)) + Util.fillOrTruncateString(this.method.getClassfile().getInternalName().getNameWithDots(), 30) + "     " + this.method.getJavaName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ThreadNode
    implements TreeNode {
        private final int id;
        private MethodNode[] sort = null;
        private Map<MethodInfo, MethodNode> methods = new HashMap<MethodInfo, MethodNode>();
        private int percentDone;

        public ThreadNode(int threadID) {
            this.id = threadID;
            Thread counter = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Trace.ThreadIterator eventIDs = TraceExplorerUI.this.trace.getThreadIteratorAt(TraceExplorerUI.this.trace.getThreadFirstEventID(ThreadNode.this.id));
                    int count = 0;
                    while (eventIDs.hasNextInThread()) {
                        1 var3_3 = this;
                        synchronized (var3_3) {
                            int eventID = eventIDs.nextInThread();
                            Instruction inst = TraceExplorerUI.this.trace.getInstruction(eventID);
                            MethodNode mNode = (MethodNode)ThreadNode.this.methods.get(inst.getMethod());
                            if (mNode == null) {
                                mNode = new MethodNode(ThreadNode.this, inst.getMethod());
                                ThreadNode.this.methods.put(inst.getMethod(), mNode);
                                ThreadNode.this.sort = null;
                            }
                            MethodNode methodNode = mNode;
                            methodNode.count = methodNode.count + 1;
                            if (++count % 10000 == 0) {
                                ThreadNode.this.percentDone = count * 100 / TraceExplorerUI.this.trace.getNumberOfEventsInThread(ThreadNode.this.id);
                                TraceExplorerUI.this.repaint();
                                ThreadNode.this.sort();
                            }
                        }
                    }
                    ThreadNode.this.percentDone = 100;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            TraceExplorerUI.this.model.reload();
                            TraceExplorerUI.this.repaint();
                        }
                    });
                }
            };
            counter.start();
        }

        private synchronized MethodNode[] getSort() {
            if (this.sort == null) {
                this.sort();
            }
            return this.sort;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void sort() {
            ThreadNode threadNode = this;
            synchronized (threadNode) {
                this.sort = new MethodNode[this.methods.size()];
                this.methods.values().toArray(this.sort);
                Arrays.sort(this.sort, new Comparator<MethodNode>(){

                    @Override
                    public int compare(MethodNode o1, MethodNode o2) {
                        return o2.count - o1.count;
                    }
                });
            }
        }

        public Enumeration<MethodNode> children() {
            return new Enumeration<MethodNode>(){
                int i = 0;

                @Override
                public boolean hasMoreElements() {
                    return this.i < ThreadNode.this.getSort().length;
                }

                @Override
                public MethodNode nextElement() {
                    return ThreadNode.this.getSort()[this.i++];
                }
            };
        }

        @Override
        public int getIndex(TreeNode node) {
            int i = 0;
            while (i < this.getSort().length) {
                if (this.getSort()[i] == node) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public MethodNode getChildAt(int childIndex) {
            return this.getSort()[childIndex];
        }

        @Override
        public int getChildCount() {
            return this.getSort().length;
        }

        @Override
        public TreeNode getParent() {
            return TraceExplorerUI.this.root;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        public String toString() {
            return String.valueOf(Util.fillOrTruncateString(Integer.toString(TraceExplorerUI.this.trace.getNumberOfEventsInThread(this.id)), 10)) + TraceExplorerUI.this.trace.getThreadName(this.id) + (this.percentDone < 100 ? " (" + this.percentDone + "%)" : "");
        }
    }
}

