/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui;

import edu.cmu.hcii.whyline.source.Line;
import edu.cmu.hcii.whyline.trace.Serializer;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.events.AbstractUIEvent;
import edu.cmu.hcii.whyline.util.Util;
import gnu.trove.TLongHashSet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentState {
    private final WhylineUI whylineUI;
    private final Trace trace;
    private final File path;
    private boolean initialized = false;
    private int windowWidth;
    private int windowHeight;
    private ArrayList<String> unparsedLines = new ArrayList();
    private ArrayList<Line> relevantLines = new ArrayList();
    private TLongHashSet objects = new TLongHashSet();
    private ArrayList<String> log = new ArrayList(1000);

    public PersistentState(WhylineUI whylineUI) {
        this(whylineUI, whylineUI.getTrace(), new File(whylineUI.getTrace().getPath(), "usage.log"));
    }

    public PersistentState(WhylineUI whylineUI, Trace trace, File path) {
        this.trace = trace;
        this.path = path;
        this.whylineUI = whylineUI;
        this.windowWidth = 1024;
        this.windowHeight = 740;
        this.read();
    }

    public void read() {
        File file = this.path;
        if (!file.exists()) {
            return;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            PersistentState.readOpen(reader, "whyline");
            PersistentState.readOpen(reader, "window");
            this.windowWidth = Integer.parseInt(PersistentState.readValue(reader, "width"));
            this.windowHeight = Integer.parseInt(PersistentState.readValue(reader, "height"));
            PersistentState.readClose(reader, "window");
            PersistentState.readOpen(reader, "lines");
            int count = Integer.parseInt(PersistentState.readValue(reader, "count"));
            this.unparsedLines = new ArrayList(count);
            int i = 0;
            while (i < count) {
                this.unparsedLines.add(PersistentState.readValue(reader, "line"));
                ++i;
            }
            PersistentState.readClose(reader, "lines");
            PersistentState.readOpen(reader, "objects");
            count = Integer.parseInt(PersistentState.readValue(reader, "count"));
            this.objects = new TLongHashSet(count);
            i = 0;
            while (i < count) {
                this.objects.add(Long.valueOf(PersistentState.readValue(reader, "object")));
                ++i;
            }
            PersistentState.readClose(reader, "objects");
            PersistentState.readOpen(reader, "navigation");
            int numberOfNavs = Integer.parseInt(PersistentState.readValue(reader, "count"));
            i = 0;
            while (i < numberOfNavs) {
                this.log.add(PersistentState.readValue(reader, "event"));
                ++i;
            }
            PersistentState.readClose(reader, "navigation");
            PersistentState.readClose(reader, "whyline");
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void write() throws IOException {
        if (!this.initialized) {
            return;
        }
        File temp = new File(this.trace.getPath(), "usage.log.temp");
        temp.delete();
        temp.createNewFile();
        BufferedWriter writer = new BufferedWriter(new FileWriter(temp));
        int depth = 0;
        PersistentState.open(writer, depth++, "whyline");
        PersistentState.open(writer, depth++, "window");
        PersistentState.value(writer, depth, "width", Integer.toString(this.windowWidth));
        PersistentState.value(writer, depth, "height", Integer.toString(this.windowHeight));
        PersistentState.close(writer, --depth, "window");
        PersistentState.open(writer, depth++, "lines");
        PersistentState.value(writer, depth, "count", Integer.toString(this.relevantLines.size()));
        for (Line line : this.relevantLines) {
            PersistentState.value(writer, depth, "line", String.valueOf(line.getFile().getFileName()) + ":" + line.getLineNumber().getNumber());
        }
        PersistentState.close(writer, --depth, "lines");
        PersistentState.open(writer, depth++, "objects");
        PersistentState.value(writer, depth, "count", Integer.toString(this.objects.size()));
        long[] lArray = this.objects.toArray();
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long id = lArray[n2];
            PersistentState.value(writer, depth, "object", Long.toString(id));
            ++n2;
        }
        PersistentState.close(writer, --depth, "objects");
        PersistentState.open(writer, depth++, "navigation");
        PersistentState.value(writer, depth, "count", Integer.toString(this.log.size()));
        for (String event : this.log) {
            PersistentState.value(writer, depth, "event", event);
        }
        PersistentState.close(writer, --depth, "navigation");
        PersistentState.close(writer, --depth, "whyline");
        writer.flush();
        writer.close();
        File file = new File(this.trace.getPath(), "usage.log");
        file.delete();
        temp.renameTo(file);
    }

    private static void value(BufferedWriter writer, int depth, String tag, String value) throws IOException {
        writer.write(Util.fillString(' ', depth));
        writer.write("<");
        writer.write(tag);
        writer.write(">");
        writer.write(value);
        writer.write("</");
        writer.write(tag);
        writer.write(">\n");
    }

    private static String readValue(BufferedReader reader, String tag) throws IOException {
        int first;
        String line = reader.readLine();
        if (!line.substring(0, first = line.indexOf(62) + 1).contains(tag)) {
            throw new IOException("Expected tag " + tag);
        }
        int last = line.lastIndexOf(60) - 1;
        String value = line.substring(first, last + 1);
        return value;
    }

    private static void open(BufferedWriter writer, int depth, String tag) throws IOException {
        writer.write(Util.fillString(' ', depth));
        writer.write("<");
        writer.write(tag);
        writer.write(">\n");
    }

    private static void readOpen(BufferedReader reader, String tag) throws IOException {
        String line = reader.readLine();
        if (!line.contains(tag)) {
            throw new IOException("Expected <" + tag + "> but found line " + line);
        }
    }

    private static void close(BufferedWriter writer, int depth, String tag) throws IOException {
        writer.write(Util.fillString(' ', depth));
        writer.write("</");
        writer.write(tag);
        writer.write(">\n");
    }

    private static void readClose(BufferedReader reader, String tag) throws IOException {
        String line = reader.readLine();
        if (!line.contains(tag)) {
            throw new IOException("Expected </" + tag + "> but found line " + line);
        }
    }

    public synchronized void addNavigation(AbstractUIEvent<?> navigation) {
        String string = navigation.getParsableString();
        string = string.replace("\n", "\\n");
        this.log.add(string);
    }

    public void updateWindowSize(int width, int height) {
        this.windowWidth = width;
        this.windowHeight = height;
    }

    public synchronized boolean addRelevantLine(Line line) {
        boolean isNew;
        boolean bl = isNew = !this.relevantLines.contains(line);
        if (!isNew) {
            return false;
        }
        this.relevantLines.remove(line);
        this.relevantLines.add(line);
        this.whylineUI.getLinesUI().updateRelevantLines(line);
        return true;
    }

    public synchronized void addRelevantObject(long id) {
        this.objects.add(id);
    }

    public synchronized void removeRelevantObject(long id) {
        this.objects.remove(id);
    }

    public List<Line> getRelevantLines() {
        return this.relevantLines;
    }

    public int getWindowWidth() {
        return this.windowWidth;
    }

    public int getWindowHeight() {
        return this.windowHeight;
    }

    public void initializeState() {
        for (String text : this.unparsedLines) {
            this.addRelevantLine(Serializer.stringToLine(this.trace, text));
        }
        long[] lArray = this.objects.toArray();
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long id = lArray[n2];
            this.whylineUI.getObjectsUI().addObject(id);
            ++n2;
        }
        this.initialized = true;
    }

    public Iterable<String> getLog() {
        return this.log;
    }
}

