/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui;

import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.CodeAttribute;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.source.JavaSourceFile;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.components.HeadlinedPanel;
import edu.cmu.hcii.whyline.ui.components.WhylineControlBorder;
import edu.cmu.hcii.whyline.ui.components.WhylineScrollPane;
import edu.cmu.hcii.whyline.util.Util;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;

public class DocumentationUI
extends HeadlinedPanel {
    private JEditorPane doc = new JEditorPane("text/html", "");

    public DocumentationUI(WhylineUI whylineUI) {
        super("documentation", whylineUI);
        this.doc.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.doc.setBackground(UI.getControlBackColor());
        this.doc.setForeground(UI.getControlTextColor());
        this.doc.setOpaque(true);
        this.doc.setFont(UI.getMediumFont());
        this.doc.setEditable(false);
        WhylineScrollPane pane = new WhylineScrollPane(this.doc);
        pane.setHorizontalScrollBarPolicy(31);
        pane.setVerticalScrollBarPolicy(20);
        pane.setBorder(new WhylineControlBorder());
        this.setContent(pane);
        this.setMinimumSize(new Dimension(UI.getDefaultInfoPaneWidth(whylineUI), 0));
        this.doc.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    Util.openURL(e.getURL().toString());
                }
            }
        });
    }

    private String getMethodDescription(MethodInfo method) {
        String javadoc;
        CodeAttribute code = method.getCode();
        JavaSourceFile source = code == null ? null : code.getClassfile().getSourceFile();
        String string = javadoc = source == null ? null : source.getMethodJavaDoc(method);
        if (javadoc == null) {
            javadoc = "No documentation.";
        }
        javadoc = javadoc.replace("/**", "");
        int firstTagIndex = (javadoc = javadoc.replace("*/", "")).indexOf("* @");
        if (firstTagIndex > 0) {
            javadoc = javadoc.substring(0, firstTagIndex);
        }
        javadoc = javadoc.replace("*", "");
        return "<b><font size=+1>" + method.getJavaName() + "()</font></b>" + "<br><br>" + javadoc;
    }

    private String getClassDescription(Classfile classfile) {
        String javadoc;
        JavaSourceFile source = classfile.getSourceFile();
        String string = javadoc = source == null ? null : source.getClassJavaDoc(classfile);
        if (javadoc == null) {
            javadoc = "No documentation.";
        }
        javadoc = javadoc.replace("/**", "");
        int firstTagIndex = (javadoc = javadoc.replace("*/", "")).indexOf("* @");
        if (firstTagIndex > 0) {
            javadoc = javadoc.substring(0, firstTagIndex);
        }
        javadoc = javadoc.replace("*", "");
        return "<font size=+1><b>" + classfile.getSimpleName() + "</b></font>" + "<br><br>" + javadoc;
    }

    public void showMethod(MethodInfo method) {
        if (!this.whylineUI.isStaticInfoShowing()) {
            return;
        }
        this.showHTML(String.valueOf(this.getMethodDescription(method)) + "<br><br>" + this.getClassDescription(method.getClassfile()));
    }

    public void showInstruction(Instruction inst) {
        if (!this.whylineUI.isStaticInfoShowing()) {
            return;
        }
        if (inst == null) {
            return;
        }
        this.showMethod(inst.getMethod());
    }

    public void showClass(Classfile subject) {
        if (!this.whylineUI.isStaticInfoShowing()) {
            return;
        }
        this.showHTML(this.getClassDescription(subject));
    }

    private void showHTML(String text) {
        this.doc.setText("<html>" + text + "</html>");
        this.doc.setCaretPosition(0);
        if (this.doc.getDocument() instanceof HTMLDocument) {
            HTMLDocument document = (HTMLDocument)this.doc.getDocument();
            Color color = UI.getHighlightColor();
            document.getStyleSheet().addRule("a { color:rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "); }");
        }
    }
}

