/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui;

import edu.cmu.hcii.whyline.io.IOEvent;
import edu.cmu.hcii.whyline.io.IOHistory;
import edu.cmu.hcii.whyline.io.MouseStateInputEvent;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.events.AbstractUIEvent;
import edu.cmu.hcii.whyline.ui.events.LoggedAction;
import edu.cmu.hcii.whyline.ui.events.Note;
import edu.cmu.hcii.whyline.ui.qa.SituationUI;
import edu.cmu.hcii.whyline.ui.qa.Visualization;
import edu.cmu.hcii.whyline.ui.qa.VisualizationUI;
import edu.cmu.hcii.whyline.ui.views.View;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;

public class Actions {
    private final WhylineUI whylineUI;
    public final LoggedAction stepOver;
    public final LoggedAction stepInto;
    public final LoggedAction stepOut;
    public final LoggedAction stop;
    public final LoggedAction runToBreakpoint;
    public final LoggedAction clearBreakpoints;
    public final LoggedAction replayForSlicer;
    public final LoggedAction goToPreviousEvent;
    public final LoggedAction goToNextEvent;
    public final LoggedAction goToPreviousBlock;
    public final LoggedAction goToNextBlock;
    public final LoggedAction collapseBlock;
    public final LoggedAction addToExplanation;
    public final Action queryTrace;
    public final Action showHideThreads;

    public Actions(WhylineUI ui) {
        this.whylineUI = ui;
        this.stepOver = new LoggedAction(this.whylineUI, "over"){

            @Override
            protected AbstractUIEvent<?> act() {
                Actions.this.whylineUI.getBreakpointDebugger().stepOver();
                return null;
            }
        };
        this.stepInto = new LoggedAction(this.whylineUI, "into"){

            @Override
            protected AbstractUIEvent<?> act() {
                Actions.this.whylineUI.getBreakpointDebugger().stepInto();
                return null;
            }
        };
        this.stepOut = new LoggedAction(this.whylineUI, "out"){

            @Override
            protected AbstractUIEvent<?> act() {
                Actions.this.whylineUI.getBreakpointDebugger().stepOut();
                return null;
            }
        };
        this.runToBreakpoint = new LoggedAction(this.whylineUI, "run"){

            @Override
            protected AbstractUIEvent<?> act() {
                Actions.this.whylineUI.getBreakpointDebugger().runToBreakpoint();
                return null;
            }
        };
        this.stop = new LoggedAction(this.whylineUI, "stop"){

            @Override
            protected AbstractUIEvent<?> act() {
                Actions.this.whylineUI.getBreakpointDebugger().stop();
                return null;
            }
        };
        this.clearBreakpoints = new LoggedAction(this.whylineUI, "clear all breakpoints"){

            @Override
            protected AbstractUIEvent<?> act() {
                Actions.this.whylineUI.getBreakpointDebugger().clearBreakpointsAndPrints();
                return new Note("cleared breakpoints");
            }

            public AbstractUIEvent<?> getLogEvent() {
                return null;
            }
        };
        this.replayForSlicer = new LoggedAction(this.whylineUI, "replay"){
            private boolean playing;
            private boolean stop;
            private Thread playbackThread;
            {
                this.playing = false;
                this.stop = false;
            }

            @Override
            protected AbstractUIEvent<?> act() {
                if (this.playing) {
                    this.stop = true;
                    return null;
                }
                Actions.this.replayForSlicer.putValue("Name", "stop");
                this.playing = true;
                Actions.this.whylineUI.arrangeForPlayback();
                this.playbackThread = new Thread(){

                    public void run() {
                        IOHistory<MouseStateInputEvent> history = Actions.this.whylineUI.getTrace().getMouseHistory();
                        try {
                            for (final IOEvent iOEvent : history) {
                                if (stop) {
                                    stop = false;
                                    break;
                                }
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    public void run() {
                                        int time = iOEvent.getEventID();
                                        float percent = 100.0f * (float)time / (float)Actions.this.whylineUI.getTrace().getNumberOfEvents();
                                        Actions.this.whylineUI.setInputTime(time);
                                    }
                                });
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            invocationTargetException.printStackTrace();
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                Actions.this.whylineUI.arrangeForAsking();
                                ((this).this).Actions.this.replayForSlicer.putValue("Name", "replay");
                                playing = false;
                            }
                        });
                    }
                };
                this.playbackThread.start();
                return null;
            }
        };
        this.goToPreviousEvent = new LoggedAction(this.whylineUI, "go to previous event"){

            @Override
            protected AbstractUIEvent<?> act() {
                VisualizationUI visualizationUI = Actions.this.whylineUI.getVisualizationUIVisible();
                View before = visualizationUI.getEventBefore((View)visualizationUI.getSelection());
                if (before != null) {
                    visualizationUI.setSelection(before, true, "previousevent");
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
                return null;
            }
        };
        this.goToNextEvent = new LoggedAction(this.whylineUI, "go to next event"){

            @Override
            protected AbstractUIEvent<?> act() {
                VisualizationUI visualizationUI = Actions.this.whylineUI.getVisualizationUIVisible();
                View after = visualizationUI.getEventAfter((View)visualizationUI.getSelection());
                if (after != null) {
                    visualizationUI.setSelection(after, true, "nextevent");
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
                return null;
            }
        };
        this.goToPreviousBlock = new LoggedAction(this.whylineUI, "go to previous block"){

            @Override
            protected AbstractUIEvent<?> act() {
                VisualizationUI visualizationUI = Actions.this.whylineUI.getVisualizationUIVisible();
                View before = visualizationUI.getEnclosingBlock((View)visualizationUI.getSelection());
                if (before != null) {
                    visualizationUI.setSelection(before, true, "previousblock");
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
                return null;
            }
        };
        this.goToNextBlock = new LoggedAction(this.whylineUI, "go to next block"){

            @Override
            protected AbstractUIEvent<?> act() {
                VisualizationUI visualizationUI = Actions.this.whylineUI.getVisualizationUIVisible();
                View after = visualizationUI.getNextEnclosedBlock((View)visualizationUI.getSelection());
                if (after != null) {
                    visualizationUI.setSelection(after, true, "nextblock");
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
                return null;
            }
        };
        this.collapseBlock = new LoggedAction(this.whylineUI, "collapse block"){

            @Override
            protected AbstractUIEvent<?> act() {
                VisualizationUI visualizationUI = Actions.this.whylineUI.getVisualizationUIVisible();
                visualizationUI.getVisualization().collapseSelectedBlockView();
                return null;
            }
        };
        this.addToExplanation = new LoggedAction(this.whylineUI, "add to explanation"){

            @Override
            protected AbstractUIEvent<?> act() {
                VisualizationUI visualizationUI = Actions.this.whylineUI.getVisualizationUIVisible();
                visualizationUI.getVisualization().addNarrativeEntry();
                return null;
            }
        };
        this.queryTrace = new AbstractAction(){
            private String lastQuery = "";

            public void actionPerformed(ActionEvent e) {
            }
        };
        this.showHideThreads = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Visualization viz = Actions.this.whylineUI.getQuestionsUI().getSituationVisible().getVisualizationUI().getVisualization();
                SituationUI situationUI = Actions.this.whylineUI.getQuestionsUI().getSituationVisible();
                if (situationUI != null) {
                    viz.setThreadsVisible(!viz.areThreadsVisible());
                }
                if (situationUI.getVisualizationUI().getVisualization().getNumberOfThreadRows() == 1) {
                    this.putValue("SmallIcon", UI.HIDE_THREADS);
                    this.setEnabled(false);
                } else {
                    this.putValue("SmallIcon", viz.areThreadsVisible() ? UI.HIDE_THREADS : UI.SHOW_THREADS);
                }
            }
        };
    }
}

