/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.tracing;

import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.tracing.ClassInstrumenter;
import edu.cmu.hcii.whyline.util.Util;

class InstrumentationProfile {
    public final QualifiedClassName className;
    public final boolean instrumented;
    public final double totalSeconds;
    public final double readingTime;
    public final double writingTime;
    public final double instrumentationTime;
    public final double conversionTime;
    public final int numberOfInstructionsInstrumented;
    public final int totalInstructions;
    public final int numberOfMethodsInstrumented;

    public InstrumentationProfile(QualifiedClassName className, double totalTime, double readingTime, double writingTime, double instrumentingTime, double toArrayTime, int totalInstructions, int instructionInstrumented, int methodCount) {
        this.instrumented = true;
        this.className = className;
        this.totalSeconds = totalTime;
        this.readingTime = readingTime;
        this.writingTime = writingTime;
        this.instrumentationTime = instrumentingTime;
        this.conversionTime = toArrayTime;
        this.totalInstructions = totalInstructions;
        this.numberOfInstructionsInstrumented = instructionInstrumented;
        this.numberOfMethodsInstrumented = methodCount;
        if (this.instrumented) {
            ClassInstrumenter.totalNumberOfInstrumentedClasses += 1.0;
        }
        ClassInstrumenter.totalInstrumentationTime += instrumentingTime;
        ClassInstrumenter.totalReadingTime += readingTime;
        ClassInstrumenter.totalWritingTime += writingTime;
        ClassInstrumenter.totalConversionTime += this.conversionTime;
    }

    public InstrumentationProfile(QualifiedClassName className) {
        this.instrumented = false;
        this.className = className;
        this.totalSeconds = 0.0;
        this.instrumentationTime = 0.0;
        this.readingTime = 0.0;
        this.writingTime = 0.0;
        this.conversionTime = 0.0;
        this.totalInstructions = 0;
        this.numberOfInstructionsInstrumented = 0;
        this.numberOfMethodsInstrumented = 0;
    }

    public boolean skipped() {
        return !this.instrumented;
    }

    public String toString() {
        return String.valueOf(Util.fillOrTruncateString(this.className.getText(), 40)) + "   " + Util.fillOrTruncateString(this.instrumented ? "" + this.totalSeconds : "-", 10) + "   " + Util.fillOrTruncateString(this.instrumented ? this.readingTime + " (" + this.readingTime / this.totalSeconds + ")" : "-", 15) + "   " + Util.fillOrTruncateString(this.instrumented ? this.writingTime + " (" + this.writingTime / this.totalSeconds + ")" : "-", 15) + "   " + Util.fillOrTruncateString(this.instrumented ? this.instrumentationTime + " (" + this.instrumentationTime / this.totalSeconds + ")" : "-", 15) + "   " + Util.fillOrTruncateString(this.instrumented ? "" + this.conversionTime : "-", 10) + "   " + Util.fillOrTruncateString(this.instrumented ? "" + this.numberOfMethodsInstrumented : "-", 10) + "   " + Util.fillOrTruncateString(this.instrumented ? "" + this.totalInstructions : "-", 10) + "   " + Util.fillOrTruncateString(this.instrumented ? "" + this.numberOfInstructionsInstrumented : "-", 10);
    }

    public static String getHeader() {
        return String.valueOf(Util.fillOrTruncateString("Class", 40)) + "   " + Util.fillOrTruncateString("Total time", 10) + "   " + Util.fillOrTruncateString("Reading time", 15) + "   " + Util.fillOrTruncateString("Writing time", 15) + "   " + Util.fillOrTruncateString("Instrument time", 15) + "   " + Util.fillOrTruncateString("Conversion time", 10) + "   " + Util.fillOrTruncateString("Method count", 10) + "   " + Util.fillOrTruncateString("# instructions", 10) + "   " + Util.fillOrTruncateString("# instrumented", 10);
    }
}

