/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.trace.nodes;

import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.FieldInfo;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.trace.nodes.ArrayElementSeriesState;
import edu.cmu.hcii.whyline.trace.nodes.DynamicNode;
import edu.cmu.hcii.whyline.trace.nodes.FieldState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReferenceState
extends DynamicNode<ReferenceState> {
    protected final Trace trace;
    protected long objectID;
    protected int currentEventID;
    private int initID;

    public ReferenceState(Trace trace, long objectID) {
        this.trace = trace;
        this.objectID = objectID;
    }

    public int getCurrentEventID() {
        return this.currentEventID;
    }

    public Trace getTrace() {
        return this.trace;
    }

    public long getObjectID() {
        return this.objectID;
    }

    public boolean isUpdated() {
        return this.isUpdated;
    }

    public void propagateCurrentEventID(int eventID) {
        this.currentEventID = eventID;
        this.isUpdated = false;
        this.initID = this.trace.getInitializationOfObjectID(this.objectID);
        if (this.hasDeterminedChildren()) {
            for (ReferenceState node : this.getChildren()) {
                node.propagateCurrentEventID(this.currentEventID);
            }
        }
    }

    public abstract long getObjectIDForChildren();

    public boolean isInstantiated() {
        return this.initID < this.currentEventID;
    }

    @Override
    protected void determineChildren() {
        block6: {
            Classfile classfile;
            long objectIDForChildren;
            block5: {
                objectIDForChildren = this.getObjectIDForChildren();
                if (objectIDForChildren <= 0L) {
                    return;
                }
                QualifiedClassName name = this.trace.getClassnameOfObjectID(objectIDForChildren);
                if (!name.isArray()) break block5;
                int length = this.trace.getArrayLength(objectIDForChildren);
                if (length < 0) {
                    this.addChild(new Message(this.trace, "didn't record array length"));
                } else {
                    int range = 25;
                    int i = 0;
                    while (i < length) {
                        this.addChild(new ArrayElementSeriesState(this.trace, name, objectIDForChildren, i, Math.min(length - 1, i + range - 1)));
                        i += range;
                    }
                }
                break block6;
            }
            if (objectIDForChildren <= 0L || (classfile = this.trace.getClassfileOfObjectID(objectIDForChildren)) == null) break block6;
            for (FieldInfo field : classfile.getAllFields()) {
                if (field.isStatic()) continue;
                FieldState node = this.trace.getFieldNode(objectIDForChildren, field);
                this.addChild(node);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Message
    extends ReferenceState
    implements Comparable<ReferenceState> {
        private final String message;

        public Message(Trace trace, String message) {
            super(trace, -1L);
            this.message = message;
        }

        @Override
        public long getObjectIDForChildren() {
            return -1L;
        }

        @Override
        public int getAssociatedEventID() {
            return -1;
        }

        @Override
        public String getAssociatedEventIDDescription() {
            return "";
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        protected boolean performUpdate() {
            return false;
        }

        @Override
        public String toString() {
            return "<html><i>" + this.message + "</i>";
        }

        @Override
        public int compareTo(ReferenceState o) {
            return 0;
        }
    }
}

