/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.trace.nodes;

import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.trace.nodes.ReferenceState;
import edu.cmu.hcii.whyline.util.Named;
import edu.cmu.hcii.whyline.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectState
extends ReferenceState
implements Comparable<ObjectState>,
Named {
    public ObjectState(Trace trace, long objectID) {
        super(trace, objectID);
    }

    @Override
    public String getDisplayName(boolean html, int limit) {
        String entityDescription = this.trace.getDescriptionOfObjectID(this.objectID);
        QualifiedClassName classname = this.trace.getClassnameOfObjectID(this.objectID);
        Classfile classfile = this.trace.getClassfileByName(classname);
        String simpleName = classname == null ? "(unknown)" : (classname.isAnonymous() ? classfile.getSuperclass().getInternalName().getSimpleName() : classname.getSimpleName());
        String associatedName = this.trace.getAssociatedNameOfObjectID(this.objectID);
        if (limit > 0) {
            simpleName = Util.elide(simpleName, limit);
            if (associatedName != null) {
                associatedName = Util.elide(associatedName, limit);
            }
        }
        if (html) {
            return "<b>" + simpleName + "</b>" + (associatedName != null ? " <em>\"" + associatedName + "\"</em>" : "");
        }
        return String.valueOf(simpleName) + " " + (associatedName == null ? "" : associatedName);
    }

    @Override
    public int compareTo(ObjectState object) {
        return (int)(this.getObjectID() - object.getObjectID());
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public long getObjectIDForChildren() {
        return this.objectID;
    }

    @Override
    protected boolean performUpdate() {
        return false;
    }

    @Override
    public int getAssociatedEventID() {
        return this.trace.getInstantiationOf(this.getObjectID());
    }

    @Override
    public String getAssociatedEventIDDescription() {
        return "instantiation";
    }

    @Override
    public String toString() {
        String name = this.trace.getDescriptionOfObjectID(this.getObjectID());
        return this.isInstantiated() ? name : "<html><strike>" + name + "</strike>";
    }
}

