/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.trace.nodes;

import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.trace.nodes.DynamicNode;
import edu.cmu.hcii.whyline.trace.nodes.LocalState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameState
extends DynamicNode<LocalState>
implements Comparable<FrameState> {
    private LocalState[] locals;
    private final Trace trace;
    private final MethodInfo method;
    private final int startID;
    private final int invocationID;
    private int recentEventIDInCall;

    public FrameState(Trace trace, int startID, int invocationID) {
        this.trace = trace;
        this.startID = startID;
        this.invocationID = invocationID;
        this.recentEventIDInCall = startID;
        this.method = trace.getInstruction(startID).getMethod();
    }

    public int getInvocationID() {
        return this.invocationID;
    }

    @Override
    public int compareTo(FrameState object) {
        return object.startID - this.startID;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    protected void determineChildren() {
        int nextEventIDInThread;
        if (this.locals == null) {
            int numberOfLocals = this.method.getCode().getMaxLocals();
            this.locals = new LocalState[numberOfLocals];
            int localID = 0;
            while (localID < numberOfLocals) {
                this.locals[localID] = new LocalState(this.trace, localID);
                ++localID;
            }
        }
        int eventIDToShow = this.trace.getStartID(nextEventIDInThread = this.trace.getNextEventIDInThread(this.recentEventIDInCall)) == this.startID ? nextEventIDInThread : this.recentEventIDInCall;
        Instruction instructionAfter = this.trace.getInstruction(eventIDToShow);
        int numberOfLocals = this.method.getCode().getMaxLocals();
        int localID = 0;
        while (localID < numberOfLocals) {
            if (!instructionAfter.getCode().hasLocalVariableInfo() || instructionAfter.getCode().localIDIsDefinedAt(localID, instructionAfter)) {
                this.addChild(this.locals[localID]);
                this.locals[localID].propagateCurrentEventID(eventIDToShow);
            }
            ++localID;
        }
    }

    public void showEventID(int eventID) {
        int n = this.recentEventIDInCall = this.trace.getStartID(eventID) == this.startID ? eventID : this.invocationID;
        if (this.hasDeterminedChildren()) {
            this.resetChildren();
        }
    }

    public LocalState getLocalFor(int eventID) {
        if (this.hasDeterminedChildren()) {
            LocalState mostRecentlyAssignedLocal = null;
            for (LocalState local : this.getChildren()) {
                if (mostRecentlyAssignedLocal != null && local.getDefinitionID() <= mostRecentlyAssignedLocal.getDefinitionID()) continue;
                mostRecentlyAssignedLocal = local;
            }
            return mostRecentlyAssignedLocal;
        }
        return null;
    }

    @Override
    public int getAssociatedEventID() {
        return this.startID;
    }

    @Override
    public String getAssociatedEventIDDescription() {
        return "invocation";
    }

    @Override
    protected boolean performUpdate() {
        return false;
    }

    @Override
    public String toString() {
        return "<html>" + this.method.getClassfile().getSimpleName() + " : <b>" + this.method.getJavaName() + "</b>()";
    }
}

